/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.view;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperationFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.CarbonLockUtil;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.view.MVManager;
import org.apache.carbondata.core.view.MVSchema;
import org.apache.carbondata.core.view.MVStatus;
import org.apache.carbondata.core.view.MVStatusDetail;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public class MVProvider {
    private static final Logger LOG = LogServiceFactory.getLogService((String)MVProvider.class.getCanonicalName());
    private static final String STATUS_FILE_NAME = "mv_status";
    private final Map<String, SchemaProvider> schemaProviders = new ConcurrentHashMap<String, SchemaProvider>();

    private static String getSchemaPath(String schemaRoot, String viewName) {
        return schemaRoot + "/" + "mv_schema." + viewName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaProvider getSchemaProvider(MVManager viewManager, String databaseName) {
        String databaseNameUpper = databaseName.toUpperCase();
        SchemaProvider schemaProvider = this.schemaProviders.get(databaseNameUpper);
        if (schemaProvider == null) {
            Map<String, SchemaProvider> map = this.schemaProviders;
            synchronized (map) {
                schemaProvider = this.schemaProviders.get(databaseNameUpper);
                if (schemaProvider == null) {
                    String databaseLocation = viewManager.getDatabaseLocation(databaseName);
                    CarbonFile databasePath = FileFactory.getCarbonFile(databaseLocation);
                    if (!databasePath.exists()) {
                        return null;
                    }
                    schemaProvider = new SchemaProvider(databasePath.getCanonicalPath());
                    this.schemaProviders.put(databaseNameUpper, schemaProvider);
                }
            }
        }
        return schemaProvider;
    }

    public MVSchema getSchema(MVManager viewManager, String databaseName, String viewName) throws IOException {
        SchemaProvider schemaProvider = this.getSchemaProvider(viewManager, databaseName);
        if (schemaProvider == null) {
            return null;
        }
        return schemaProvider.retrieveSchema(viewManager, viewName);
    }

    List<MVSchema> getSchemas(MVManager viewManager, String databaseName, CarbonTable carbonTable) throws IOException {
        SchemaProvider schemaProvider = this.getSchemaProvider(viewManager, databaseName);
        if (schemaProvider == null) {
            return Collections.emptyList();
        }
        return schemaProvider.retrieveSchemas(viewManager, carbonTable);
    }

    List<MVSchema> getSchemas(MVManager viewManager, String databaseName) throws IOException {
        SchemaProvider schemaProvider = this.getSchemaProvider(viewManager, databaseName);
        if (schemaProvider == null) {
            return Collections.emptyList();
        }
        return schemaProvider.retrieveAllSchemas(viewManager);
    }

    void saveSchema(MVManager viewManager, String databaseName, MVSchema viewSchema) throws IOException {
        SchemaProvider schemaProvider = this.getSchemaProvider(viewManager, databaseName);
        if (schemaProvider == null) {
            throw new IOException("Database [" + databaseName + "] is not found.");
        }
        schemaProvider.saveSchema(viewManager, viewSchema);
    }

    public void dropSchema(MVManager viewManager, String databaseName, String viewName) throws IOException {
        SchemaProvider schemaProvider = this.getSchemaProvider(viewManager, databaseName);
        if (schemaProvider == null) {
            throw new IOException("Materialized view with name " + databaseName + "." + viewName + " does not exists in storage");
        }
        schemaProvider.dropSchema(viewName);
    }

    private String getStatusFileName(MVManager viewManager, String databaseName) {
        String databaseLocation = viewManager.getDatabaseLocation(databaseName);
        try {
            if (FileFactory.isFileExist(databaseLocation)) {
                return FileFactory.getCarbonFile(databaseLocation).getCanonicalPath() + "/" + "_system" + "/" + STATUS_FILE_NAME;
            }
            return null;
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to get mv status file for database " + databaseName), (Throwable)e);
            return null;
        }
    }

    public List<MVStatusDetail> getStatusDetails(MVManager viewManager, String databaseName) throws IOException {
        MVStatusDetail[] statusDetails;
        InputStreamReader inStream;
        BufferedReader buffReader;
        DataInputStream dataInputStream;
        Gson gsonObjectToRead;
        String statusPath;
        block7: {
            statusPath = this.getStatusFileName(viewManager, databaseName);
            if (statusPath == null) {
                return Collections.emptyList();
            }
            gsonObjectToRead = new Gson();
            dataInputStream = null;
            buffReader = null;
            inStream = null;
            if (FileFactory.isFileExist(statusPath)) break block7;
            List<MVStatusDetail> list = Collections.emptyList();
            CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
            return list;
        }
        try {
            dataInputStream = FileFactory.getDataInputStream(statusPath);
            inStream = new InputStreamReader((InputStream)dataInputStream, Charset.forName("UTF-8"));
            buffReader = new BufferedReader(inStream);
            statusDetails = (MVStatusDetail[])gsonObjectToRead.fromJson((Reader)buffReader, MVStatusDetail[].class);
        }
        catch (IOException e) {
            try {
                LOG.error((Object)"Failed to read MV status", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
                throw throwable;
            }
        }
        CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
        if (null == statusDetails) {
            return Collections.emptyList();
        }
        return Arrays.asList(statusDetails);
    }

    private static ICarbonLock getStatusLock(String databaseLocation) {
        return CarbonLockFactory.getSystemLevelCarbonLockObj(CarbonProperties.getInstance().getSystemFolderLocationPerDatabase(databaseLocation), "mvstatus.lock");
    }

    public void updateStatus(MVManager viewManager, List<MVSchema> schemaList, MVStatus status) throws IOException {
        if (schemaList == null || schemaList.size() == 0) {
            return;
        }
        HashMap<String, ArrayList<MVSchema>> schemasMapByDatabase = new HashMap<String, ArrayList<MVSchema>>();
        for (MVSchema mVSchema : schemaList) {
            String databaseName = mVSchema.getIdentifier().getDatabaseName().toLowerCase();
            ArrayList<MVSchema> schemas = (ArrayList<MVSchema>)schemasMapByDatabase.get(databaseName);
            if (schemas == null) {
                schemas = new ArrayList<MVSchema>();
                schemasMapByDatabase.put(databaseName, schemas);
            }
            schemas.add(mVSchema);
        }
        for (Map.Entry entry : schemasMapByDatabase.entrySet()) {
            this.updateStatus(viewManager, (String)entry.getKey(), (List)entry.getValue(), status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(MVManager viewManager, String databaseName, List<MVSchema> schemaList, MVStatus status) throws IOException {
        block11: {
            String databaseLocation = FileFactory.getCarbonFile(viewManager.getDatabaseLocation(databaseName)).getCanonicalPath();
            ICarbonLock carbonTableStatusLock = MVProvider.getStatusLock(databaseLocation);
            boolean locked = false;
            try {
                locked = carbonTableStatusLock.lockWithRetries();
                if (locked) {
                    LOG.info((Object)"Materialized view status lock has been successfully acquired.");
                    if (status == MVStatus.ENABLED && !MVProvider.isViewCanBeEnabled(schemaList.get(0))) {
                        return;
                    }
                    ArrayList<MVStatusDetail> statusDetailList = new ArrayList<MVStatusDetail>(this.getStatusDetails(viewManager, databaseName));
                    ArrayList<MVStatusDetail> changedStatusDetails = new ArrayList<MVStatusDetail>();
                    ArrayList<MVStatusDetail> newStatusDetails = new ArrayList<MVStatusDetail>();
                    for (MVSchema schema : schemaList) {
                        boolean exists = false;
                        for (MVStatusDetail statusDetail : statusDetailList) {
                            if (!statusDetail.getIdentifier().equals(schema.getIdentifier())) continue;
                            statusDetail.setStatus(status);
                            changedStatusDetails.add(statusDetail);
                            exists = true;
                        }
                        if (exists) continue;
                        newStatusDetails.add(new MVStatusDetail(schema.getIdentifier(), status));
                    }
                    if (newStatusDetails.size() > 0 && status != MVStatus.DROPPED) {
                        statusDetailList.addAll(newStatusDetails);
                    }
                    if (status == MVStatus.DROPPED) {
                        statusDetailList.removeAll(changedStatusDetails);
                    }
                    MVProvider.writeLoadDetailsIntoFile(this.getStatusFileName(viewManager, databaseName), statusDetailList.toArray(new MVStatusDetail[statusDetailList.size()]));
                    break block11;
                }
                String errorMsg = "Updating MV status is failed due to another process taken the lock for updating it";
                LOG.error((Object)errorMsg);
                throw new IOException(errorMsg + " Please try after some time.");
            }
            finally {
                if (locked) {
                    CarbonLockUtil.fileUnlock(carbonTableStatusLock, "indexstatus.lock");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeLoadDetailsIntoFile(String location, MVStatusDetail[] statusDetails) throws IOException {
        BufferedWriter brWriter;
        AtomicFileOperations fileWrite;
        block5: {
            FileFactory.touchFile(FileFactory.getCarbonFile(location), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            fileWrite = AtomicFileOperationFactory.getAtomicFileOperations(location);
            brWriter = null;
            DataOutputStream dataOutputStream = null;
            Gson gsonObjectToWrite = new Gson();
            try {
                dataOutputStream = fileWrite.openForWrite(FileWriteOperation.OVERWRITE);
                brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataOutputStream, Charset.forName("UTF-8")));
                String metadataInstance = gsonObjectToWrite.toJson((Object)statusDetails);
                brWriter.write(metadataInstance);
                if (null == brWriter) break block5;
            }
            catch (IOException ioe) {
                try {
                    LOG.error((Object)("Error message: " + ioe.getLocalizedMessage()));
                    fileWrite.setFailed();
                    throw ioe;
                }
                catch (Throwable throwable) {
                    if (null != brWriter) {
                        brWriter.flush();
                    }
                    CarbonUtil.closeStreams(brWriter);
                    fileWrite.close();
                    throw throwable;
                }
            }
            brWriter.flush();
        }
        CarbonUtil.closeStreams(brWriter);
        fileWrite.close();
    }

    private static boolean isViewCanBeEnabled(MVSchema schema) throws IOException {
        if (!schema.isRefreshIncremental()) {
            return true;
        }
        boolean isViewCanBeEnabled = true;
        String viewMetadataPath = CarbonTablePath.getMetadataPath(schema.getIdentifier().getTablePath());
        LoadMetadataDetails[] viewLoadMetadataDetails = SegmentStatusManager.readLoadMetadata(viewMetadataPath);
        HashMap viewSegmentMap = new HashMap();
        for (LoadMetadataDetails loadMetadataDetail : viewLoadMetadataDetails) {
            if (loadMetadataDetail.getSegmentStatus() != SegmentStatus.SUCCESS) continue;
            Map segmentMap = (Map)new Gson().fromJson(loadMetadataDetail.getExtraInfo(), Map.class);
            if (viewSegmentMap.isEmpty()) {
                viewSegmentMap.putAll(segmentMap);
                continue;
            }
            for (Map.Entry entry : segmentMap.entrySet()) {
                if (null == viewSegmentMap.get(entry.getKey())) continue;
                ((List)viewSegmentMap.get(entry.getKey())).addAll((Collection)entry.getValue());
            }
        }
        List<RelationIdentifier> relatedTables = schema.getRelatedTables();
        for (RelationIdentifier relatedTable : relatedTables) {
            List<String> relatedTableSegmentList = SegmentStatusManager.getValidSegmentList(relatedTable);
            if (relatedTableSegmentList.isEmpty()) continue;
            if (viewSegmentMap.isEmpty()) {
                isViewCanBeEnabled = false;
                continue;
            }
            isViewCanBeEnabled = ((List)viewSegmentMap.get(relatedTable.getDatabaseName() + "." + relatedTable.getTableName())).containsAll(relatedTableSegmentList);
        }
        return isViewCanBeEnabled;
    }

    private static final class SchemaProvider {
        private String systemDirectory;
        private String schemaIndexFilePath;
        private long lastModifiedTime;
        private Set<MVSchema> schemas = new HashSet<MVSchema>();

        SchemaProvider(String databaseLocation) {
            String systemDirectory;
            this.systemDirectory = systemDirectory = CarbonProperties.getInstance().getSystemFolderLocationPerDatabase(databaseLocation);
            this.schemaIndexFilePath = systemDirectory + "/" + "mv_schema_index";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void saveSchema(MVManager viewManager, MVSchema viewSchema) throws IOException {
            DataOutputStream dataOutputStream;
            BufferedWriter brWriter;
            block4: {
                brWriter = null;
                dataOutputStream = null;
                Gson gsonObjectToWrite = new Gson();
                String schemaPath = MVProvider.getSchemaPath(this.systemDirectory, viewSchema.getIdentifier().getTableName());
                if (FileFactory.isFileExist(schemaPath)) {
                    throw new IOException("Materialized view with name " + viewSchema.getIdentifier().getTableName() + " already exists in storage");
                }
                try {
                    FileFactory.mkdirs(this.systemDirectory);
                    FileFactory.createNewFile(schemaPath);
                    dataOutputStream = FileFactory.getDataOutputStream(schemaPath);
                    brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataOutputStream, Charset.forName("UTF-8")));
                    String metadataInstance = gsonObjectToWrite.toJson((Object)viewSchema);
                    brWriter.write(metadataInstance);
                    if (null == brWriter) break block4;
                }
                catch (Throwable throwable) {
                    if (null != brWriter) {
                        brWriter.flush();
                    }
                    this.schemas.add(viewSchema);
                    CarbonUtil.closeStreams(dataOutputStream, brWriter);
                    this.checkAndReloadSchemas(viewManager, true);
                    this.touchMDTFile();
                    throw throwable;
                }
                brWriter.flush();
            }
            this.schemas.add(viewSchema);
            CarbonUtil.closeStreams(dataOutputStream, brWriter);
            this.checkAndReloadSchemas(viewManager, true);
            this.touchMDTFile();
        }

        MVSchema retrieveSchema(MVManager viewManager, String viewName) throws IOException {
            this.checkAndReloadSchemas(viewManager, true);
            for (MVSchema schema : this.schemas) {
                if (!schema.getIdentifier().getTableName().equalsIgnoreCase(viewName)) continue;
                return schema;
            }
            return null;
        }

        List<MVSchema> retrieveSchemas(MVManager viewManager, CarbonTable carbonTable) throws IOException {
            this.checkAndReloadSchemas(viewManager, false);
            ArrayList<MVSchema> schemas = new ArrayList<MVSchema>();
            block0: for (MVSchema schema : this.schemas) {
                List<RelationIdentifier> parentTables = schema.getRelatedTables();
                for (RelationIdentifier identifier : parentTables) {
                    if (StringUtils.isNotEmpty((CharSequence)identifier.getTableId())) {
                        if (!identifier.getTableId().equalsIgnoreCase(carbonTable.getTableId())) continue;
                        schemas.add(schema);
                        continue block0;
                    }
                    if (!identifier.getTableName().equalsIgnoreCase(carbonTable.getTableName()) || !identifier.getDatabaseName().equalsIgnoreCase(carbonTable.getDatabaseName())) continue;
                    schemas.add(schema);
                    continue block0;
                }
            }
            return schemas;
        }

        List<MVSchema> retrieveAllSchemas(MVManager viewManager) throws IOException {
            this.checkAndReloadSchemas(viewManager, true);
            return new ArrayList<MVSchema>(this.schemas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<MVSchema> retrieveAllSchemasInternal(MVManager viewManager) throws IOException {
            HashSet<MVSchema> schemas = new HashSet<MVSchema>();
            CarbonFile carbonFile = FileFactory.getCarbonFile(this.systemDirectory);
            CarbonFile[] carbonFiles = carbonFile.listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile file) {
                    return file.getName().startsWith("mv_schema.");
                }
            });
            Gson gson = new Gson();
            for (CarbonFile file : carbonFiles) {
                DataInputStream dataInputStream = null;
                BufferedReader buffReader = null;
                InputStreamReader inStream = null;
                try {
                    String absolutePath = file.getAbsolutePath();
                    dataInputStream = FileFactory.getDataInputStream(absolutePath);
                    inStream = new InputStreamReader((InputStream)dataInputStream, Charset.forName("UTF-8"));
                    buffReader = new BufferedReader(inStream);
                    MVSchema schema = (MVSchema)gson.fromJson((Reader)buffReader, MVSchema.class);
                    schema.setManager(viewManager);
                    schemas.add(schema);
                }
                catch (Throwable throwable) {
                    CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
                    throw throwable;
                }
                CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
            }
            return schemas;
        }

        void dropSchema(String viewName) throws IOException {
            String schemaPath = MVProvider.getSchemaPath(this.systemDirectory, viewName);
            if (!FileFactory.isFileExist(schemaPath)) {
                throw new IOException("Materialized with name " + viewName + " does not exists in storage");
            }
            LOG.info((Object)String.format("Trying to delete materialized view %s schema", viewName));
            this.schemas.removeIf(schema -> schema.getIdentifier().getTableName().equalsIgnoreCase(viewName));
            this.touchMDTFile();
            if (!FileFactory.deleteFile(schemaPath)) {
                throw new IOException("Materialized view with name " + viewName + " cannot be deleted");
            }
            LOG.info((Object)String.format("Materialized view %s schema is deleted", viewName));
        }

        private void checkAndReloadSchemas(MVManager viewManager, boolean touchFile) throws IOException {
            if (FileFactory.isFileExist(this.schemaIndexFilePath)) {
                long lastModifiedTime = FileFactory.getCarbonFile(this.schemaIndexFilePath).getLastModifiedTime();
                if (this.lastModifiedTime != lastModifiedTime) {
                    this.schemas = this.retrieveAllSchemasInternal(viewManager);
                    this.touchMDTFile();
                }
            } else {
                this.schemas = this.retrieveAllSchemasInternal(viewManager);
                if (touchFile) {
                    this.touchMDTFile();
                }
            }
        }

        private void touchMDTFile() throws IOException {
            if (!FileFactory.isFileExist(this.systemDirectory)) {
                FileFactory.createDirectoryAndSetPermission(this.systemDirectory, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            }
            if (!FileFactory.isFileExist(this.schemaIndexFilePath)) {
                FileFactory.createNewFile(this.schemaIndexFilePath, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            }
            long lastModifiedTime = System.currentTimeMillis();
            FileFactory.getCarbonFile(this.schemaIndexFilePath).setLastModifiedTime(lastModifiedTime);
            this.lastModifiedTime = lastModifiedTime;
        }
    }
}

