/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.view;

import com.google.gson.Gson;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.carbondata.common.Strings;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.view.MVManager;
import org.apache.carbondata.core.view.MVStatus;
import org.apache.carbondata.core.view.MVStatusDetail;

public class MVSchema
implements Serializable,
Writable {
    private static final long serialVersionUID = 1030007239497486385L;
    protected RelationIdentifier identifier;
    private String query;
    protected Map<String, String> properties;
    private List<RelationIdentifier> relatedTables;
    private Map<String, Set<String>> relatedTableColumnList;
    private Map<Integer, String> columnsOrderMap;
    private boolean timeSeries;
    private volatile transient MVManager manager;

    public MVSchema(MVManager manager) {
        this.manager = manager;
    }

    public RelationIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(RelationIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setRelatedTables(List<RelationIdentifier> relatedTables) {
        this.relatedTables = relatedTables;
    }

    public List<RelationIdentifier> getRelatedTables() {
        return this.relatedTables;
    }

    public boolean isRefreshOnManual() {
        String refreshTriggerMode = this.getProperties().get("refresh_trigger_mode");
        return refreshTriggerMode != null && refreshTriggerMode.equalsIgnoreCase("on_manual");
    }

    public boolean isRefreshIncremental() {
        String refreshMode = this.getProperties().get("refresh_mode");
        return refreshMode != null && refreshMode.equalsIgnoreCase("incremental");
    }

    @Override
    public void write(DataOutput out) throws IOException {
        boolean isRelationIdentifierExists = null != this.identifier;
        out.writeBoolean(isRelationIdentifierExists);
        if (isRelationIdentifierExists) {
            this.identifier.write(out);
        }
        if (this.properties == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.properties.size());
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        boolean isRelationIdentifierExists = in.readBoolean();
        if (isRelationIdentifierExists) {
            this.identifier = new RelationIdentifier(null, null, null);
            this.identifier.readFields(in);
        }
        int mapSize = in.readShort();
        this.properties = new HashMap<String, String>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.properties.put(key, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MVSchema that = (MVSchema)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public Map<String, Set<String>> getRelatedTableColumns() {
        return this.relatedTableColumnList;
    }

    public void setRelatedTableColumnList(Map<String, Set<String>> relatedTableColumnList) {
        this.relatedTableColumnList = relatedTableColumnList;
    }

    public Map<Integer, String> getColumnsOrderMap() {
        return this.columnsOrderMap;
    }

    public void setColumnsOrderMap(Map<Integer, String> columnsOrderMap) {
        this.columnsOrderMap = columnsOrderMap;
    }

    public boolean isTimeSeries() {
        return this.timeSeries;
    }

    public void setTimeSeries(boolean timeSeries) {
        this.timeSeries = timeSeries;
    }

    public String getPropertiesAsString() {
        String[] properties = (String[])this.getProperties().entrySet().stream().map(p -> "'" + (String)p.getKey() + "'='" + (String)p.getValue() + "'").sorted().toArray(String[]::new);
        return Strings.mkString((String[])properties, (String)",");
    }

    public MVStatus getStatus() throws IOException {
        List<MVStatusDetail> details = this.manager.getEnabledStatusDetails(this.identifier.getDatabaseName());
        for (MVStatusDetail detail : details) {
            if (!detail.getIdentifier().equals(this.getIdentifier())) continue;
            return MVStatus.ENABLED;
        }
        return MVStatus.DISABLED;
    }

    public String getSyncStatus() {
        LoadMetadataDetails[] loads = SegmentStatusManager.readLoadMetadata(CarbonTablePath.getMetadataPath(this.getIdentifier().getTablePath()));
        if (loads.length > 0) {
            for (int i = loads.length - 1; i >= 0; --i) {
                LoadMetadataDetails load = loads[i];
                if (!load.getSegmentStatus().equals((Object)SegmentStatus.SUCCESS)) continue;
                Map segmentMaps = (Map)new Gson().fromJson(load.getExtraInfo(), Map.class);
                HashMap syncInfoMap = new HashMap();
                for (Map.Entry entry : segmentMaps.entrySet()) {
                    if (((List)entry.getValue()).isEmpty()) {
                        syncInfoMap.put(entry.getKey(), "NA");
                        continue;
                    }
                    syncInfoMap.put(entry.getKey(), MVSchema.getMaxSegmentID((List)entry.getValue()));
                }
                String loadEndTime = load.getLoadEndTime() == -1L ? "NA" : new Timestamp(load.getLoadEndTime()).toString();
                syncInfoMap.put("load_sync_time", loadEndTime);
                return new Gson().toJson(syncInfoMap);
            }
        }
        return "NA";
    }

    private static String getMaxSegmentID(List<String> segmentList) {
        double[] segment = new double[segmentList.size()];
        int i = 0;
        for (String id : segmentList) {
            segment[i] = Double.parseDouble(id);
            ++i;
        }
        Arrays.sort(segment);
        String maxId = Double.toString(segment[segmentList.size() - 1]);
        if (maxId.endsWith(".0")) {
            maxId = maxId.substring(0, maxId.indexOf("."));
        }
        return maxId;
    }

    public void setManager(MVManager manager) {
        this.manager = manager;
    }
}

