/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.writer;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.mutate.DeleteDeltaBlockDetails;
import org.apache.carbondata.core.writer.CarbonDeleteDeltaWriter;
import org.apache.log4j.Logger;

public class CarbonDeleteDeltaWriterImpl
implements CarbonDeleteDeltaWriter {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonDeleteDeltaWriterImpl.class.getName());
    private String filePath;
    private DataOutputStream dataOutStream = null;

    public CarbonDeleteDeltaWriterImpl(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public void write(DeleteDeltaBlockDetails deleteDeltaBlockDetails) throws IOException {
        BufferedWriter brWriter = null;
        try {
            FileFactory.createNewFile(this.filePath);
            this.dataOutStream = FileFactory.getDataOutputStream(this.filePath);
            Gson gsonObjectToWrite = new Gson();
            brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.dataOutStream, "UTF-8"));
            String deletedData = gsonObjectToWrite.toJson((Object)deleteDeltaBlockDetails);
            brWriter.write(deletedData);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)("Error message: " + ioe.getLocalizedMessage()));
            throw ioe;
        }
        finally {
            if (null != brWriter) {
                brWriter.flush();
            }
            if (null != this.dataOutStream) {
                this.dataOutStream.flush();
            }
            if (null != brWriter) {
                brWriter.close();
            }
        }
    }
}

