/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.writer;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.ThriftWriter;
import org.apache.carbondata.format.MergedBlockIndex;
import org.apache.carbondata.format.MergedBlockIndexHeader;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class CarbonIndexFileMergeWriter {
    private CarbonTable table;
    private ThriftWriter thriftWriter;
    private Logger LOGGER = LogServiceFactory.getLogService((String)this.getClass().getCanonicalName());

    public CarbonIndexFileMergeWriter(CarbonTable table) {
        this.table = table;
    }

    private String mergeCarbonIndexFilesOfSegment(String segmentId, String tablePath, List<String> indexFileNamesTobeAdded, boolean readFileFooterFromCarbonDataFile, String uuid, String partitionPath) {
        try {
            CarbonFile[] indexFiles;
            Segment segment = Segment.getSegment(segmentId, tablePath);
            String segmentPath = CarbonTablePath.getSegmentPath(tablePath, segmentId);
            SegmentFileStore sfs = null;
            if (segment != null && segment.getSegmentFileName() != null) {
                sfs = new SegmentFileStore(tablePath, segment.getSegmentFileName());
                List<CarbonFile> indexCarbonFiles = sfs.getIndexCarbonFiles();
                if (this.table.isHivePartitionTable()) {
                    ArrayList<CarbonFile> indexFilesInPartition = new ArrayList<CarbonFile>();
                    for (CarbonFile indexCarbonFile : indexCarbonFiles) {
                        if (!FileFactory.getUpdatedFilePath(indexCarbonFile.getParentFile().getPath()).equals(partitionPath)) continue;
                        indexFilesInPartition.add(indexCarbonFile);
                    }
                    indexFiles = indexFilesInPartition.toArray(new CarbonFile[indexFilesInPartition.size()]);
                } else {
                    indexFiles = indexCarbonFiles.toArray(new CarbonFile[indexCarbonFiles.size()]);
                }
            } else {
                indexFiles = SegmentIndexFileStore.getCarbonIndexFiles(segmentPath, FileFactory.getConfiguration());
            }
            if (this.isCarbonIndexFilePresent(indexFiles) || indexFileNamesTobeAdded != null) {
                if (sfs == null) {
                    return this.writeMergeIndexFileBasedOnSegmentFolder(indexFileNamesTobeAdded, readFileFooterFromCarbonDataFile, segmentPath, indexFiles, segmentId);
                }
                return this.writeMergeIndexFileBasedOnSegmentFile(segmentId, indexFileNamesTobeAdded, sfs, indexFiles, uuid, partitionPath);
            }
        }
        catch (Exception e) {
            this.LOGGER.error((Object)("Failed to merge index files in path: " + tablePath), (Throwable)e);
        }
        return null;
    }

    public SegmentFileStore.FolderDetails mergeCarbonIndexFilesOfSegment(String segmentId, String tablePath, String partitionPath, List<String> partitionInfo, String uuid, String tempFolderPath, String currPartitionSpec) throws IOException {
        SegmentIndexFileStore fileStore = new SegmentIndexFileStore();
        String partitionTempPath = "";
        for (String partition : partitionInfo) {
            if (!partitionPath.equalsIgnoreCase(partition)) continue;
            partitionTempPath = partition + "/" + tempFolderPath;
            break;
        }
        if (null != partitionPath && !partitionTempPath.isEmpty()) {
            fileStore.readAllIIndexOfSegment(partitionTempPath);
        }
        Map<String, byte[]> indexMap = fileStore.getCarbonIndexMapWithFullPath();
        HashMap<String, HashMap<String, byte[]>> indexLocationMap = new HashMap<String, HashMap<String, byte[]>>();
        for (Map.Entry<String, byte[]> entry : indexMap.entrySet()) {
            Path path = new Path(entry.getKey());
            HashMap<String, byte[]> map = (HashMap<String, byte[]>)indexLocationMap.get(path.getParent().toString());
            if (map == null) {
                map = new HashMap<String, byte[]>();
                indexLocationMap.put(path.getParent().toString(), map);
            }
            map.put(path.getName(), entry.getValue());
        }
        SegmentFileStore.FolderDetails folderDetails = null;
        for (Map.Entry entry : indexLocationMap.entrySet()) {
            String mergeIndexFile = this.writeMergeIndexFile(null, partitionPath, (Map)entry.getValue(), segmentId);
            folderDetails = new SegmentFileStore.FolderDetails();
            folderDetails.setMergeFileName(mergeIndexFile);
            folderDetails.setStatus("Success");
            ArrayList<String> partitions = new ArrayList<String>();
            if (partitionPath.startsWith(tablePath)) {
                partitionPath = partitionPath.substring(tablePath.length() + 1, partitionPath.length());
                partitions.addAll(Arrays.asList(partitionPath.split("/")));
                folderDetails.setPartitions(partitions);
                folderDetails.setRelative(true);
                continue;
            }
            if (currPartitionSpec != null) {
                PartitionSpec writeSpec;
                ArrayList partitionSpecs = (ArrayList)ObjectSerializationUtil.convertStringToObject(currPartitionSpec);
                int index = partitionSpecs.indexOf(writeSpec = new PartitionSpec(null, partitionPath));
                if (index > -1) {
                    PartitionSpec spec = (PartitionSpec)partitionSpecs.get(index);
                    folderDetails.setPartitions(spec.getPartitions());
                    folderDetails.setRelative(false);
                    continue;
                }
                throw new IOException("Unable to get PartitionSpec for: " + partitionPath);
            }
            throw new IOException("Unable to get PartitionSpec for: " + partitionPath);
        }
        return folderDetails;
    }

    private String writeMergeIndexFileBasedOnSegmentFolder(List<String> indexFileNamesTobeAdded, boolean readFileFooterFromCarbonDataFile, String segmentPath, CarbonFile[] indexFiles, String segmentId) throws IOException {
        SegmentIndexFileStore fileStore = new SegmentIndexFileStore();
        if (readFileFooterFromCarbonDataFile) {
            fileStore.readAllIndexAndFillBolckletInfo(segmentPath);
        } else {
            fileStore.readAllIIndexOfSegment(segmentPath);
        }
        Map<String, byte[]> indexMap = fileStore.getCarbonIndexMap();
        this.writeMergeIndexFile(indexFileNamesTobeAdded, segmentPath, indexMap, segmentId);
        for (CarbonFile indexFile : indexFiles) {
            indexFile.delete();
        }
        return null;
    }

    public String writeMergeIndexFileBasedOnSegmentFile(String segmentId, List<String> indexFileNamesTobeAdded, SegmentFileStore segmentFileStore, CarbonFile[] indexFiles, String uuid, String partitionPath) throws IOException {
        SegmentIndexFileStore fileStore = new SegmentIndexFileStore();
        if (null != partitionPath) {
            for (CarbonFile indexFile : indexFiles) {
                fileStore.readIndexFile(indexFile);
            }
        } else {
            fileStore.readAllIIndexOfSegment(segmentFileStore.getSegmentFile(), segmentFileStore.getTablePath(), SegmentStatus.SUCCESS, true);
        }
        Map<String, byte[]> indexMap = fileStore.getCarbonIndexMapWithFullPath();
        HashMap indexLocationMap = new HashMap();
        for (Map.Entry<String, byte[]> entry : indexMap.entrySet()) {
            Path path = new Path(entry.getKey());
            HashMap map = (HashMap)indexLocationMap.get(path.getParent().toString());
            if (map == null) {
                map = new HashMap();
                indexLocationMap.put(path.getParent().toString(), map);
            }
            map.put(path.getName(), entry.getValue());
        }
        List<PartitionSpec> partitionSpecs = SegmentFileStore.getPartitionSpecs(segmentId, this.table.getTablePath(), SegmentStatusManager.readLoadMetadata(CarbonTablePath.getMetadataPath(this.table.getTablePath())));
        for (Map.Entry entry : indexLocationMap.entrySet()) {
            String mergeIndexFile = this.writeMergeIndexFile(indexFileNamesTobeAdded, (String)entry.getKey(), (Map)entry.getValue(), segmentId);
            for (Map.Entry<String, SegmentFileStore.FolderDetails> segentry : segmentFileStore.getLocationMap().entrySet()) {
                String location = segentry.getKey();
                if (segentry.getValue().isRelative()) {
                    location = segmentFileStore.getTablePath() + "/" + location;
                }
                if (!FileFactory.getCarbonFile((String)entry.getKey()).equals(FileFactory.getCarbonFile(location))) continue;
                segentry.getValue().setMergeFileName(mergeIndexFile);
                segentry.getValue().setFiles(new HashSet<String>());
                break;
            }
            if (!this.table.isHivePartitionTable()) continue;
            for (PartitionSpec partitionSpec : partitionSpecs) {
                if (!partitionSpec.getLocation().toString().equals(partitionPath)) continue;
                SegmentFileStore.writeSegmentFile(this.table.getTablePath(), mergeIndexFile, partitionPath, segmentId + "_" + uuid + "", partitionSpec.getPartitions(), true);
            }
        }
        String newSegmentFileName = SegmentFileStore.genSegmentFileName(segmentId, uuid) + ".segment";
        String string = CarbonTablePath.getSegmentFilesLocation(this.table.getTablePath()) + "/" + newSegmentFileName;
        if (!this.table.isHivePartitionTable()) {
            SegmentFileStore.writeSegmentFile(segmentFileStore.getSegmentFile(), string);
            SegmentFileStore.updateTableStatusFile(this.table, segmentId, newSegmentFileName, this.table.getCarbonTableIdentifier().getTableId(), segmentFileStore);
        }
        for (CarbonFile file : indexFiles) {
            file.delete();
        }
        return uuid;
    }

    private String writeMergeIndexFile(List<String> indexFileNamesTobeAdded, String segmentPath, Map<String, byte[]> indexMap, String segment_id) throws IOException {
        MergedBlockIndexHeader indexHeader = new MergedBlockIndexHeader();
        MergedBlockIndex mergedBlockIndex = new MergedBlockIndex();
        ArrayList<String> fileNames = new ArrayList<String>(indexMap.size());
        ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>(indexMap.size());
        for (Map.Entry<String, byte[]> entry : indexMap.entrySet()) {
            if (indexFileNamesTobeAdded != null && !indexFileNamesTobeAdded.contains(entry.getKey())) continue;
            fileNames.add(entry.getKey());
            data.add(ByteBuffer.wrap(entry.getValue()));
        }
        if (fileNames.size() > 0) {
            String mergeIndexName = segment_id + '_' + System.currentTimeMillis() + ".carbonindexmerge";
            this.openThriftWriter(segmentPath + "/" + mergeIndexName);
            indexHeader.setFile_names(fileNames);
            mergedBlockIndex.setFileData(data);
            this.writeMergedBlockIndexHeader(indexHeader);
            this.writeMergedBlockIndex(mergedBlockIndex);
            this.close();
            return mergeIndexName;
        }
        return null;
    }

    public String mergeCarbonIndexFilesOfSegment(String segmentId, String uuid, String tablePath, String partitionPath) {
        return this.mergeCarbonIndexFilesOfSegment(segmentId, tablePath, null, false, uuid, partitionPath);
    }

    public String mergeCarbonIndexFilesOfSegment(String segmentId, String tablePath, boolean readFileFooterFromCarbonDataFile, String uuid) {
        return this.mergeCarbonIndexFilesOfSegment(segmentId, tablePath, null, readFileFooterFromCarbonDataFile, uuid, null);
    }

    private boolean isCarbonIndexFilePresent(CarbonFile[] indexFiles) {
        for (CarbonFile file : indexFiles) {
            if (!file.getName().endsWith(".carbonindex")) continue;
            return true;
        }
        return false;
    }

    private void writeMergedBlockIndexHeader(MergedBlockIndexHeader indexObject) throws IOException {
        this.thriftWriter.write((TBase)indexObject);
    }

    private void writeMergedBlockIndex(MergedBlockIndex indexObject) throws IOException {
        this.thriftWriter.write((TBase)indexObject);
    }

    private void openThriftWriter(String filePath) throws IOException {
        this.thriftWriter = new ThriftWriter(filePath, false);
        this.thriftWriter.open(FileWriteOperation.OVERWRITE);
    }

    private void close() throws IOException {
        this.thriftWriter.close();
    }

    public static class SegmentIndexFIleMergeStatus
    implements Serializable {
        private SegmentFileStore.SegmentFile segmentFile;
        private List<String> filesTobeDeleted;

        public SegmentIndexFIleMergeStatus(SegmentFileStore.SegmentFile segmentFile, List<String> filesTobeDeleted) {
            this.segmentFile = segmentFile;
            this.filesTobeDeleted = filesTobeDeleted;
        }

        public SegmentFileStore.SegmentFile getSegmentFile() {
            return this.segmentFile;
        }

        public List<String> getFilesTobeDeleted() {
            return this.filesTobeDeleted;
        }
    }
}

