/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.writer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperationFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ThriftWriter {
    private static final int bufferSize = 2048;
    private String fileName;
    private DataOutputStream dataOutputStream;
    private TProtocol binaryOut;
    private AtomicFileOperations atomicFileOperationsWriter;
    private boolean append;

    public ThriftWriter(String fileName, boolean append) {
        this.fileName = fileName;
        this.append = append;
    }

    public void open() throws IOException {
        this.dataOutputStream = FileFactory.getDataOutputStream(this.fileName, 2048, this.append);
        this.binaryOut = new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)this.dataOutputStream));
    }

    public void open(FileWriteOperation fileWriteOperation) throws IOException {
        this.atomicFileOperationsWriter = AtomicFileOperationFactory.getAtomicFileOperations(this.fileName);
        this.dataOutputStream = this.atomicFileOperationsWriter.openForWrite(fileWriteOperation);
        this.binaryOut = new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)this.dataOutputStream));
    }

    public boolean isOpen() {
        return null != this.binaryOut && null != this.dataOutputStream;
    }

    public void write(TBase t) throws IOException {
        try {
            t.write(this.binaryOut);
            this.dataOutputStream.flush();
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        this.closeAtomicFileWriter();
        CarbonUtil.closeStream(this.dataOutputStream);
    }

    private void closeAtomicFileWriter() throws IOException {
        if (null != this.atomicFileOperationsWriter) {
            this.atomicFileOperationsWriter.close();
            this.dataOutputStream = null;
        }
    }
}

