/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.events;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.carbondata.events.Event;
import org.apache.carbondata.events.OperationContext;
import org.apache.carbondata.events.OperationEventListener;

public class OperationListenerBus {
    private static final OperationListenerBus INSTANCE = new OperationListenerBus();
    protected Map<String, CopyOnWriteArrayList<OperationEventListener>> eventMap = new ConcurrentHashMap<String, CopyOnWriteArrayList<OperationEventListener>>(16);

    public static OperationListenerBus getInstance() {
        return INSTANCE;
    }

    public synchronized OperationListenerBus addListener(Class<? extends Event> eventClass, OperationEventListener operationEventListener) {
        String eventType = eventClass.getName();
        CopyOnWriteArrayList<OperationEventListener> operationEventListeners = this.eventMap.get(eventType);
        if (null == operationEventListeners) {
            operationEventListeners = new CopyOnWriteArrayList();
            this.eventMap.put(eventType, operationEventListeners);
        }
        operationEventListeners.addIfAbsent(operationEventListener);
        return INSTANCE;
    }

    public void fireEvent(Event event, OperationContext operationContext) throws Exception {
        if (operationContext == null) {
            throw new Exception("OperationContext cannot be null");
        }
        List operationEventListeners = this.eventMap.get(event.getEventType());
        if (null != operationEventListeners) {
            for (OperationEventListener operationEventListener : operationEventListeners) {
                operationEventListener.onEvent(event, operationContext);
            }
        }
    }
}

