/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.core.datastore.block.Distributable;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.indexstore.row.IndexRow;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.stream.ExtendedByteArrayInputStream;
import org.apache.carbondata.core.stream.ExtendedDataInputStream;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.internal.index.Block;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CarbonInputSplit
extends FileSplit
implements Distributable,
Serializable,
Writable,
Block {
    private static final long serialVersionUID = 3520344046772190207L;
    public String taskId;
    private Segment segment;
    private String bucketId;
    private String blockletId;
    private int numberOfBlocklets;
    private ColumnarFormatVersion version;
    private String[] deleteDeltaFiles;
    private BlockletDetailInfo detailInfo;
    private FileFormat fileFormat = FileFormat.COLUMNAR_V3;
    private String indexWritePath;
    private Set<Integer> validBlockletIds;
    private transient IndexRow indexRow;
    private transient List<ColumnSchema> columnSchema;
    private boolean useMinMaxForPruning = true;
    private boolean isBlockCache = true;
    private String filePath;
    private long start;
    private long length;
    private String[] location;
    private transient SplitLocationInfo[] hostInfos;
    private transient Path path;
    private transient String blockPath;
    private byte[] serializeData;
    private int offset;
    private int actualLen;
    private boolean writeDetailInfo = true;
    private int rowCount;

    public CarbonInputSplit() {
        this.segment = null;
        this.taskId = "0";
        this.bucketId = "0";
        this.blockletId = "0";
        this.numberOfBlocklets = 0;
        this.version = CarbonProperties.getInstance().getFormatVersion();
    }

    public CarbonInputSplit(int serializeLen, DataInput in, String filePath, String[] allLocation, String blockletId) throws IOException {
        this.filePath = filePath;
        this.blockletId = blockletId;
        ExtendedByteArrayInputStream underlineStream = ((ExtendedDataInputStream)in).getUnderlineStream();
        int currentPosition = underlineStream.getPosition();
        short numberOfLocations = in.readShort();
        if (numberOfLocations > 0) {
            this.location = new String[numberOfLocations];
            for (int i = 0; i < this.location.length; ++i) {
                this.location[i] = allLocation[in.readShort()];
            }
        }
        this.start = in.readLong();
        this.length = in.readLong();
        this.version = ColumnarFormatVersion.valueOf(in.readShort());
        this.rowCount = in.readInt();
        if (in.readBoolean()) {
            int numberOfDeleteDeltaFiles = in.readInt();
            this.deleteDeltaFiles = new String[numberOfDeleteDeltaFiles];
            for (int i = 0; i < numberOfDeleteDeltaFiles; ++i) {
                this.deleteDeltaFiles[i] = in.readUTF();
            }
        }
        int leftoverPosition = underlineStream.getPosition();
        int newPosition = currentPosition + serializeLen;
        underlineStream.setPosition(newPosition);
        this.serializeData = underlineStream.getBuffer();
        this.offset = leftoverPosition;
        this.actualLen = serializeLen - (leftoverPosition - currentPosition);
        String taskNo = CarbonTablePath.DataFileUtil.getTaskNo(this.filePath);
        if (taskNo.contains("_")) {
            taskNo = taskNo.split("_")[0];
        }
        this.taskId = taskNo;
        this.bucketId = CarbonTablePath.DataFileUtil.getBucketNo(this.filePath);
    }

    private CarbonInputSplit(String segmentId, String blockletId, String filePath, long start, long length, ColumnarFormatVersion version, String[] deleteDeltaFiles, String indexWritePath) {
        String taskNo;
        this.filePath = filePath;
        this.start = start;
        this.length = length;
        if (null != segmentId) {
            this.segment = Segment.toSegment(segmentId);
        }
        if ((taskNo = CarbonTablePath.DataFileUtil.getTaskNo(this.filePath)).contains("_")) {
            taskNo = taskNo.split("_")[0];
        }
        this.taskId = taskNo;
        this.bucketId = CarbonTablePath.DataFileUtil.getBucketNo(this.filePath);
        this.blockletId = blockletId;
        this.version = version;
        this.deleteDeltaFiles = deleteDeltaFiles;
        this.indexWritePath = indexWritePath;
    }

    public CarbonInputSplit(String segmentId, String blockletId, String filePath, long start, long length, String[] locations, int numberOfBlocklets, ColumnarFormatVersion version, String[] deleteDeltaFiles) {
        this(segmentId, blockletId, filePath, start, length, version, deleteDeltaFiles, null);
        this.location = locations;
        this.numberOfBlocklets = numberOfBlocklets;
    }

    public CarbonInputSplit(String segmentId, String filePath, long start, long length, String[] locations, FileFormat fileFormat) {
        this.filePath = filePath;
        this.start = start;
        this.length = length;
        this.location = locations;
        this.segment = Segment.toSegment(segmentId);
        this.fileFormat = fileFormat;
        this.taskId = "0";
        this.bucketId = "0";
        this.blockletId = "0";
        this.numberOfBlocklets = 0;
        this.version = CarbonProperties.getInstance().getFormatVersion();
    }

    public CarbonInputSplit(String segmentId, String filePath, long start, long length, String[] locations, String[] inMemoryHosts, FileFormat fileFormat) {
        this.filePath = filePath;
        this.start = start;
        this.length = length;
        this.location = locations;
        this.hostInfos = new SplitLocationInfo[inMemoryHosts.length];
        for (int i = 0; i < inMemoryHosts.length; ++i) {
            boolean inMemory = false;
            for (String inMemoryHost : inMemoryHosts) {
                if (!inMemoryHost.equals(inMemoryHosts[i])) continue;
                inMemory = true;
                break;
            }
            this.hostInfos[i] = new SplitLocationInfo(inMemoryHosts[i], inMemory);
        }
        this.segment = Segment.toSegment(segmentId);
        this.fileFormat = fileFormat;
        this.taskId = "0";
        this.bucketId = "0";
        this.blockletId = "0";
        this.numberOfBlocklets = 0;
        this.version = CarbonProperties.getInstance().getFormatVersion();
    }

    public static CarbonInputSplit from(String segmentId, String blockletId, String path, long start, long length, ColumnarFormatVersion version, String indexWritePath) {
        return new CarbonInputSplit(segmentId, blockletId, path, start, length, version, null, indexWritePath);
    }

    public static List<TableBlockInfo> createBlocks(List<CarbonInputSplit> splitList) {
        ArrayList<TableBlockInfo> tableBlockInfoList = new ArrayList<TableBlockInfo>();
        for (CarbonInputSplit split : splitList) {
            try {
                TableBlockInfo blockInfo = new TableBlockInfo(split.getFilePath(), split.getStart(), split.getSegment().toString(), split.getLocations(), split.getLength(), split.getVersion(), split.getDeleteDeltaFiles());
                blockInfo.setDetailInfo(split.getDetailInfo());
                blockInfo.setIndexWriterPath(split.indexWritePath);
                if (split.getDetailInfo() != null) {
                    blockInfo.setBlockOffset(split.getDetailInfo().getBlockFooterOffset());
                }
                tableBlockInfoList.add(blockInfo);
            }
            catch (IOException e) {
                throw new RuntimeException("fail to get location of split: " + split, e);
            }
        }
        return tableBlockInfoList;
    }

    public static TableBlockInfo getTableBlockInfo(CarbonInputSplit inputSplit) {
        try {
            TableBlockInfo blockInfo = new TableBlockInfo(inputSplit.getFilePath(), inputSplit.getStart(), inputSplit.getSegment().toString(), inputSplit.getLocations(), inputSplit.getLength(), inputSplit.getVersion(), inputSplit.getDeleteDeltaFiles());
            blockInfo.setDetailInfo(inputSplit.getDetailInfo());
            if (null != inputSplit.getDetailInfo()) {
                blockInfo.setBlockOffset(inputSplit.getDetailInfo().getBlockFooterOffset());
            }
            return blockInfo;
        }
        catch (IOException e) {
            throw new RuntimeException("fail to get location of split: " + inputSplit, e);
        }
    }

    public String getSegmentId() {
        this.derserializeField();
        if (this.segment != null) {
            return this.segment.getSegmentNo();
        }
        return null;
    }

    public Segment getSegment() {
        this.derserializeField();
        return this.segment;
    }

    public void readFields(DataInput in) throws IOException {
        boolean indexWriterPathExists;
        if (null == this.serializeData) {
            this.filePath = in.readUTF();
            this.start = in.readLong();
            this.length = in.readLong();
            this.version = ColumnarFormatVersion.valueOf(in.readShort());
            this.rowCount = in.readInt();
            if (in.readBoolean()) {
                int numberOfDeleteDeltaFiles = in.readInt();
                this.deleteDeltaFiles = new String[numberOfDeleteDeltaFiles];
                for (int i = 0; i < numberOfDeleteDeltaFiles; ++i) {
                    this.deleteDeltaFiles[i] = in.readUTF();
                }
            }
            this.bucketId = in.readUTF();
        }
        this.blockletId = in.readUTF();
        this.segment = Segment.toSegment(in.readUTF());
        boolean detailInfoExists = in.readBoolean();
        if (detailInfoExists) {
            this.detailInfo = new BlockletDetailInfo();
            this.detailInfo.readFields(in);
        }
        if (indexWriterPathExists = in.readBoolean()) {
            this.indexWritePath = in.readUTF();
        }
        int validBlockletIdCount = in.readShort();
        this.validBlockletIds = new HashSet<Integer>(validBlockletIdCount);
        for (int i = 0; i < validBlockletIdCount; ++i) {
            this.validBlockletIds.add(Integer.valueOf(in.readShort()));
        }
    }

    public void write(DataOutput out) throws IOException {
        if (null != this.serializeData) {
            out.writeUTF(this.filePath);
            out.writeLong(this.start);
            out.writeLong(this.length);
            out.writeShort(this.version.number());
            out.writeInt(this.rowCount);
            this.writeDeleteDeltaFile(out);
            out.writeUTF(this.bucketId);
            out.write(this.serializeData, this.offset, this.actualLen);
            return;
        }
        if (null != this.filePath) {
            out.writeUTF(this.filePath);
        }
        out.writeLong(this.start);
        out.writeLong(this.length);
        out.writeShort(this.version.number());
        if (null != this.indexRow) {
            out.writeInt(this.indexRow.getInt(2));
        } else if (null != this.detailInfo) {
            out.writeInt(this.detailInfo.getRowCount());
        } else {
            out.writeInt(0);
        }
        this.writeDeleteDeltaFile(out);
        if (null != this.bucketId) {
            out.writeUTF(this.bucketId);
        }
        out.writeUTF(this.blockletId);
        out.writeUTF(this.segment.toString());
        out.writeBoolean(this.writeDetailInfo && (this.detailInfo != null || this.indexRow != null));
        if (this.writeDetailInfo && this.detailInfo != null) {
            this.detailInfo.write(out);
        } else if (this.writeDetailInfo && this.indexRow != null) {
            this.writeBlockletDetailsInfo(out);
        }
        out.writeBoolean(this.indexWritePath != null);
        if (this.indexWritePath != null) {
            out.writeUTF(this.indexWritePath);
        }
        out.writeShort(this.getValidBlockletIds().size());
        for (Integer blockletId : this.getValidBlockletIds()) {
            out.writeShort(blockletId);
        }
    }

    private void writeDeleteDeltaFile(DataOutput out) throws IOException {
        if (this.deleteDeltaFiles != null) {
            out.writeBoolean(true);
            out.writeInt(this.deleteDeltaFiles.length);
            if (null != this.deleteDeltaFiles) {
                for (int i = 0; i < this.deleteDeltaFiles.length; ++i) {
                    out.writeUTF(this.deleteDeltaFiles[i]);
                }
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public int getNumberOfBlocklets() {
        return this.numberOfBlocklets;
    }

    public ColumnarFormatVersion getVersion() {
        return this.version;
    }

    public void setVersion(ColumnarFormatVersion version) {
        this.version = version;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getBlockletId() {
        return this.blockletId;
    }

    @Override
    public int compareTo(Distributable o) {
        if (o == null) {
            return -1;
        }
        CarbonInputSplit other = (CarbonInputSplit)o;
        this.derserializeField();
        other.derserializeField();
        int compareResult = 0;
        double seg1 = Double.parseDouble(this.segment.getSegmentNo());
        double seg2 = Double.parseDouble(other.segment.getSegmentNo());
        if (seg1 - seg2 < 0.0) {
            return -1;
        }
        if (seg1 - seg2 > 0.0) {
            return 1;
        }
        String filePath1 = this.getFilePath();
        String filePath2 = other.getFilePath();
        if (CarbonTablePath.isCarbonDataFile(filePath1)) {
            int otherBucketNo;
            byte[] otherTaskId;
            byte[] firstTaskId = CarbonTablePath.DataFileUtil.getTaskNo(filePath1).getBytes(Charset.forName("UTF-8"));
            int compare = ByteUtil.compare(firstTaskId, otherTaskId = CarbonTablePath.DataFileUtil.getTaskNo(filePath2).getBytes(Charset.forName("UTF-8")));
            if (compare != 0) {
                return compare;
            }
            int firstBucketNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getBucketNo(filePath1));
            if (firstBucketNo != (otherBucketNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getBucketNo(filePath2)))) {
                return firstBucketNo - otherBucketNo;
            }
            int firstPartNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo(filePath1));
            int SecondPartNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo(filePath2));
            compareResult = firstPartNo - SecondPartNo;
        } else {
            compareResult = filePath1.compareTo(filePath2);
        }
        if (compareResult != 0) {
            return compareResult;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CarbonInputSplit)) {
            return false;
        }
        CarbonInputSplit other = (CarbonInputSplit)obj;
        return 0 == this.compareTo(other);
    }

    public int hashCode() {
        this.derserializeField();
        int result = this.taskId.hashCode();
        result = 31 * result + this.segment.hashCode();
        result = 31 * result + this.bucketId.hashCode();
        result = 31 * result + this.numberOfBlocklets;
        return result;
    }

    @Override
    public String getBlockPath() {
        if (null == this.blockPath) {
            this.blockPath = this.getPath().getName();
        }
        return this.blockPath;
    }

    @Override
    public List<Long> getMatchedBlocklets() {
        return null;
    }

    @Override
    public boolean fullScan() {
        return true;
    }

    public Map<String, String> getBlockStorageIdMap() {
        return new HashMap<String, String>();
    }

    public String[] getDeleteDeltaFiles() {
        return this.deleteDeltaFiles;
    }

    public void setDeleteDeltaFiles(String[] deleteDeltaFiles) {
        this.deleteDeltaFiles = deleteDeltaFiles;
    }

    public void setDetailInfo(BlockletDetailInfo detailInfo) {
        this.detailInfo = detailInfo;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Set<Integer> getValidBlockletIds() {
        if (null == this.validBlockletIds) {
            this.validBlockletIds = new HashSet<Integer>();
        }
        return this.validBlockletIds;
    }

    public void setValidBlockletIds(Set<Integer> validBlockletIds) {
        this.validBlockletIds = validBlockletIds;
    }

    public void setIndexWritePath(String indexWritePath) {
        this.indexWritePath = indexWritePath;
    }

    public void setSegment(Segment segment) {
        this.segment = segment;
    }

    public String getIndexWritePath() {
        return this.indexWritePath;
    }

    public void setIndexRow(IndexRow indexRow) {
        this.indexRow = indexRow;
    }

    public void setColumnSchema(List<ColumnSchema> columnSchema) {
        this.columnSchema = columnSchema;
    }

    public void setUseMinMaxForPruning(boolean useMinMaxForPruning) {
        this.useMinMaxForPruning = useMinMaxForPruning;
    }

    public void setIsBlockCache(boolean isBlockCache) {
        this.isBlockCache = isBlockCache;
    }

    public boolean isBlockCache() {
        return this.isBlockCache;
    }

    private void writeBlockletDetailsInfo(DataOutput out) throws IOException {
        out.writeInt(this.indexRow.getInt(2));
        if (this.isBlockCache) {
            out.writeShort(0);
        } else {
            out.writeShort(this.indexRow.getShort(11));
        }
        out.writeShort(this.indexRow.getShort(4));
        out.writeShort(Short.parseShort(this.blockletId));
        out.writeLong(this.indexRow.getLong(5));
        out.writeBoolean(false);
        out.writeLong(this.indexRow.getLong(6));
        if (null != this.columnSchema) {
            byte[] columnSchemaBinary = BlockletIndexUtil.convertSchemaToBinary(this.columnSchema);
            out.writeInt(columnSchemaBinary.length);
            out.write(columnSchemaBinary);
        } else {
            out.writeInt(-1);
        }
        if (this.isBlockCache) {
            out.writeInt(0);
            out.write(new byte[0]);
        } else {
            byte[] blockletInfoBinary = this.indexRow.getByteArray(10);
            out.writeInt(blockletInfoBinary.length);
            out.write(blockletInfoBinary);
        }
        out.writeLong(this.getLength());
        out.writeBoolean(this.useMinMaxForPruning);
    }

    public BlockletDetailInfo getDetailInfo() {
        if (null != this.indexRow && this.detailInfo == null) {
            this.detailInfo = new BlockletDetailInfo();
            this.detailInfo.setRowCount(this.indexRow.getInt(2));
            this.rowCount = this.detailInfo.getRowCount();
            this.detailInfo.setVersionNumber(this.indexRow.getShort(4));
            this.detailInfo.setBlockletId(Short.parseShort(this.blockletId));
            this.detailInfo.setSchemaUpdatedTimeStamp(this.indexRow.getLong(5));
            this.detailInfo.setBlockFooterOffset(this.indexRow.getLong(6));
            this.start = this.detailInfo.getBlockFooterOffset();
            this.detailInfo.setBlockSize(this.getLength());
            this.length = this.detailInfo.getBlockSize();
            this.detailInfo.setUseMinMaxForPruning(this.useMinMaxForPruning);
            if (!this.isBlockCache) {
                this.detailInfo.setColumnSchemas(this.columnSchema);
                this.detailInfo.setPagesCount(this.indexRow.getShort(11));
                this.detailInfo.setBlockletInfoBinary(this.indexRow.getByteArray(10));
            } else {
                this.detailInfo.setBlockletInfoBinary(new byte[0]);
            }
            if (this.location == null) {
                try {
                    this.location = new String(this.indexRow.getByteArray(7), "UTF-8").split(",");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.indexRow = null;
        }
        return this.detailInfo;
    }

    public SplitLocationInfo[] getLocationInfo() {
        return this.hostInfos;
    }

    public Path getPath() {
        if (this.path == null) {
            this.path = new Path(this.filePath);
            return this.path;
        }
        return this.path;
    }

    public IndexRow getIndexRow() {
        return this.indexRow;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getStart() {
        return this.start;
    }

    public void updateFooteroffset() {
        if (this.isBlockCache && this.start == 0L) {
            if (null != this.indexRow) {
                this.start = this.indexRow.getLong(6);
            } else if (null != this.detailInfo) {
                this.start = this.detailInfo.getBlockFooterOffset();
            }
        }
    }

    public void updateBlockLength() {
        if (this.length == -1L) {
            if (null != this.indexRow) {
                this.length = this.indexRow.getLong(8);
            } else if (null != this.detailInfo) {
                this.length = this.detailInfo.getBlockSize();
            }
        }
    }

    public long getLength() {
        this.updateBlockLength();
        return this.length;
    }

    public String toString() {
        return this.filePath + ":" + this.start + "+" + this.length;
    }

    @Override
    public String[] getLocations() throws IOException {
        if (this.location == null && this.indexRow == null) {
            return new String[0];
        }
        if (this.indexRow != null) {
            this.location = new String(this.indexRow.getByteArray(7), "UTF-8").split(",");
        }
        return this.location;
    }

    public void setLocation(String[] location) {
        this.location = location;
    }

    public void setWriteDetailInfo(boolean writeDetailInfo) {
        this.writeDetailInfo = writeDetailInfo;
    }

    public void serializeFields(DataOutput out, Map<String, Short> uniqueLocationMap) throws IOException {
        String[] locations = this.getLocations();
        if (null != locations) {
            out.writeShort(locations.length);
            for (String loc : locations) {
                Short pos = uniqueLocationMap.get(loc);
                if (null == pos) {
                    pos = (short)uniqueLocationMap.size();
                    uniqueLocationMap.put(loc, pos);
                }
                out.writeShort(pos.shortValue());
            }
        } else {
            out.writeShort(0);
        }
        this.write(out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void derserializeField() {
        if (null == this.serializeData) return;
        DataInputStream in = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.serializeData, this.offset, this.actualLen);
            in = new DataInputStream(bis);
            this.readFields(in);
            this.serializeData = null;
            if (null == in) return;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (null == in) throw throwable;
                CarbonUtil.closeStreams(in);
                throw throwable;
            }
        }
        CarbonUtil.closeStreams(in);
        return;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setBucketId(String bucketId) {
        this.bucketId = bucketId;
    }
}

