/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.stream.ExtendedByteArrayOutputStream;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.hadoop.CarbonInputSplit;

public class CarbonInputSplitWrapper
implements Serializable {
    private byte[] data;
    private int size;

    public CarbonInputSplitWrapper(List<CarbonInputSplit> inputSplitList) {
        ExtendedByteArrayOutputStream stream = new ExtendedByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(stream);
        try {
            for (CarbonInputSplit carbonInputSplit : inputSplitList) {
                carbonInputSplit.write(dos);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(dos);
                throw throwable;
            }
        }
        CarbonUtil.closeStreams(dos);
        this.data = stream.getBuffer();
        this.size = inputSplitList.size();
    }

    public List<CarbonInputSplit> getInputSplit() {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.data);
        DataInputStream dis = new DataInputStream(stream);
        ArrayList<CarbonInputSplit> splits = new ArrayList<CarbonInputSplit>();
        try {
            for (int i = 0; i < this.size; ++i) {
                CarbonInputSplit split = new CarbonInputSplit();
                split.readFields(dis);
                splits.add(split);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(dis);
                throw throwable;
            }
        }
        CarbonUtil.closeStreams(dis);
        return splits;
    }
}

