/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.UseRecordReaderFromInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeRecordReader;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieRealtimeInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@UseRecordReaderFromInputFormat
@UseFileSplitsFromInputFormat
public class HoodieParquetRealtimeInputFormat
extends HoodieParquetInputFormat
implements Configurable {
    private static final Logger LOG = LogManager.getLogger(HoodieParquetRealtimeInputFormat.class);

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Stream<FileSplit> fileSplits = Arrays.stream(super.getSplits(job, numSplits)).map(is -> (FileSplit)is);
        return HoodieRealtimeInputFormatUtils.getRealtimeSplits((Configuration)job, fileSplits);
    }

    @Override
    public FileStatus[] listStatus(JobConf job) throws IOException {
        return super.listStatus(job);
    }

    @Override
    protected HoodieDefaultTimeline filterInstantsTimeline(HoodieDefaultTimeline timeline) {
        return timeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProjectionToJobConf(RealtimeSplit realtimeSplit, JobConf jobConf) {
        if (jobConf.get("hoodie.read.columns.set") == null) {
            JobConf jobConf2 = jobConf;
            synchronized (jobConf2) {
                LOG.info((Object)("Before adding Hoodie columns, Projections :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids")));
                if (jobConf.get("hoodie.read.columns.set") == null) {
                    HoodieRealtimeInputFormatUtils.cleanProjectionColumnIds((Configuration)jobConf);
                    if (!realtimeSplit.getDeltaLogPaths().isEmpty()) {
                        HoodieRealtimeInputFormatUtils.addRequiredProjectionFields((Configuration)jobConf);
                    }
                    this.conf = jobConf;
                    this.conf.set("hoodie.read.columns.set", "true");
                }
            }
        }
    }

    @Override
    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        ValidationUtils.checkArgument((boolean)(split instanceof RealtimeSplit), (String)("HoodieRealtimeRecordReader can only work on RealtimeSplit and not with " + split));
        RealtimeSplit realtimeSplit = (RealtimeSplit)split;
        this.addProjectionToJobConf(realtimeSplit, jobConf);
        LOG.info((Object)("Creating record reader with readCols :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids")));
        return new HoodieRealtimeRecordReader(realtimeSplit, jobConf, super.getRecordReader(split, jobConf, reporter));
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

