/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieHiveUtils {
    public static final Logger LOG = LogManager.getLogger(HoodieHiveUtils.class);
    public static final String HOODIE_CONSUME_MODE_PATTERN = "hoodie.%s.consume.mode";
    public static final String HOODIE_START_COMMIT_PATTERN = "hoodie.%s.consume.start.timestamp";
    public static final String HOODIE_MAX_COMMIT_PATTERN = "hoodie.%s.consume.max.commits";
    public static final Set<String> VIRTUAL_COLUMN_NAMES = CollectionUtils.createImmutableSet((Object[])new String[]{"INPUT__FILE__NAME", "BLOCK__OFFSET__INSIDE__FILE", "ROW__OFFSET__INSIDE__BLOCK", "RAW__DATA__SIZE", "ROW__ID", "GROUPING__ID"});
    public static final String HOODIE_STOP_AT_COMPACTION_PATTERN = "hoodie.%s.ro.stop.at.compaction";
    public static final String INCREMENTAL_SCAN_MODE = "INCREMENTAL";
    public static final String SNAPSHOT_SCAN_MODE = "SNAPSHOT";
    public static final String DEFAULT_SCAN_MODE = "SNAPSHOT";
    public static final int DEFAULT_MAX_COMMITS = 1;
    public static final int MAX_COMMIT_ALL = -1;
    public static final int DEFAULT_LEVELS_TO_BASEPATH = 3;
    public static final Pattern HOODIE_CONSUME_MODE_PATTERN_STRING = Pattern.compile("hoodie\\.(.*)\\.consume\\.mode");

    public static boolean stopAtCompaction(JobContext job, String tableName) {
        String compactionPropName = String.format(HOODIE_STOP_AT_COMPACTION_PATTERN, tableName);
        boolean stopAtCompaction = job.getConfiguration().getBoolean(compactionPropName, true);
        LOG.info((Object)("Read stop at compaction - " + stopAtCompaction));
        return stopAtCompaction;
    }

    public static Integer readMaxCommits(JobContext job, String tableName) {
        String maxCommitName = String.format(HOODIE_MAX_COMMIT_PATTERN, tableName);
        int maxCommits = job.getConfiguration().getInt(maxCommitName, 1);
        if (maxCommits == -1) {
            maxCommits = Integer.MAX_VALUE;
        }
        LOG.info((Object)("Read max commits - " + maxCommits));
        return maxCommits;
    }

    public static String readStartCommitTime(JobContext job, String tableName) {
        String startCommitTimestampName = String.format(HOODIE_START_COMMIT_PATTERN, tableName);
        LOG.info((Object)("Read start commit time - " + job.getConfiguration().get(startCommitTimestampName)));
        return job.getConfiguration().get(startCommitTimestampName);
    }

    public static Path getNthParent(Path path, int n) {
        Path parent = path;
        for (int i = 0; i < n; ++i) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static List<String> getIncrementalTableNames(JobContext job) {
        Map tablesModeMap = job.getConfiguration().getValByRegex(HOODIE_CONSUME_MODE_PATTERN_STRING.pattern());
        List<String> result = tablesModeMap.entrySet().stream().map(s -> {
            if (((String)s.getValue()).trim().toUpperCase().equals(INCREMENTAL_SCAN_MODE)) {
                Matcher matcher = HOODIE_CONSUME_MODE_PATTERN_STRING.matcher((CharSequence)s.getKey());
                return !matcher.find() ? null : matcher.group(1);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (result == null) {
            result = new ArrayList<String>();
        }
        return result;
    }
}

