/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;

public class MercifulJsonConverter {
    private static final Map<Schema.Type, JsonToAvroFieldProcessor> FIELD_TYPE_PROCESSORS = MercifulJsonConverter.getFieldTypeProcessors();
    private final ObjectMapper mapper;

    private static Map<Schema.Type, JsonToAvroFieldProcessor> getFieldTypeProcessors() {
        return Collections.unmodifiableMap(new HashMap<Schema.Type, JsonToAvroFieldProcessor>(){
            {
                this.put(Schema.Type.STRING, MercifulJsonConverter.generateStringTypeHandler());
                this.put(Schema.Type.BOOLEAN, MercifulJsonConverter.generateBooleanTypeHandler());
                this.put(Schema.Type.DOUBLE, MercifulJsonConverter.generateDoubleTypeHandler());
                this.put(Schema.Type.FLOAT, MercifulJsonConverter.generateFloatTypeHandler());
                this.put(Schema.Type.INT, MercifulJsonConverter.generateIntTypeHandler());
                this.put(Schema.Type.LONG, MercifulJsonConverter.generateLongTypeHandler());
                this.put(Schema.Type.ARRAY, MercifulJsonConverter.generateArrayTypeHandler());
                this.put(Schema.Type.RECORD, MercifulJsonConverter.generateRecordTypeHandler());
                this.put(Schema.Type.ENUM, MercifulJsonConverter.generateEnumTypeHandler());
                this.put(Schema.Type.MAP, MercifulJsonConverter.generateMapTypeHandler());
                this.put(Schema.Type.BYTES, MercifulJsonConverter.generateBytesTypeHandler());
                this.put(Schema.Type.FIXED, MercifulJsonConverter.generateFixedTypeHandler());
            }
        });
    }

    public MercifulJsonConverter() {
        this(new ObjectMapper());
    }

    public MercifulJsonConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public GenericRecord convert(String json, Schema schema) {
        try {
            Map jsonObjectMap = (Map)this.mapper.readValue(json, Map.class);
            return MercifulJsonConverter.convertJsonToAvro(jsonObjectMap, schema);
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private static GenericRecord convertJsonToAvro(Map<String, Object> inputJson, Schema schema) {
        GenericData.Record avroRecord = new GenericData.Record(schema);
        for (Schema.Field f : schema.getFields()) {
            Object val = inputJson.get(f.name());
            if (val == null) continue;
            avroRecord.put(f.pos(), MercifulJsonConverter.convertJsonToAvroField(val, f.name(), f.schema()));
        }
        return avroRecord;
    }

    private static Schema getNonNull(Schema schema) {
        List types = schema.getTypes();
        Schema.Type firstType = ((Schema)types.get(0)).getType();
        return firstType.equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
    }

    private static boolean isOptional(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL));
    }

    private static Object convertJsonToAvroField(Object value, String name, Schema schema) {
        if (MercifulJsonConverter.isOptional(schema)) {
            if (value == null) {
                return null;
            }
            schema = MercifulJsonConverter.getNonNull(schema);
        } else if (value == null) {
            throw new HoodieJsonToAvroConversionException(null, name, schema);
        }
        JsonToAvroFieldProcessor processor = FIELD_TYPE_PROCESSORS.get(schema.getType());
        if (null != processor) {
            return processor.convertToAvro(value, name, schema);
        }
        throw new IllegalArgumentException("JsonConverter cannot handle type: " + schema.getType());
    }

    private static JsonToAvroFieldProcessor generateBooleanTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Boolean) {
                    return Pair.of(true, value);
                }
                return Pair.of(false, null);
            }
        };
    }

    private static JsonToAvroFieldProcessor generateIntTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Number) {
                    return Pair.of(true, ((Number)value).intValue());
                }
                if (value instanceof String) {
                    return Pair.of(true, Integer.valueOf((String)value));
                }
                return Pair.of(false, null);
            }
        };
    }

    private static JsonToAvroFieldProcessor generateDoubleTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Number) {
                    return Pair.of(true, ((Number)value).doubleValue());
                }
                if (value instanceof String) {
                    return Pair.of(true, Double.valueOf((String)value));
                }
                return Pair.of(false, null);
            }
        };
    }

    private static JsonToAvroFieldProcessor generateFloatTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Number) {
                    return Pair.of(true, Float.valueOf(((Number)value).floatValue()));
                }
                if (value instanceof String) {
                    return Pair.of(true, Float.valueOf((String)value));
                }
                return Pair.of(false, null);
            }
        };
    }

    private static JsonToAvroFieldProcessor generateLongTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Number) {
                    return Pair.of(true, ((Number)value).longValue());
                }
                if (value instanceof String) {
                    return Pair.of(true, Long.valueOf((String)value));
                }
                return Pair.of(false, null);
            }
        };
    }

    private static JsonToAvroFieldProcessor generateStringTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of(true, value.toString());
            }
        };
    }

    private static JsonToAvroFieldProcessor generateBytesTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of(true, ByteBuffer.wrap(value.toString().getBytes()));
            }
        };
    }

    private static JsonToAvroFieldProcessor generateFixedTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                List converval = (List)value;
                byte[] src = new byte[converval.size()];
                for (int i = 0; i < converval.size(); ++i) {
                    src[i] = ((Integer)converval.get(i)).byteValue();
                }
                byte[] dst = new byte[schema.getFixedSize()];
                System.arraycopy(src, 0, dst, 0, Math.min(schema.getFixedSize(), src.length));
                return Pair.of(true, new GenericData.Fixed(schema, dst));
            }
        };
    }

    private static JsonToAvroFieldProcessor generateEnumTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (schema.getEnumSymbols().contains(value.toString())) {
                    return Pair.of(true, new GenericData.EnumSymbol(schema, value.toString()));
                }
                throw new HoodieJsonToAvroConversionException(String.format("Symbol %s not in enum", value.toString()), schema.getFullName(), schema);
            }
        };
    }

    private static JsonToAvroFieldProcessor generateRecordTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                GenericData.Record result = new GenericData.Record(schema);
                return Pair.of(true, MercifulJsonConverter.convertJsonToAvro((Map)value, schema));
            }
        };
    }

    private static JsonToAvroFieldProcessor generateArrayTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                Schema elementSchema = schema.getElementType();
                ArrayList<Object> listRes = new ArrayList<Object>();
                for (Object v : (List)value) {
                    listRes.add(MercifulJsonConverter.convertJsonToAvroField(v, name, elementSchema));
                }
                return Pair.of(true, listRes);
            }
        };
    }

    private static JsonToAvroFieldProcessor generateMapTypeHandler() {
        return new JsonToAvroFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                Schema valueSchema = schema.getValueType();
                HashMap mapRes = new HashMap();
                for (Map.Entry v : ((Map)value).entrySet()) {
                    mapRes.put(v.getKey(), MercifulJsonConverter.convertJsonToAvroField(v.getValue(), name, valueSchema));
                }
                return Pair.of(true, mapRes);
            }
        };
    }

    public static class HoodieJsonToAvroConversionException
    extends HoodieException {
        private Object value;
        private String fieldName;
        private Schema schema;

        public HoodieJsonToAvroConversionException(Object value, String fieldName, Schema schema) {
            this.value = value;
            this.fieldName = fieldName;
            this.schema = schema;
        }

        @Override
        public String toString() {
            return String.format("Json to Avro Type conversion error for field %s, %s for %s", this.fieldName, this.value, this.schema);
        }
    }

    private static abstract class JsonToAvroFieldProcessor
    implements Serializable {
        private JsonToAvroFieldProcessor() {
        }

        public Object convertToAvro(Object value, String name, Schema schema) {
            Pair<Boolean, Object> res = this.convert(value, name, schema);
            if (!res.getLeft().booleanValue()) {
                throw new HoodieJsonToAvroConversionException(value, name, schema);
            }
            return res.getRight();
        }

        protected abstract Pair<Boolean, Object> convert(Object var1, String var2, Schema var3);
    }
}

