/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.util.collection.Pair;

public class CollectionUtils {
    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (Objects.equals(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    @SafeVarargs
    public static <T> Set<T> createSet(T ... elements) {
        return Stream.of(elements).collect(Collectors.toSet());
    }

    public static <K, V> Map<K, V> createImmutableMap(K key, V value) {
        return Collections.unmodifiableMap(Collections.singletonMap(key, value));
    }

    @SafeVarargs
    public static <T> List<T> createImmutableList(T ... elements) {
        return Collections.unmodifiableList(Stream.of(elements).collect(Collectors.toList()));
    }

    public static <K, V> Map<K, V> createImmutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> createImmutableMap(Pair<K, V> ... elements) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Pair<K, V> pair : elements) {
            map.put(pair.getLeft(), pair.getRight());
        }
        return Collections.unmodifiableMap(map);
    }

    @SafeVarargs
    public static <T> Set<T> createImmutableSet(T ... elements) {
        return Collections.unmodifiableSet(CollectionUtils.createSet(elements));
    }

    public static <T> Set<T> createImmutableSet(Set<T> set) {
        return Collections.unmodifiableSet(set);
    }

    public static <T> List<T> createImmutableList(List<T> list) {
        return Collections.unmodifiableList(list);
    }

    private static Object[] checkElementsNotNull(Object ... array) {
        return CollectionUtils.checkElementsNotNull(array, array.length);
    }

    private static Object[] checkElementsNotNull(Object[] array, int length) {
        for (int i = 0; i < length; ++i) {
            CollectionUtils.checkElementNotNull(array[i], i);
        }
        return array;
    }

    private static Object checkElementNotNull(Object element, int index) {
        return Objects.requireNonNull(element, "Element is null at index " + index);
    }
}

