/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.io.Closer;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.hetu.core.common.algorithm.SequenceUtils;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.CachingOrcDataSource;
import io.prestosql.orc.DiskRange;
import io.prestosql.orc.OrcBlockFactory;
import io.prestosql.orc.OrcCacheProperties;
import io.prestosql.orc.OrcCacheStore;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceUtils;
import io.prestosql.orc.OrcDecompressor;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.RowGroup;
import io.prestosql.orc.Stripe;
import io.prestosql.orc.StripeReader;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.MetadataReader;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.PostScript;
import io.prestosql.orc.metadata.StripeInformation;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.StripeStatistics;
import io.prestosql.orc.reader.AbstractColumnReader;
import io.prestosql.orc.reader.CachingColumnReader;
import io.prestosql.orc.reader.DataCachingSelectiveColumnReader;
import io.prestosql.orc.reader.ResultCachingSelectiveColumnReader;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.StreamSourceMeta;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.heuristicindex.Index;
import io.prestosql.spi.heuristicindex.IndexLookUpException;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

abstract class AbstractOrcRecordReader<T extends AbstractColumnReader>
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(AbstractOrcRecordReader.class).instanceSize();
    private static final Logger log = Logger.get(AbstractOrcRecordReader.class);
    private final OrcDataSource orcDataSource;
    private T[] columnReaders;
    protected long[] currentBytesPerCell;
    protected long[] maxBytesPerCell;
    protected long maxCombinedBytesPerRow;
    private final long totalRowCount;
    private final long splitLength;
    protected final long maxBlockBytes;
    protected long currentPosition;
    protected long currentStripePosition;
    protected int[] matchingRowsInBatchArray;
    protected int currentBatchSize;
    protected int nextBatchSize;
    protected int maxBatchSize = 1024;
    protected boolean currentStripeFinished;
    protected boolean pageMetadataEnabled;
    protected final List<StripeInformation> stripes;
    private final StripeReader stripeReader;
    protected int currentStripe = -1;
    private AggregatedMemoryContext currentStripeSystemMemoryContext;
    private final long fileRowCount;
    private final List<Long> stripeFilePositions;
    private long filePosition;
    private Iterator<RowGroup> rowGroups = ImmutableList.of().iterator();
    private int currentRowGroup = -1;
    private long currentGroupRowCount;
    private int nextRowInGroup;
    protected final Map<String, Slice> userMetadata;
    private final AggregatedMemoryContext systemMemoryUsage;
    protected final OrcBlockFactory blockFactory;
    private final Optional<OrcWriteValidation> writeValidation;
    protected final Optional<OrcWriteValidation.WriteChecksumBuilder> writeChecksumBuilder;
    protected final Optional<OrcWriteValidation.StatisticsValidation> rowGroupStatisticsValidation;
    protected final Optional<OrcWriteValidation.StatisticsValidation> stripeStatisticsValidation;
    protected final Optional<OrcWriteValidation.StatisticsValidation> fileStatisticsValidation;
    Map<StripeInformation, PeekingIterator<Integer>> stripeMatchingRows = new HashMap<StripeInformation, PeekingIterator<Integer>>();

    public AbstractOrcRecordReader(List<OrcColumn> readColumns, List<Type> readTypes, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, Optional<ColumnMetadata<ColumnStatistics>> fileStats, List<Optional<StripeStatistics>> stripeStats, OrcDataSource inputOrcDataSource, long splitOffset, long splitLength, ColumnMetadata<OrcType> orcTypes, Optional<OrcDecompressor> decompressor, int rowsInRowGroup, DateTimeZone legacyFileTimeZone, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, Map<String, Slice> userMetadata, AggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform, Optional<List<IndexMetadata>> indexes, Map<String, Domain> domains, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties, Map<String, List<Domain>> orDomains, boolean pageMetadataEnabled) throws OrcCorruptionException {
        Objects.requireNonNull(readColumns, "readColumns is null");
        Preconditions.checkArgument((readColumns.stream().distinct().count() == (long)readColumns.size() ? 1 : 0) != 0, (Object)"readColumns contains duplicate entries");
        Objects.requireNonNull(readTypes, "readTypes is null");
        Preconditions.checkArgument((readColumns.size() == readTypes.size() ? 1 : 0) != 0, (Object)"readColumns and readTypes must have the same size");
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(fileStripes, "fileStripes is null");
        Objects.requireNonNull(stripeStats, "stripeStats is null");
        Objects.requireNonNull(inputOrcDataSource, "orcDataSource is null");
        Objects.requireNonNull(orcTypes, "types is null");
        Objects.requireNonNull(decompressor, "decompressor is null");
        Objects.requireNonNull(userMetadata, "userMetadata is null");
        Objects.requireNonNull(systemMemoryUsage, "systemMemoryUsage is null");
        Objects.requireNonNull(exceptionTransform, "exceptionTransform is null");
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        this.writeChecksumBuilder = writeValidation.map(validation -> OrcWriteValidation.WriteChecksumBuilder.createWriteChecksumBuilder(orcTypes, readTypes));
        this.rowGroupStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(orcTypes, readTypes));
        this.stripeStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(orcTypes, readTypes));
        this.fileStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(orcTypes, readTypes));
        this.systemMemoryUsage = systemMemoryUsage.newAggregatedMemoryContext();
        this.blockFactory = new OrcBlockFactory(exceptionTransform, true);
        this.maxBlockBytes = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null").toBytes();
        this.pageMetadataEnabled = pageMetadataEnabled;
        Preconditions.checkArgument((rowsInRowGroup > 0 ? 1 : 0) != 0, (Object)"rowsInRowGroup must be greater than zero");
        Preconditions.checkArgument((orDomains != null ? 1 : 0) != 0, (Object)"orDomain map cannot be null");
        ArrayList<StripeInfo> stripeInfos = new ArrayList<StripeInfo>();
        for (int i2 = 0; i2 < fileStripes.size(); ++i2) {
            Object stats = Optional.empty();
            if (stripeStats.size() == fileStripes.size()) {
                stats = stripeStats.get(i2);
            }
            stripeInfos.add(new StripeInfo(fileStripes.get(i2), (Optional<StripeStatistics>)stats));
        }
        stripeInfos.sort(Comparator.comparingLong(info -> info.getStripe().getOffset()));
        HashMap<Long, List<IndexMetadata>> stripeOffsetToIndex = new HashMap<Long, List<IndexMetadata>>();
        if (indexes.isPresent() && !indexes.get().isEmpty() && indexes.get().stream().map(i -> i.getIndex().getId()).collect(Collectors.toSet()).size() == 1) {
            for (IndexMetadata i3 : indexes.get()) {
                long offset = i3.getSplitStart();
                stripeOffsetToIndex.putIfAbsent(offset, new LinkedList());
                List stripeIndexes = (List)stripeOffsetToIndex.get(offset);
                stripeIndexes.add(i3);
            }
        }
        long localTotalRowCount = 0L;
        long localFileRowCount = 0L;
        ImmutableList.Builder localStripes = ImmutableList.builder();
        HashMap stripeIndexes = new HashMap();
        ImmutableList.Builder localStripeFilePositions = ImmutableList.builder();
        if (!fileStats.isPresent() || predicate.matches(numberOfRows, fileStats.get())) {
            for (int i4 = 0; i4 < stripeInfos.size(); ++i4) {
                StripeInfo info2 = (StripeInfo)stripeInfos.get(i4);
                StripeInformation stripe = info2.getStripe();
                if (AbstractOrcRecordReader.splitContainsStripe(splitOffset, splitLength, stripe) && AbstractOrcRecordReader.isStripeIncluded(stripe, info2.getStats(), predicate) && !this.filterStripeUsingIndex(stripe, stripeOffsetToIndex, domains, orDomains)) {
                    localStripes.add((Object)stripe);
                    localStripeFilePositions.add((Object)localFileRowCount);
                    localTotalRowCount += (long)stripe.getNumberOfRows();
                }
                localFileRowCount += (long)stripe.getNumberOfRows();
            }
        }
        this.totalRowCount = localTotalRowCount;
        this.stripes = localStripes.build();
        this.stripeFilePositions = localStripeFilePositions.build();
        OrcDataSource localOrcDataSource = inputOrcDataSource;
        this.orcDataSource = localOrcDataSource = AbstractOrcRecordReader.wrapWithCacheIfTinyStripes(localOrcDataSource, this.stripes, maxMergeDistance, tinyStripeThreshold);
        this.splitLength = splitLength;
        this.fileRowCount = stripeInfos.stream().map(StripeInfo::getStripe).mapToLong(StripeInformation::getNumberOfRows).sum();
        this.userMetadata = ImmutableMap.copyOf((Map)Maps.transformValues(userMetadata, Slices::copyOf));
        this.currentStripeSystemMemoryContext = this.systemMemoryUsage.newAggregatedMemoryContext();
        AggregatedMemoryContext streamReadersSystemMemoryContext = this.systemMemoryUsage.newAggregatedMemoryContext();
        this.stripeReader = new StripeReader(localOrcDataSource, legacyFileTimeZone.toTimeZone().toZoneId(), decompressor, orcTypes, (Set<OrcColumn>)ImmutableSet.copyOf(readColumns), rowsInRowGroup, predicate, hiveWriterVersion, metadataReader, writeValidation, orcCacheStore, orcCacheProperties);
        OptionalInt fixedWidthRowSize = AbstractOrcRecordReader.getFixedWidthRowSize(readTypes);
        this.nextBatchSize = fixedWidthRowSize.isPresent() && fixedWidthRowSize.getAsInt() != 0 ? this.adjustMaxBatchSize(fixedWidthRowSize.getAsInt()) : initialBatchSize;
    }

    private boolean filterStripeUsingIndex(StripeInformation stripe, Map<Long, List<IndexMetadata>> stripeOffsetToIndex, Map<String, Domain> and, Map<String, List<Domain>> or) {
        Index index;
        List indexMetadata;
        Object columnDomain;
        if (stripeOffsetToIndex.isEmpty()) {
            return false;
        }
        List<IndexMetadata> stripeIndex = stripeOffsetToIndex.get(stripe.getOffset());
        HashMap<Index, Object> andDomainMap = new HashMap<Index, Object>();
        HashMap orDomainMap = new HashMap();
        for (Map.Entry<String, Domain> entry : and.entrySet()) {
            String string = entry.getKey();
            columnDomain = entry.getValue();
            indexMetadata = stripeIndex.stream().filter(p -> p.getColumns()[0].equalsIgnoreCase(columnName)).collect(Collectors.toList());
            if (indexMetadata.isEmpty() || indexMetadata.size() > 1) continue;
            index = ((IndexMetadata)indexMetadata.get(0)).getIndex();
            andDomainMap.put(index, columnDomain);
        }
        for (Map.Entry<String, Object> entry : or.entrySet()) {
            String string = entry.getKey();
            columnDomain = (List)entry.getValue();
            indexMetadata = stripeIndex.stream().filter(p -> p.getColumns()[0].equalsIgnoreCase(columnName)).collect(Collectors.toList());
            if (indexMetadata.isEmpty() || indexMetadata.size() > 1) continue;
            index = ((IndexMetadata)indexMetadata.get(0)).getIndex();
            orDomainMap.put(index, columnDomain.get(0));
        }
        if (!andDomainMap.isEmpty()) {
            ArrayList<Iterator> matchings = new ArrayList<Iterator>(andDomainMap.size());
            for (Map.Entry entry : andDomainMap.entrySet()) {
                try {
                    Iterator lookUpRes = ((Index)entry.getKey()).lookUp(entry.getValue());
                    if (lookUpRes != null) {
                        matchings.add(lookUpRes);
                        continue;
                    }
                    if (((Index)entry.getKey()).matches(entry.getValue())) continue;
                    return true;
                }
                catch (IndexLookUpException | UnsupportedOperationException uoe2) {
                    return false;
                }
            }
            if (!matchings.isEmpty()) {
                Iterator iterator = SequenceUtils.intersect(matchings);
                PeekingIterator peekingIterator = Iterators.peekingIterator((Iterator)iterator);
                this.stripeMatchingRows.put(stripe, (PeekingIterator<Integer>)peekingIterator);
            }
            return false;
        }
        if (!orDomainMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : orDomainMap.entrySet()) {
                try {
                    Iterator iterator = ((Index)entry.getKey()).lookUp(entry.getValue());
                    if (!(iterator != null ? iterator.hasNext() : ((Index)entry.getKey()).matches(entry.getValue()))) continue;
                    return false;
                }
                catch (IndexLookUpException | UnsupportedOperationException throwable) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static OptionalInt getFixedWidthRowSize(List<Type> columnTypes) {
        int totalFixedWidth = 0;
        for (Type type : columnTypes) {
            if (type instanceof FixedWidthType) {
                totalFixedWidth += ((FixedWidthType)type).getFixedSize() + 1;
                continue;
            }
            return OptionalInt.empty();
        }
        return OptionalInt.of(totalFixedWidth);
    }

    protected void blockLoaded(int columnIndex, Block block) {
        if (block.getPositionCount() <= 0) {
            return;
        }
        int n = columnIndex;
        this.currentBytesPerCell[n] = this.currentBytesPerCell[n] + block.getSizeInBytes() / (long)this.currentBatchSize;
        if (this.maxBytesPerCell[columnIndex] < this.currentBytesPerCell[columnIndex]) {
            long delta = this.currentBytesPerCell[columnIndex] - this.maxBytesPerCell[columnIndex];
            this.maxCombinedBytesPerRow += delta;
            this.maxBytesPerCell[columnIndex] = this.currentBytesPerCell[columnIndex];
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.maxBlockBytes / this.maxCombinedBytesPerRow)));
        }
    }

    public long getMaxCombinedBytesPerRow() {
        return this.maxCombinedBytesPerRow;
    }

    protected void updateMaxCombinedBytesPerRow(int columnIndex, Block block) {
        long bytesPerCell;
        if (block.getPositionCount() > 0 && this.maxBytesPerCell[columnIndex] < (bytesPerCell = block.getSizeInBytes() / (long)block.getPositionCount())) {
            this.maxCombinedBytesPerRow = this.maxCombinedBytesPerRow - this.maxBytesPerCell[columnIndex] + bytesPerCell;
            this.maxBytesPerCell[columnIndex] = bytesPerCell;
            this.adjustMaxBatchSize(this.maxCombinedBytesPerRow);
        }
    }

    protected T[] getColumnReaders() {
        return this.columnReaders;
    }

    private static boolean splitContainsStripe(long splitOffset, long splitLength, StripeInformation stripe) {
        long splitEndOffset = splitOffset + splitLength;
        return splitOffset <= stripe.getOffset() && stripe.getOffset() < splitEndOffset;
    }

    private static boolean isStripeIncluded(StripeInformation stripe, Optional<StripeStatistics> stripeStats, OrcPredicate predicate) {
        return stripeStats.map(StripeStatistics::getColumnStatistics).map(columnStats -> predicate.matches(stripe.getNumberOfRows(), (ColumnMetadata<ColumnStatistics>)columnStats)).orElse(true);
    }

    @VisibleForTesting
    static OrcDataSource wrapWithCacheIfTinyStripes(OrcDataSource dataSource, List<StripeInformation> stripes, DataSize maxMergeDistance, DataSize tinyStripeThreshold) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        for (StripeInformation stripe : stripes) {
            if (stripe.getTotalLength() <= tinyStripeThreshold.toBytes()) continue;
            return dataSource;
        }
        return new CachingOrcDataSource(dataSource, LinearProbeRangeFinder.createTinyStripesRangeFinder(stripes, maxMergeDistance, tinyStripeThreshold));
    }

    public long getFilePosition() {
        return this.filePosition;
    }

    public long getFileRowCount() {
        return this.fileRowCount;
    }

    public long getReaderPosition() {
        return this.currentPosition;
    }

    public long getReaderRowCount() {
        return this.totalRowCount;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.orcDataSource);
            for (T column : this.columnReaders) {
                if (column == null) continue;
                closer.register(() -> column.close());
            }
        }
        if (this.writeChecksumBuilder.isPresent()) {
            OrcWriteValidation.WriteChecksum actualChecksum = this.writeChecksumBuilder.get().build();
            this.validateWrite(validation -> validation.getChecksum().getTotalRowCount() == actualChecksum.getTotalRowCount(), "Invalid row count", new Object[0]);
            List<Long> columnHashes = actualChecksum.getColumnHashes();
            int i = 0;
            while (i < columnHashes.size()) {
                int columnIndex = i++;
                this.validateWrite(validation -> validation.getChecksum().getColumnHashes().get(columnIndex).equals(columnHashes.get(columnIndex)), "Invalid checksum for column %s", columnIndex);
            }
            this.validateWrite(validation -> validation.getChecksum().getStripeHash() == actualChecksum.getStripeHash(), "Invalid stripes checksum", new Object[0]);
        }
        if (this.fileStatisticsValidation.isPresent()) {
            Optional<ColumnMetadata<ColumnStatistics>> columnStatistics = this.fileStatisticsValidation.get().build();
            this.writeValidation.get().validateFileStatistics(this.orcDataSource.getId(), columnStatistics);
        }
    }

    public Map<String, Slice> getUserMetadata() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.userMetadata, Slices::copyOf));
    }

    protected int getNextRowInGroup() {
        return this.nextRowInGroup;
    }

    protected void batchRead(int batchSize) {
        this.nextRowInGroup += batchSize;
    }

    protected int adjustMaxBatchSize(long averageRowBytes) {
        this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.maxBlockBytes / averageRowBytes)));
        return this.maxBatchSize;
    }

    protected int prepareNextBatch() throws IOException {
        this.currentStripeFinished = false;
        this.filePosition += (long)this.currentBatchSize;
        this.currentPosition += (long)this.currentBatchSize;
        if ((long)this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            this.filePosition = this.fileRowCount;
            this.currentPosition = this.totalRowCount;
            return -1;
        }
        this.currentBatchSize = Math.toIntExact(Math.min(this.nextBatchSize, this.maxBatchSize));
        this.nextBatchSize = Math.min(this.currentBatchSize * 2, 1024);
        this.currentBatchSize = Math.toIntExact(Math.min((long)this.currentBatchSize, this.currentGroupRowCount - (long)this.nextRowInGroup));
        if (!this.rowGroups.hasNext() && (long)(this.nextRowInGroup + this.currentBatchSize) >= this.currentGroupRowCount) {
            this.currentStripeFinished = true;
        }
        return this.currentBatchSize;
    }

    protected Boolean isCurrentStripeFinished() {
        return this.currentStripeFinished;
    }

    private void advanceToNextStripe() throws IOException {
        this.currentStripeSystemMemoryContext.close();
        this.currentStripeSystemMemoryContext = this.systemMemoryUsage.newAggregatedMemoryContext();
        this.rowGroups = ImmutableList.of().iterator();
        if (this.currentStripe >= 0 && this.stripeStatisticsValidation.isPresent()) {
            OrcWriteValidation.StatisticsValidation statisticsValidation = this.stripeStatisticsValidation.get();
            long offset = this.stripes.get(this.currentStripe).getOffset();
            this.writeValidation.get().validateStripeStatistics(this.orcDataSource.getId(), offset, statisticsValidation.build().get());
            statisticsValidation.reset();
        }
        ++this.currentStripe;
        if (this.currentStripe >= this.stripes.size()) {
            return;
        }
        if (this.currentStripe > 0) {
            this.currentStripePosition += (long)this.stripes.get(this.currentStripe - 1).getNumberOfRows();
        }
        StripeInformation stripeInformation = this.stripes.get(this.currentStripe);
        this.validateWriteStripe(stripeInformation.getNumberOfRows());
        Stripe stripe = this.stripeReader.readStripe(stripeInformation, this.currentStripeSystemMemoryContext);
        if (stripe != null) {
            InputStreamSources dictionaryStreamSources = stripe.getDictionaryStreamSources();
            ColumnMetadata<ColumnEncoding> columnEncodings = stripe.getColumnEncodings();
            for (T columnReader : this.columnReaders) {
                if (columnReader == null) continue;
                ZoneId fileTimeZone = stripe.getFileTimeZone();
                columnReader.startStripe(fileTimeZone, dictionaryStreamSources, columnEncodings);
            }
            this.rowGroups = stripe.getRowGroups().iterator();
        }
    }

    private void validateWrite(Predicate<OrcWriteValidation> test, String messageFormat, Object ... args) throws OrcCorruptionException {
        if (this.writeValidation.isPresent() && !test.test(this.writeValidation.get())) {
            throw new OrcCorruptionException(this.orcDataSource.getId(), "Write validation failed: " + messageFormat, args);
        }
    }

    private void validateWriteStripe(int rowCount) {
        this.writeChecksumBuilder.ifPresent(builder -> builder.addStripe(rowCount));
    }

    protected void validateWritePageChecksum(Page page) {
        if (this.writeChecksumBuilder.isPresent()) {
            this.writeChecksumBuilder.get().addPage(page);
            this.rowGroupStatisticsValidation.get().addPage(page);
            this.stripeStatisticsValidation.get().addPage(page);
            this.fileStatisticsValidation.get().addPage(page);
        }
    }

    protected void setColumnReadersParam(T[] columnReaders) {
        this.columnReaders = columnReaders;
        this.currentBytesPerCell = new long[columnReaders.length];
        this.maxBytesPerCell = new long[columnReaders.length];
    }

    private boolean advanceToNextRowGroup() throws IOException {
        this.nextRowInGroup = 0;
        if (this.currentRowGroup >= 0 && this.rowGroupStatisticsValidation.isPresent()) {
            OrcWriteValidation.StatisticsValidation statisticsValidation = this.rowGroupStatisticsValidation.get();
            long offset = this.stripes.get(this.currentStripe).getOffset();
            this.writeValidation.get().validateRowGroupStatistics(this.orcDataSource.getId(), offset, this.currentRowGroup, statisticsValidation.build().get());
            statisticsValidation.reset();
        }
        while (!this.rowGroups.hasNext() && this.currentStripe < this.stripes.size()) {
            this.advanceToNextStripe();
            this.currentRowGroup = -1;
        }
        if (!this.rowGroups.hasNext()) {
            this.currentGroupRowCount = 0L;
            return false;
        }
        ++this.currentRowGroup;
        RowGroup localCurrentRowGroup = this.rowGroups.next();
        this.currentGroupRowCount = localCurrentRowGroup.getRowCount();
        if (localCurrentRowGroup.getMinAverageRowBytes() > 0L) {
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.maxBlockBytes / localCurrentRowGroup.getMinAverageRowBytes())));
        }
        this.currentPosition = this.currentStripePosition + localCurrentRowGroup.getRowOffset();
        this.filePosition = this.stripeFilePositions.get(this.currentStripe) + localCurrentRowGroup.getRowOffset();
        InputStreamSources rowGroupStreamSources = localCurrentRowGroup.getStreamSources();
        for (T columnReader : this.columnReaders) {
            if (columnReader == null) continue;
            if (columnReader instanceof CachingColumnReader || columnReader instanceof ResultCachingSelectiveColumnReader || columnReader instanceof DataCachingSelectiveColumnReader) {
                StreamSourceMeta streamSourceMeta = new StreamSourceMeta();
                streamSourceMeta.setDataSourceId(this.orcDataSource.getId());
                streamSourceMeta.setLastModifiedTime(this.orcDataSource.getLastModifiedTime());
                streamSourceMeta.setStripeOffset(this.stripes.get(this.currentStripe).getOffset());
                streamSourceMeta.setRowGroupOffset(localCurrentRowGroup.getRowOffset());
                streamSourceMeta.setRowCount(localCurrentRowGroup.getRowCount());
                rowGroupStreamSources.setStreamSourceMeta(streamSourceMeta);
            }
            columnReader.startRowGroup(rowGroupStreamSources);
        }
        return true;
    }

    @VisibleForTesting
    long getStreamReaderRetainedSizeInBytes() {
        long totalRetainedSizeInBytes = 0L;
        for (T columnReader : this.columnReaders) {
            if (columnReader == null) continue;
            totalRetainedSizeInBytes += columnReader.getRetainedSizeInBytes();
        }
        return totalRetainedSizeInBytes;
    }

    @VisibleForTesting
    long getCurrentStripeRetainedSizeInBytes() {
        return this.currentStripeSystemMemoryContext.getBytes();
    }

    @VisibleForTesting
    long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.getStreamReaderRetainedSizeInBytes() + this.getCurrentStripeRetainedSizeInBytes();
    }

    @VisibleForTesting
    long getSystemMemoryUsage() {
        return this.systemMemoryUsage.getBytes();
    }

    static class LinearProbeRangeFinder
    implements CachingOrcDataSource.RegionFinder {
        private final List<DiskRange> diskRanges;
        private int index;

        private LinearProbeRangeFinder(List<DiskRange> diskRanges) {
            this.diskRanges = diskRanges;
        }

        @Override
        public DiskRange getRangeFor(long desiredOffset) {
            while (this.index < this.diskRanges.size()) {
                DiskRange range = this.diskRanges.get(this.index);
                if (range.getEnd() > desiredOffset) {
                    Preconditions.checkArgument((range.getOffset() <= desiredOffset ? 1 : 0) != 0);
                    return range;
                }
                ++this.index;
            }
            throw new IllegalArgumentException("Invalid desiredOffset " + desiredOffset);
        }

        public static LinearProbeRangeFinder createTinyStripesRangeFinder(List<StripeInformation> stripes, DataSize maxMergeDistance, DataSize tinyStripeThreshold) {
            if (stripes.isEmpty()) {
                return new LinearProbeRangeFinder((List<DiskRange>)ImmutableList.of());
            }
            List<DiskRange> scratchDiskRanges = stripes.stream().map(stripe -> new DiskRange(stripe.getOffset(), Math.toIntExact(stripe.getTotalLength()))).collect(Collectors.toList());
            List<DiskRange> localDiskRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(scratchDiskRanges, maxMergeDistance, tinyStripeThreshold);
            return new LinearProbeRangeFinder(localDiskRanges);
        }
    }

    private static class StripeInfo {
        private final StripeInformation stripe;
        private final Optional<StripeStatistics> stats;

        public StripeInfo(StripeInformation stripe, Optional<StripeStatistics> stats) {
            this.stripe = Objects.requireNonNull(stripe, "stripe is null");
            this.stats = Objects.requireNonNull(stats, "metadata is null");
        }

        public StripeInformation getStripe() {
            return this.stripe;
        }

        public Optional<StripeStatistics> getStats() {
            return this.stats;
        }
    }
}

