/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class ByteArrayUtils {
    private static final Unsafe unsafe;

    private ByteArrayUtils() {
    }

    public static int compareRanges(byte[] left, int leftOffset, int leftLength, byte[] right, int rightOffset, int rightLength) {
        int i;
        int minLength = Math.min(leftLength, rightLength);
        if (minLength >= 8) {
            for (i = 0; i < minLength; i += 8) {
                long rightLong;
                long leftLong = unsafe.getLong(left, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)leftOffset + (long)i);
                if (leftLong == (rightLong = unsafe.getLong(right, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)rightOffset + (long)i))) continue;
                return ByteArrayUtils.longBytesToLong(leftLong) < ByteArrayUtils.longBytesToLong(rightLong) ? -1 : 1;
            }
            i -= 8;
        }
        while (i < minLength) {
            int rightByte;
            int leftByte = Byte.toUnsignedInt(left[leftOffset + i]);
            if (leftByte != (rightByte = Byte.toUnsignedInt(right[rightOffset + i]))) {
                return leftByte - rightByte;
            }
            ++i;
        }
        return Integer.compare(leftLength, rightLength);
    }

    private static long longBytesToLong(long bytes) {
        return Long.reverseBytes(bytes) ^ Long.MIN_VALUE;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe == null) {
                throw new RuntimeException("Unsafe access not available");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

