/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.Preconditions;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.block.LazyBlockLoader;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class OrcBlockFactory {
    private final Function<Exception, RuntimeException> exceptionTransform;
    private final boolean nestedLazy;
    private int currentPageId;

    public OrcBlockFactory(Function<Exception, RuntimeException> exceptionTransform, boolean nestedLazy) {
        this.exceptionTransform = Objects.requireNonNull(exceptionTransform, "exceptionTransform is null");
        this.nestedLazy = nestedLazy;
    }

    public void nextPage() {
        ++this.currentPageId;
    }

    public Block createBlock(int positionCount, OrcBlockReader reader, Consumer<Block> onBlockLoaded) {
        return new LazyBlock(positionCount, new OrcBlockLoader(reader, onBlockLoaded));
    }

    public NestedBlockFactory createNestedBlockFactory(Consumer<Block> onBlockLoaded) {
        return new NestedBlockFactory(this.nestedLazy, onBlockLoaded);
    }

    private final class OrcBlockLoader<T>
    implements LazyBlockLoader<T> {
        private final int expectedPageId;
        private final OrcBlockReader blockReader;
        private final Consumer<Block> onBlockLoaded;
        private boolean loaded;

        public OrcBlockLoader(OrcBlockReader blockReader, Consumer<Block> onBlockLoaded) {
            this.expectedPageId = OrcBlockFactory.this.currentPageId;
            this.blockReader = Objects.requireNonNull(blockReader, "blockReader is null");
            this.onBlockLoaded = Objects.requireNonNull(onBlockLoaded, "onBlockLoaded is null");
        }

        public final void load(LazyBlock<T> lazyBlock) {
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Preconditions.checkState((OrcBlockFactory.this.currentPageId == this.expectedPageId ? 1 : 0) != 0, (Object)"ORC reader has been advanced beyond block");
            try {
                Block block = this.blockReader.readBlock();
                lazyBlock.setBlock(block);
                this.onBlockLoaded.accept(block);
            }
            catch (IOException | RuntimeException e) {
                throw (RuntimeException)OrcBlockFactory.this.exceptionTransform.apply(e);
            }
            this.loaded = true;
        }
    }

    public class NestedBlockFactory {
        private final boolean lazy;
        private final Consumer<Block> onBlockLoaded;

        private NestedBlockFactory(boolean lazy, Consumer<Block> onBlockLoaded) {
            this.lazy = lazy;
            this.onBlockLoaded = Objects.requireNonNull(onBlockLoaded, "onBlockLoaded is null");
        }

        public Block createBlock(int positionCount, OrcBlockReader reader) {
            if (this.lazy) {
                return new LazyBlock(positionCount, new OrcBlockLoader(reader, this.onBlockLoaded));
            }
            try {
                Block block = reader.readBlock();
                this.onBlockLoaded.accept(block);
                return block;
            }
            catch (Exception e) {
                throw (RuntimeException)OrcBlockFactory.this.exceptionTransform.apply(e);
            }
        }
    }

    public static interface OrcBlockReader {
        public Block readBlock() throws IOException;
    }
}

