/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcBloomFilterCacheKey;
import io.prestosql.orc.OrcFileTail;
import io.prestosql.orc.OrcFileTailCacheKey;
import io.prestosql.orc.OrcRowDataCacheKey;
import io.prestosql.orc.OrcRowIndexCacheKey;
import io.prestosql.orc.OrcStripeFooterCacheKey;
import io.prestosql.orc.metadata.RowGroupIndex;
import io.prestosql.orc.metadata.StripeFooter;
import io.prestosql.orc.metadata.statistics.HashableBloomFilter;
import io.prestosql.spi.block.Block;
import java.time.Duration;
import java.util.List;

public class OrcCacheStore {
    public static final OrcCacheStore CACHE_NOTHING = new OrcCacheStore(null, null, null, null, null);
    private Cache<OrcFileTailCacheKey, OrcFileTail> fileTailCache;
    private Cache<OrcStripeFooterCacheKey, StripeFooter> stripeFooterCache;
    private Cache<OrcRowIndexCacheKey, List<RowGroupIndex>> rowIndexCache;
    private Cache<OrcBloomFilterCacheKey, List<HashableBloomFilter>> bloomFiltersCache;
    private Cache<OrcRowDataCacheKey, Block> rowDataCache;

    private OrcCacheStore() {
    }

    private OrcCacheStore(Cache<OrcFileTailCacheKey, OrcFileTail> fileTailCache, Cache<OrcStripeFooterCacheKey, StripeFooter> stripeFooterCache, Cache<OrcRowIndexCacheKey, List<RowGroupIndex>> rowIndexCache, Cache<OrcBloomFilterCacheKey, List<HashableBloomFilter>> bloomFiltersCache, Cache<OrcRowDataCacheKey, Block> rowDataCache) {
        this.fileTailCache = fileTailCache;
        this.stripeFooterCache = stripeFooterCache;
        this.rowIndexCache = rowIndexCache;
        this.bloomFiltersCache = bloomFiltersCache;
        this.rowDataCache = rowDataCache;
    }

    public Cache<OrcFileTailCacheKey, OrcFileTail> getFileTailCache() {
        return this.fileTailCache;
    }

    public Cache<OrcStripeFooterCacheKey, StripeFooter> getStripeFooterCache() {
        return this.stripeFooterCache;
    }

    public Cache<OrcRowIndexCacheKey, List<RowGroupIndex>> getRowIndexCache() {
        return this.rowIndexCache;
    }

    public Cache<OrcBloomFilterCacheKey, List<HashableBloomFilter>> getBloomFiltersCache() {
        return this.bloomFiltersCache;
    }

    public Cache<OrcRowDataCacheKey, Block> getRowDataCache() {
        return this.rowDataCache;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Builder() {
        }

        public OrcCacheStore newCacheStore(long fileTailMaximumSize, Duration fileTailTtl, long stripeFooterMaximumSize, Duration stripeFooterTtl, long rowIndexMaximumSize, Duration rowIndexTtl, long bloomFiltersMaximumSize, Duration bloomFiltersTtl, DataSize rowDataMaximumWeight, Duration rowDataTtl, boolean isOrcCacheStatsMetricCollectionEnabled) {
            OrcCacheStore store = new OrcCacheStore();
            store.fileTailCache = this.buildOrcFileTailCache(fileTailMaximumSize, fileTailTtl, isOrcCacheStatsMetricCollectionEnabled);
            store.stripeFooterCache = this.buildOrcStripeFooterCache(stripeFooterMaximumSize, stripeFooterTtl, isOrcCacheStatsMetricCollectionEnabled);
            store.rowIndexCache = this.buildOrcRowGroupIndexCache(rowIndexMaximumSize, rowIndexTtl, isOrcCacheStatsMetricCollectionEnabled);
            store.bloomFiltersCache = this.buildOrcBloomFilterCache(bloomFiltersMaximumSize, bloomFiltersTtl, isOrcCacheStatsMetricCollectionEnabled);
            store.rowDataCache = this.buildOrcRowDataCache(rowDataMaximumWeight, rowDataTtl, isOrcCacheStatsMetricCollectionEnabled);
            return store;
        }

        private Cache<OrcFileTailCacheKey, OrcFileTail> buildOrcFileTailCache(long maximumSize, Duration ttl, boolean isOrcCacheStatsMetricCollectionEnabled) {
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(maximumSize).expireAfterAccess(ttl);
            if (isOrcCacheStatsMetricCollectionEnabled) {
                cacheBuilder.recordStats();
            }
            return cacheBuilder.build();
        }

        private Cache<OrcStripeFooterCacheKey, StripeFooter> buildOrcStripeFooterCache(long maximumSize, Duration ttl, boolean isOrcCacheStatsMetricCollectionEnabled) {
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(maximumSize).expireAfterAccess(ttl);
            if (isOrcCacheStatsMetricCollectionEnabled) {
                cacheBuilder.recordStats();
            }
            return cacheBuilder.build();
        }

        private Cache<OrcRowIndexCacheKey, List<RowGroupIndex>> buildOrcRowGroupIndexCache(long maximumSize, Duration ttl, boolean isOrcCacheStatsMetricCollectionEnabled) {
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(maximumSize).expireAfterAccess(ttl);
            if (isOrcCacheStatsMetricCollectionEnabled) {
                cacheBuilder.recordStats();
            }
            return cacheBuilder.build();
        }

        private Cache<OrcBloomFilterCacheKey, List<HashableBloomFilter>> buildOrcBloomFilterCache(long maximumSize, Duration ttl, boolean isOrcCacheStatsMetricCollectionEnabled) {
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(maximumSize).expireAfterAccess(ttl);
            if (isOrcCacheStatsMetricCollectionEnabled) {
                cacheBuilder.recordStats();
            }
            return cacheBuilder.build();
        }

        private Cache<OrcRowDataCacheKey, Block> buildOrcRowDataCache(DataSize maximumWeight, Duration ttl, boolean isOrcCacheStatsMetricCollectionEnabled) {
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumWeight(maximumWeight.toBytes()).weigher((orcRowDataCacheKey, block) -> (int)block.getSizeInBytes()).expireAfterAccess(ttl);
            if (isOrcCacheStatsMetricCollectionEnabled) {
                cacheBuilder.recordStats();
            }
            return cacheBuilder.build();
        }
    }
}

