/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.OrcType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class OrcColumn {
    private final String path;
    private final OrcColumnId columnId;
    private final OrcType.OrcTypeKind columnType;
    private final String columnName;
    private final OrcDataSourceId orcDataSourceId;
    private final List<OrcColumn> nestedColumns;

    public OrcColumn(String path, OrcColumnId columnId, String columnName, OrcType.OrcTypeKind columnType, OrcDataSourceId orcDataSourceId, List<OrcColumn> nestedColumns) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.columnId = Objects.requireNonNull(columnId, "columnId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.nestedColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(nestedColumns, "nestedColumns is null"));
    }

    public String getPath() {
        return this.path;
    }

    public OrcColumnId getColumnId() {
        return this.columnId;
    }

    public OrcType.OrcTypeKind getColumnType() {
        return this.columnType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public OrcDataSourceId getOrcDataSourceId() {
        return this.orcDataSourceId;
    }

    public List<OrcColumn> getNestedColumns() {
        return this.nestedColumns;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("columnId", (Object)this.columnId).add("streamType", (Object)this.columnType).add("dataSource", (Object)this.orcDataSourceId).toString();
    }
}

