/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.Joiner;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDecompressor;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.orc.metadata.ExceptionWrappingMetadataReader;
import io.prestosql.orc.metadata.Footer;
import io.prestosql.orc.metadata.Metadata;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.OrcMetadataReader;
import io.prestosql.orc.metadata.PostScript;
import io.prestosql.orc.stream.OrcChunkLoader;
import io.prestosql.orc.stream.OrcInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class OrcFileTail {
    private static final int CURRENT_MAJOR_VERSION = 0;
    private static final int CURRENT_MINOR_VERSION = 12;
    private static final int EXPECTED_FOOTER_SIZE = 16384;
    private static final Logger log = Logger.get(OrcFileTail.class);
    private Optional<OrcDecompressor> decompressor;
    private PostScript postScript;
    private Metadata metadata;
    private Footer footer;

    private OrcFileTail() {
    }

    public Optional<OrcDecompressor> getDecompressor() {
        return this.decompressor;
    }

    public PostScript getPostScript() {
        return this.postScript;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Footer getFooter() {
        return this.footer;
    }

    public static OrcFileTail readFrom(OrcDataSource orcDataSource, Optional<OrcWriteValidation> writeValidation) throws IOException {
        OrcFileTail orcFileTail = new OrcFileTail();
        long size = orcDataSource.getSize();
        if (size <= (long)PostScript.MAGIC.length()) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Invalid file size %s", size);
        }
        int expectedBufferSize = Math.toIntExact(Math.min(size, 16384L));
        Slice buffer = orcDataSource.readFully(size - (long)expectedBufferSize, expectedBufferSize);
        short postScriptSize = buffer.getUnsignedByte(buffer.length() - 1);
        if (postScriptSize >= buffer.length()) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Invalid postscript length %s", postScriptSize);
        }
        ExceptionWrappingMetadataReader metadataReader = new ExceptionWrappingMetadataReader(orcDataSource.getId(), new OrcMetadataReader());
        try {
            orcFileTail.postScript = metadataReader.readPostScript((InputStream)buffer.slice(buffer.length() - 1 - postScriptSize, (int)postScriptSize).getInput());
        }
        catch (OrcCorruptionException e) {
            if (!OrcFileTail.isValidHeaderMagic(orcDataSource)) {
                throw new OrcCorruptionException(orcDataSource.getId(), "Not an ORC file");
            }
            throw e;
        }
        OrcFileTail.checkOrcVersion(orcDataSource, orcFileTail.postScript.getVersion());
        OrcFileTail.validateWrite(validation -> validation.getVersion().equals(orcFileTail.postScript.getVersion()), writeValidation, orcDataSource, "Unexpected version", new Object[0]);
        int bufferSize = Math.toIntExact(orcFileTail.postScript.getCompressionBlockSize());
        CompressionKind compressionKind = orcFileTail.postScript.getCompression();
        orcFileTail.decompressor = OrcDecompressor.createOrcDecompressor(orcDataSource.getId(), compressionKind, bufferSize);
        OrcFileTail.validateWrite(validation -> validation.getCompression() == compressionKind, writeValidation, orcDataSource, "Unexpected compression", new Object[0]);
        PostScript.HiveWriterVersion hiveWriterVersion = orcFileTail.postScript.getHiveWriterVersion();
        int footerSize = Math.toIntExact(orcFileTail.postScript.getFooterLength());
        int metadataSize = Math.toIntExact(orcFileTail.postScript.getMetadataLength());
        int completeFooterSize = footerSize + metadataSize + postScriptSize + 1;
        Slice completeFooterSlice = completeFooterSize > buffer.length() ? orcDataSource.readFully(size - (long)completeFooterSize, completeFooterSize) : buffer.slice(buffer.length() - completeFooterSize, completeFooterSize);
        Slice metadataSlice = completeFooterSlice.slice(0, metadataSize);
        try (OrcInputStream metadataInputStream = new OrcInputStream(OrcChunkLoader.create(orcDataSource.getId(), metadataSlice, orcFileTail.decompressor, AggregatedMemoryContext.newSimpleAggregatedMemoryContext()));){
            orcFileTail.metadata = metadataReader.readMetadata(hiveWriterVersion, metadataInputStream);
        }
        Slice footerSlice = completeFooterSlice.slice(metadataSize, footerSize);
        try (OrcInputStream footerInputStream = new OrcInputStream(OrcChunkLoader.create(orcDataSource.getId(), footerSlice, orcFileTail.decompressor, AggregatedMemoryContext.newSimpleAggregatedMemoryContext()));){
            orcFileTail.footer = metadataReader.readFooter(hiveWriterVersion, footerInputStream);
        }
        if (orcFileTail.footer.getTypes().size() == 0) {
            throw new OrcCorruptionException(orcDataSource.getId(), "File has no columns");
        }
        OrcFileTail.validateWrite(validation -> validation.getColumnNames().equals(orcFileTail.footer.getTypes().get(new OrcColumnId(0)).getFieldNames()), writeValidation, orcDataSource, "Unexpected column names", new Object[0]);
        OrcFileTail.validateWrite(validation -> validation.getRowGroupMaxRowCount() == orcFileTail.footer.getRowsInRowGroup(), writeValidation, orcDataSource, "Unexpected rows in group", new Object[0]);
        if (writeValidation.isPresent()) {
            writeValidation.get().validateMetadata(orcDataSource.getId(), orcFileTail.footer.getUserMetadata());
            writeValidation.get().validateFileStatistics(orcDataSource.getId(), orcFileTail.footer.getFileStats());
            writeValidation.get().validateStripeStatistics(orcDataSource.getId(), orcFileTail.footer.getStripes(), orcFileTail.metadata.getStripeStatsList());
        }
        return orcFileTail;
    }

    private static boolean isValidHeaderMagic(OrcDataSource source) throws IOException {
        Slice headerMagic = source.readFully(0L, PostScript.MAGIC.length());
        return PostScript.MAGIC.equals((Object)headerMagic);
    }

    private static void checkOrcVersion(OrcDataSource orcDataSource, List<Integer> version) {
        if (version.size() > 0) {
            int minorVersion;
            int majorVersion = version.get(0);
            int n = minorVersion = version.size() > 1 ? version.get(1) : 0;
            if (majorVersion > 0 || majorVersion == 0 && minorVersion > 12) {
                log.warn("ORC file %s is written by a newer Hive version %s. Current Hive version is %s.%s.", new Object[]{orcDataSource, Joiner.on((char)'.').join(version), 0, 12});
            }
        }
    }

    private static void validateWrite(Predicate<OrcWriteValidation> test, Optional<OrcWriteValidation> writeValidation, OrcDataSource orcDataSource, String messageFormat, Object ... args) throws OrcCorruptionException {
        if (writeValidation.isPresent() && !test.test(writeValidation.get())) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Write validation failed: " + messageFormat, args);
        }
    }
}

