/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.CachingOrcDataSource;
import io.prestosql.orc.DiskRange;
import io.prestosql.orc.OrcCacheProperties;
import io.prestosql.orc.OrcCacheStore;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDecompressor;
import io.prestosql.orc.OrcFileTail;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.orc.OrcSelectiveRecordReader;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.orc.metadata.ExceptionWrappingMetadataReader;
import io.prestosql.orc.metadata.Footer;
import io.prestosql.orc.metadata.Metadata;
import io.prestosql.orc.metadata.MetadataReader;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.OrcMetadataReader;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.PostScript;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.heuristicindex.SplitMetadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.joda.time.DateTimeZone;

public class OrcReader {
    public static final int MAX_BATCH_SIZE = 1024;
    public static final int INITIAL_BATCH_SIZE = 1;
    public static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private static final Logger log = Logger.get(OrcReader.class);
    private final OrcDataSource orcDataSource;
    private final ExceptionWrappingMetadataReader metadataReader;
    private final DataSize maxMergeDistance;
    private final DataSize tinyStripeThreshold;
    private final DataSize maxBlockSize;
    private final PostScript.HiveWriterVersion hiveWriterVersion;
    private final int bufferSize;
    private final CompressionKind compressionKind;
    private final Optional<OrcDecompressor> decompressor;
    private final Footer footer;
    private final Metadata metadata;
    private final OrcColumn rootColumn;
    private final Optional<OrcWriteValidation> writeValidation;

    public OrcReader(OrcDataSource orcDataSource, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize) throws IOException {
        this(orcDataSource, maxMergeDistance, tinyStripeThreshold, maxBlockSize, Optional.empty());
    }

    private OrcReader(OrcDataSource orcDataSource, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, Optional<OrcWriteValidation> writeValidation) throws IOException {
        this.orcDataSource = OrcReader.wrapWithCacheIfTiny(orcDataSource, tinyStripeThreshold);
        OrcFileTail fileTail = OrcFileTail.readFrom(this.orcDataSource, writeValidation);
        this.metadataReader = new ExceptionWrappingMetadataReader(orcDataSource.getId(), new OrcMetadataReader());
        this.bufferSize = Math.toIntExact(fileTail.getPostScript().getCompressionBlockSize());
        this.compressionKind = fileTail.getPostScript().getCompression();
        this.hiveWriterVersion = fileTail.getPostScript().getHiveWriterVersion();
        this.decompressor = fileTail.getDecompressor();
        this.metadata = fileTail.getMetadata();
        this.footer = fileTail.getFooter();
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        this.rootColumn = OrcReader.createOrcColumn("", "", new OrcColumnId(0), this.footer.getTypes(), orcDataSource.getId());
    }

    public OrcReader(OrcDataSource orcDataSource, OrcFileTail fileTail, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize) {
        this.orcDataSource = orcDataSource;
        this.metadataReader = new ExceptionWrappingMetadataReader(orcDataSource.getId(), new OrcMetadataReader());
        this.bufferSize = Math.toIntExact(fileTail.getPostScript().getCompressionBlockSize());
        this.compressionKind = fileTail.getPostScript().getCompression();
        this.hiveWriterVersion = fileTail.getPostScript().getHiveWriterVersion();
        this.decompressor = fileTail.getDecompressor();
        this.metadata = fileTail.getMetadata();
        this.footer = fileTail.getFooter();
        this.rootColumn = OrcReader.createOrcColumn("", "", new OrcColumnId(0), this.footer.getTypes(), orcDataSource.getId());
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.writeValidation = Optional.empty();
    }

    public List<String> getColumnNames() {
        return this.footer.getTypes().get(OrcColumnId.ROOT_COLUMN).getFieldNames();
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public OrcColumn getRootColumn() {
        return this.rootColumn;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public OrcRecordReader createRecordReader(List<OrcColumn> readColumns, List<Type> readTypes, OrcPredicate predicate, DateTimeZone legacyFileTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform) throws OrcCorruptionException {
        return this.createRecordReader(readColumns, readTypes, predicate, 0L, this.orcDataSource.getSize(), legacyFileTimeZone, systemMemoryUsage, initialBatchSize, exceptionTransform, Optional.empty(), null, Collections.emptyMap(), OrcCacheStore.CACHE_NOTHING, new OrcCacheProperties(), false);
    }

    public OrcRecordReader createRecordReader(List<OrcColumn> readColumns, List<Type> readTypes, OrcPredicate predicate, long offset, long length, DateTimeZone legacyFileTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform) throws OrcCorruptionException {
        return new OrcRecordReader(Objects.requireNonNull(readColumns, "readColumns is null"), Objects.requireNonNull(readTypes, "readTypes is null"), Objects.requireNonNull(predicate, "predicate is null"), this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.footer.getRowsInRowGroup(), Objects.requireNonNull(legacyFileTimeZone, "hiveStorageTimeZone is null"), this.hiveWriterVersion, (MetadataReader)this.metadataReader, this.maxMergeDistance, this.tinyStripeThreshold, this.maxBlockSize, this.footer.getUserMetadata(), systemMemoryUsage, this.writeValidation, initialBatchSize, exceptionTransform, Optional.empty(), null, Collections.emptyMap(), OrcCacheStore.CACHE_NOTHING, new OrcCacheProperties(), false);
    }

    public OrcRecordReader createRecordReader(List<OrcColumn> readColumns, List<Type> readTypes, OrcPredicate predicate, DateTimeZone legacyFileTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties) throws OrcCorruptionException {
        return this.createRecordReader(readColumns, readTypes, predicate, 0L, this.orcDataSource.getSize(), legacyFileTimeZone, systemMemoryUsage, initialBatchSize, exceptionTransform, Optional.empty(), null, Collections.emptyMap(), orcCacheStore, orcCacheProperties, false);
    }

    public OrcRecordReader createRecordReader(List<OrcColumn> readColumns, List<Type> readTypes, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform, Optional<List<IndexMetadata>> indexes, SplitMetadata splitMetadata, Map<String, Domain> domains, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties, boolean pageMetadataEnabled) throws OrcCorruptionException {
        return new OrcRecordReader(Objects.requireNonNull(readColumns, "readColumns is null"), Objects.requireNonNull(readTypes, "readTypes is null"), Objects.requireNonNull(predicate, "predicate is null"), this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.footer.getRowsInRowGroup(), Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null"), this.hiveWriterVersion, (MetadataReader)this.metadataReader, this.maxMergeDistance, this.tinyStripeThreshold, this.maxBlockSize, this.footer.getUserMetadata(), systemMemoryUsage, this.writeValidation, initialBatchSize, exceptionTransform, indexes, splitMetadata, domains, orcCacheStore, orcCacheProperties, pageMetadataEnabled);
    }

    public OrcSelectiveRecordReader createSelectiveRecordReader(List<OrcColumn> fileColumns, List<OrcColumn> fileReadColumns, List<Type> readTypes, List<Integer> outputColumns, Map<Integer, Type> includedColumns, Map<Integer, TupleDomainFilter> filters, Map<Integer, Object> constantValues, OrcPredicate predicate, long offset, long length, DateTimeZone legacyFileTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform, Optional<List<IndexMetadata>> indexes, Map<String, Domain> domains, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties, Optional<OrcWriteValidation> writeValidation, Map<Integer, List<TupleDomainFilter>> disjunctFilters, List<Integer> positions, boolean useDataCache, Map<Integer, Function<Block, Block>> coercer, Map<String, List<Domain>> orDomains, Set<Integer> missingColumns) throws OrcCorruptionException {
        return new OrcSelectiveRecordReader(outputColumns, includedColumns, Objects.requireNonNull(fileColumns, "readColumns is null"), Objects.requireNonNull(fileReadColumns, "readColumns is null"), Objects.requireNonNull(readTypes, "readTypes is null"), filters, constantValues, Objects.requireNonNull(predicate, "predicate is null"), this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.footer.getRowsInRowGroup(), Objects.requireNonNull(legacyFileTimeZone, "legacyFileTimeZone is null"), this.hiveWriterVersion, this.metadataReader, this.maxMergeDistance, this.tinyStripeThreshold, this.maxBlockSize, this.footer.getUserMetadata(), systemMemoryUsage, writeValidation, initialBatchSize, exceptionTransform, indexes, domains, orcCacheStore, orcCacheProperties, disjunctFilters, positions, useDataCache, coercer, orDomains, missingColumns);
    }

    public static OrcDataSource wrapWithCacheIfTiny(OrcDataSource dataSource, DataSize maxCacheSize) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        if (dataSource.getSize() > maxCacheSize.toBytes()) {
            return dataSource;
        }
        DiskRange diskRange = new DiskRange(0L, Math.toIntExact(dataSource.getSize()));
        return new CachingOrcDataSource(dataSource, desiredOffset -> diskRange);
    }

    private static OrcColumn createOrcColumn(String parentStreamName, String fieldName, OrcColumnId columnId, ColumnMetadata<OrcType> types, OrcDataSourceId orcDataSourceId) {
        String path = fieldName.isEmpty() ? parentStreamName : parentStreamName + "." + fieldName;
        OrcType orcType = types.get(columnId);
        Object nestedColumns = ImmutableList.of();
        if (orcType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT) {
            nestedColumns = (List)IntStream.range(0, orcType.getFieldCount()).mapToObj(fieldId -> OrcReader.createOrcColumn(path, orcType.getFieldName(fieldId), orcType.getFieldTypeIndex(fieldId), types, orcDataSourceId)).collect(ImmutableList.toImmutableList());
        } else if (orcType.getOrcTypeKind() == OrcType.OrcTypeKind.LIST) {
            nestedColumns = ImmutableList.of((Object)OrcReader.createOrcColumn(path, "item", orcType.getFieldTypeIndex(0), types, orcDataSourceId));
        } else if (orcType.getOrcTypeKind() == OrcType.OrcTypeKind.MAP) {
            nestedColumns = ImmutableList.of((Object)OrcReader.createOrcColumn(path, "key", orcType.getFieldTypeIndex(0), types, orcDataSourceId), (Object)OrcReader.createOrcColumn(path, "value", orcType.getFieldTypeIndex(1), types, orcDataSourceId));
        }
        return new OrcColumn(path, columnId, fieldName, orcType.getOrcTypeKind(), orcDataSourceId, (List<OrcColumn>)nestedColumns);
    }

    static void validateFile(OrcWriteValidation writeValidation, OrcDataSource input, List<Type> readTypes) throws OrcCorruptionException {
        try {
            OrcReader orcReader = new OrcReader(input, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(16.0, DataSize.Unit.MEGABYTE), Optional.of(writeValidation));
            try (OrcRecordReader orcRecordReader = orcReader.createRecordReader(orcReader.getRootColumn().getNestedColumns(), readTypes, OrcPredicate.TRUE, DateTimeZone.UTC, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1, exception -> {
                Throwables.throwIfUnchecked((Throwable)exception);
                return new RuntimeException((Throwable)exception);
            });){
                Page page = orcRecordReader.nextPage();
                while (page != null) {
                    page.getLoadedPage();
                    page = orcRecordReader.nextPage();
                }
            }
        }
        catch (IOException e) {
            throw new OrcCorruptionException(e, input.getId(), "Validation failed", new Object[0]);
        }
    }

    public static void handleCacheLoadException(Exception executionException) throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            if (executionException.getCause() instanceof PrestoException) {
                throw (PrestoException)executionException.getCause();
            }
            throw new IOException(executionException.getCause());
        }
    }
}

