/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.AbstractOrcRecordReader;
import io.prestosql.orc.OrcBlockFactory;
import io.prestosql.orc.OrcCacheProperties;
import io.prestosql.orc.OrcCacheStore;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDecompressor;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.MetadataReader;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.PostScript;
import io.prestosql.orc.metadata.StripeInformation;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.StripeStatistics;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ColumnReaders;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.heuristicindex.SplitMetadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class OrcRecordReader
extends AbstractOrcRecordReader<ColumnReader> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcRecordReader.class).instanceSize();
    private static final Logger log = Logger.get(OrcRecordReader.class);
    private SplitMetadata splitMetadata;
    private int pageCount;

    public OrcRecordReader(List<OrcColumn> readColumns, List<Type> readTypes, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, Optional<ColumnMetadata<ColumnStatistics>> fileStats, List<Optional<StripeStatistics>> stripeStats, OrcDataSource orcDataSource, long splitOffset, long splitLength, ColumnMetadata<OrcType> orcTypes, Optional<OrcDecompressor> decompressor, int rowsInRowGroup, DateTimeZone legacyFileTimeZone, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, Map<String, Slice> userMetadata, AggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform, Optional<List<IndexMetadata>> indexes, SplitMetadata splitMetadata, Map<String, Domain> domains, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties, boolean pageMetadataEnabled) throws OrcCorruptionException {
        super(readColumns, readTypes, predicate, numberOfRows, fileStripes, fileStats, stripeStats, orcDataSource, splitOffset, splitLength, orcTypes, decompressor, rowsInRowGroup, legacyFileTimeZone, hiveWriterVersion, metadataReader, maxMergeDistance, tinyStripeThreshold, maxBlockSize, userMetadata, systemMemoryUsage, writeValidation, initialBatchSize, exceptionTransform, indexes, domains, orcCacheStore, orcCacheProperties, (Map<String, List<Domain>>)ImmutableMap.of(), pageMetadataEnabled);
        this.splitMetadata = splitMetadata;
        this.setColumnReadersParam(this.createColumnReaders(readColumns, readTypes, systemMemoryUsage.newAggregatedMemoryContext(), new OrcBlockFactory(exceptionTransform, true), orcCacheStore, orcCacheProperties));
    }

    public Page nextPage() throws IOException {
        ColumnReader[] columnsReader = (ColumnReader[])this.getColumnReaders();
        int batchSize = this.prepareNextBatch();
        if (batchSize < 0) {
            return null;
        }
        for (ColumnReader column : columnsReader) {
            if (column == null) continue;
            column.prepareNextRead(batchSize);
        }
        this.batchRead(batchSize);
        this.matchingRowsInBatchArray = null;
        this.validateWritePageChecksum(batchSize);
        this.blockFactory.nextPage();
        Arrays.fill(this.currentBytesPerCell, 0L);
        Block[] blocks = new Block[columnsReader.length];
        int i = 0;
        while (i < columnsReader.length) {
            int columnIndex = i++;
            blocks[columnIndex] = this.blockFactory.createBlock(batchSize, () -> this.filterRows(columnsReader[columnIndex].readBlock()), block -> this.blockLoaded(columnIndex, (Block)block));
        }
        if (this.pageMetadataEnabled) {
            Properties pageMetadata = new Properties();
            ++this.pageCount;
            pageMetadata.setProperty("datasource_page_number", String.valueOf(this.pageCount));
            if (this.isCurrentStripeFinished().booleanValue()) {
                pageMetadata.setProperty("datasource_total_pages", String.valueOf(this.pageCount));
                this.pageCount = 0;
            }
            pageMetadata.setProperty("datasource_stripe_number", String.valueOf(this.currentStripe));
            pageMetadata.setProperty("datasource_stripe_offset", String.valueOf(((StripeInformation)this.stripes.get(this.currentStripe)).getOffset()));
            pageMetadata.setProperty("datasource_stripe_length", String.valueOf(((StripeInformation)this.stripes.get(this.currentStripe)).getTotalLength()));
            if (this.splitMetadata != null) {
                pageMetadata.setProperty("datasource_file_path", this.splitMetadata.getSplitIdentity());
                pageMetadata.setProperty("datasource_file_modification", String.valueOf(this.splitMetadata.getLastModifiedTime()));
            }
            pageMetadata.setProperty("datasource_index_level", "STRIPE");
            return new Page(batchSize, pageMetadata, blocks);
        }
        return new Page(batchSize, blocks);
    }

    private Block filterRows(Block block) {
        StripeInformation stripe = (StripeInformation)this.stripes.get(this.currentStripe);
        if (this.matchingRowsInBatchArray == null && this.stripeMatchingRows.containsKey(stripe) && block.getPositionCount() != 0) {
            long currentPositionInStripe = this.currentPosition - this.currentStripePosition;
            PeekingIterator matchingRows = (PeekingIterator)this.stripeMatchingRows.get(stripe);
            ArrayList<Integer> matchingRowsInBlock = new ArrayList<Integer>();
            while (matchingRows.hasNext()) {
                Integer row = (Integer)matchingRows.peek();
                if ((long)row.intValue() < currentPositionInStripe) {
                    matchingRows.next();
                    continue;
                }
                if ((long)row.intValue() >= currentPositionInStripe + (long)this.currentBatchSize) break;
                matchingRowsInBlock.add(Math.toIntExact(Long.valueOf(row.intValue()) - currentPositionInStripe));
                matchingRows.next();
            }
            this.matchingRowsInBatchArray = new int[matchingRowsInBlock.size()];
            IntStream.range(0, matchingRowsInBlock.size()).forEach(i -> {
                this.matchingRowsInBatchArray[i] = (Integer)matchingRowsInBlock.get(i);
            });
        }
        if (this.matchingRowsInBatchArray != null) {
            return block.copyPositions(this.matchingRowsInBatchArray, 0, this.matchingRowsInBatchArray.length);
        }
        return block;
    }

    @Override
    public Map<String, Slice> getUserMetadata() {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)this.userMetadata, Slices::copyOf));
    }

    @Override
    @VisibleForTesting
    protected long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + super.getRetainedSizeInBytes();
    }

    private void validateWritePageChecksum(int batchSize) throws IOException {
        if (this.writeChecksumBuilder.isPresent()) {
            ColumnReader[] columnsReader = (ColumnReader[])this.getColumnReaders();
            Block[] blocks = new Block[columnsReader.length];
            for (int columnIndex = 0; columnIndex < columnsReader.length; ++columnIndex) {
                Block block;
                blocks[columnIndex] = block = columnsReader[columnIndex].readBlock();
                this.blockLoaded(columnIndex, block);
            }
            Page page = new Page(batchSize, blocks);
            this.validateWritePageChecksum(page);
        }
    }

    private ColumnReader[] createColumnReaders(List<OrcColumn> columns, List<Type> readTypes, AggregatedMemoryContext systemMemoryContext, OrcBlockFactory blockFactory, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties) throws OrcCorruptionException {
        ColumnReader[] columnReaders = new ColumnReader[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            int columnIndex = i;
            Type readType = readTypes.get(columnIndex);
            OrcColumn column = columns.get(columnIndex);
            ColumnReader columnReader = ColumnReaders.createColumnReader(readType, column, systemMemoryContext, blockFactory.createNestedBlockFactory(block -> this.blockLoaded(columnIndex, (Block)block)));
            if (orcCacheProperties.isRowDataCacheEnabled()) {
                columnReader = ColumnReaders.wrapWithCachingStreamReader(columnReader, column, orcCacheStore.getRowDataCache());
            }
            columnReaders[columnIndex] = columnReader;
        }
        return columnReaders;
    }
}

