/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.Preconditions;
import com.google.common.collect.PeekingIterator;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.AbstractOrcRecordReader;
import io.prestosql.orc.OrcBlockFactory;
import io.prestosql.orc.OrcCacheProperties;
import io.prestosql.orc.OrcCacheStore;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDecompressor;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.MetadataReader;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.PostScript;
import io.prestosql.orc.metadata.StripeInformation;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.StripeStatistics;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ColumnReaders;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.reader.SelectiveColumnReaders;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeNotFoundException;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.joda.time.DateTimeZone;

public class OrcSelectiveRecordReader
extends AbstractOrcRecordReader<SelectiveColumnReader> {
    private static final Logger log = Logger.get(OrcSelectiveRecordReader.class);
    private static final byte[] NULL_MARKER = new byte[0];
    private final List<Integer> excludePositions;
    private final List<Integer> columnReaderOrder;
    private final Map<Integer, TupleDomainFilter> filters;
    List<Integer> outputColumns;
    Map<Integer, Type> includedColumns;
    private final Map<Integer, Object> constantValues;
    Set<Integer> colReaderWithFilter;
    Set<Integer> colReaderWithORFilter;
    Set<Integer> colReaderWithoutFilter;
    Map<Integer, List<TupleDomainFilter>> disjuctFilters;
    Map<Integer, Function<Block, Block>> coercers;
    private final Set<Integer> missingColumns;
    private boolean constantFilterIsFalse;

    public OrcSelectiveRecordReader(List<Integer> outputColumns, Map<Integer, Type> includedColumns, List<OrcColumn> fileColumns, List<OrcColumn> fileReadColumns, List<Type> readTypes, Map<Integer, TupleDomainFilter> filters, Map<Integer, Object> constantValues, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, Optional<ColumnMetadata<ColumnStatistics>> fileStats, List<Optional<StripeStatistics>> stripeStats, OrcDataSource orcDataSource, long splitOffset, long splitLength, ColumnMetadata<OrcType> orcTypes, Optional<OrcDecompressor> decompressor, int rowsInRowGroup, DateTimeZone hiveStorageTimeZone, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, Map<String, Slice> userMetadata, AggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform, Optional<List<IndexMetadata>> indexes, Map<String, Domain> domains, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties, Map<Integer, List<TupleDomainFilter>> disjuctFilters, List<Integer> positions, boolean useDataCache, Map<Integer, Function<Block, Block>> coercers, Map<String, List<Domain>> orDomains, Set<Integer> missingColumns) throws OrcCorruptionException {
        super(fileReadColumns, readTypes, predicate, numberOfRows, fileStripes, fileStats, stripeStats, orcDataSource, splitOffset, splitLength, orcTypes, decompressor, rowsInRowGroup, hiveStorageTimeZone, hiveWriterVersion, metadataReader, maxMergeDistance, tinyStripeThreshold, maxBlockSize, userMetadata, systemMemoryUsage, writeValidation, initialBatchSize, exceptionTransform, indexes, domains, orcCacheStore, orcCacheProperties, orDomains, false);
        int fieldCount = orcTypes.get(OrcColumnId.ROOT_COLUMN).getFieldCount();
        this.columnReaderOrder = new ArrayList<Integer>(fieldCount);
        this.outputColumns = outputColumns;
        this.includedColumns = includedColumns;
        this.excludePositions = positions;
        this.filters = filters;
        this.disjuctFilters = disjuctFilters;
        this.constantValues = Objects.requireNonNull(constantValues, "constantValues is null");
        this.coercers = Objects.requireNonNull(coercers, "coercers is null");
        this.missingColumns = Objects.requireNonNull(missingColumns, "missingColumns is null");
        for (Map.Entry<Integer, Function<Block, Block>> entry : coercers.entrySet()) {
            Preconditions.checkArgument((!filters.containsKey(entry.getKey()) ? 1 : 0) != 0, (Object)"Coercions for columns with range filters are not yet supported");
        }
        Iterator<Object> iterator = missingColumns.iterator();
        while (iterator.hasNext()) {
            int missingColumn = (Integer)iterator.next();
            if (!this.constantFilterIsFalse && OrcSelectiveRecordReader.containsNonNullFilter(filters.get(missingColumn))) {
                this.constantFilterIsFalse = true;
            }
            this.constantValues.put(missingColumn, NULL_MARKER);
        }
        this.setColumnReadersParam(this.createColumnReaders(fileColumns, systemMemoryUsage.newAggregatedMemoryContext(), new OrcBlockFactory(exceptionTransform, true), orcCacheStore, orcCacheProperties, predicate, filters, hiveStorageTimeZone, outputColumns, includedColumns, orcTypes, useDataCache));
    }

    private static boolean containsNonNullFilter(TupleDomainFilter columnFilters) {
        return columnFilters != null && !columnFilters.testNull();
    }

    public Page getNextPage() throws IOException {
        int batchSize = this.prepareNextBatch();
        if (batchSize < 0) {
            return null;
        }
        if (this.constantFilterIsFalse && this.colReaderWithORFilter.isEmpty()) {
            this.batchRead(batchSize);
            return new Page(0, new Block[0]);
        }
        this.matchingRowsInBatchArray = null;
        int[] positionsToRead = this.initializePositions(batchSize);
        int positionCount = positionsToRead.length;
        SelectiveColumnReader[] columnReaders = (SelectiveColumnReader[])this.getColumnReaders();
        if (positionCount != 0) {
            for (Integer columnIdx : this.colReaderWithFilter) {
                if (columnIdx < 0) {
                    if (this.matchConstantWithPredicate(this.includedColumns.get(columnIdx), this.constantValues.get(columnIdx), this.filters.get(columnIdx))) continue;
                    positionCount = 0;
                    break;
                }
                if (this.missingColumns.contains(columnIdx)) {
                    if (this.filters.get(columnIdx).testNull()) continue;
                    positionCount = 0;
                    break;
                }
                if (columnReaders[columnIdx] == null) continue;
                positionCount = columnReaders[columnIdx].read(this.getNextRowInGroup(), positionsToRead, positionCount, this.filters.get(columnIdx));
                if (positionCount == 0) break;
                positionsToRead = columnReaders[columnIdx].getReadPositions();
            }
        }
        BitSet accumulator = new BitSet();
        if (this.colReaderWithORFilter.size() > 0 && positionCount > 0) {
            int localPositionCount = positionCount;
            for (Integer columnIdx : this.colReaderWithORFilter) {
                if (columnIdx < 0) {
                    if (!this.matchConstantWithPredicate(this.includedColumns.get(columnIdx), this.constantValues.get(columnIdx), this.disjuctFilters.get(columnIdx).get(0))) continue;
                    accumulator.set(positionsToRead[0], positionsToRead[positionCount - 1] + 1);
                    continue;
                }
                if (this.missingColumns.contains(columnIdx)) {
                    if (!this.disjuctFilters.get(columnIdx).get(0).testNull()) continue;
                    accumulator.set(positionsToRead[0], positionsToRead[positionCount - 1] + 1);
                    continue;
                }
                if (columnReaders[columnIdx] == null) continue;
                localPositionCount += columnReaders[columnIdx].readOr(this.getNextRowInGroup(), positionsToRead, positionCount, this.disjuctFilters.get(columnIdx), accumulator);
            }
            int[] newPositions = (int[])positionsToRead.clone();
            positionCount = this.updateExcludePositions(positionsToRead, positionCount, accumulator, newPositions);
            positionsToRead = Arrays.copyOf(newPositions, positionCount);
        }
        if (positionCount != 0) {
            for (Integer columnIdx : this.colReaderWithoutFilter) {
                if (columnReaders[columnIdx] == null) continue;
                positionCount = columnReaders[columnIdx].read(this.getNextRowInGroup(), positionsToRead, positionCount, null);
                if (positionCount == 0) break;
                positionsToRead = columnReaders[columnIdx].getReadPositions();
            }
        }
        this.batchRead(batchSize);
        if (positionCount == 0) {
            return new Page(0, new Block[0]);
        }
        Block[] blocks = new Block[this.outputColumns.size()];
        for (int i = 0; i < this.outputColumns.size(); ++i) {
            int columnIndex = this.outputColumns.get(i);
            if (columnIndex < 0 || this.missingColumns.contains(columnIndex)) {
                blocks[i] = RunLengthEncodedBlock.create((Type)this.includedColumns.get(columnIndex), this.constantValues.get(columnIndex) == NULL_MARKER ? null : this.constantValues.get(columnIndex), (int)positionCount);
                continue;
            }
            Block block = ((SelectiveColumnReader[])this.getColumnReaders())[columnIndex].getBlock(positionsToRead, positionCount);
            this.updateMaxCombinedBytesPerRow(columnIndex, block);
            if (this.coercers.containsKey(i)) {
                block = this.coercers.get(i).apply(block);
            }
            blocks[i] = block;
        }
        Page page = new Page(positionCount, blocks);
        this.validateWritePageChecksum(page);
        return page;
    }

    private int[] initializePositions(int batchSize) {
        StripeInformation stripe = (StripeInformation)this.stripes.get(this.currentStripe);
        if (this.matchingRowsInBatchArray == null && this.stripeMatchingRows.containsKey(stripe)) {
            long currentPositionInStripe = this.currentPosition - this.currentStripePosition;
            PeekingIterator matchingRows = (PeekingIterator)this.stripeMatchingRows.get(stripe);
            ArrayList<Integer> matchingRowsInBlock = new ArrayList<Integer>();
            while (matchingRows.hasNext()) {
                Integer row = (Integer)matchingRows.peek();
                if ((long)row.intValue() < currentPositionInStripe) {
                    matchingRows.next();
                    continue;
                }
                if ((long)row.intValue() >= currentPositionInStripe + (long)batchSize) break;
                matchingRowsInBlock.add(Math.toIntExact(Long.valueOf(row.intValue()) - currentPositionInStripe));
                matchingRows.next();
            }
            this.matchingRowsInBatchArray = new int[matchingRowsInBlock.size()];
            IntStream.range(0, matchingRowsInBlock.size()).forEach(i -> {
                this.matchingRowsInBatchArray[i] = (Integer)matchingRowsInBlock.get(i);
            });
        }
        if (this.matchingRowsInBatchArray != null) {
            return this.matchingRowsInBatchArray;
        }
        int[] positions = new int[batchSize];
        for (int i2 = 0; i2 < batchSize; ++i2) {
            positions[i2] = i2;
        }
        return positions;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private int updateExcludePositions(int[] positions, int positionCount, BitSet accumulator, int[] newPositions) {
        int totalPositions = 0;
        for (int i = 0; i < positionCount; ++i) {
            if (!accumulator.get(positions[i])) continue;
            newPositions[totalPositions++] = positions[i];
        }
        return totalPositions;
    }

    public SelectiveColumnReader[] createColumnReaders(List<OrcColumn> fileColumns, AggregatedMemoryContext systemMemoryContext, OrcBlockFactory blockFactory, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties, OrcPredicate predicate, Map<Integer, TupleDomainFilter> filters, DateTimeZone hiveStorageTimeZone, List<Integer> outputColumns, Map<Integer, Type> includedColumns, ColumnMetadata<OrcType> orcTypes, boolean useDataCache) throws OrcCorruptionException {
        int fieldCount = orcTypes.get(OrcColumnId.ROOT_COLUMN).getFieldCount();
        SelectiveColumnReader[] columnReaders = new SelectiveColumnReader[fieldCount];
        this.colReaderWithFilter = new IntArraySet();
        this.colReaderWithORFilter = new IntArraySet();
        this.colReaderWithoutFilter = new IntArraySet();
        IntArraySet remainingColumns = new IntArraySet();
        remainingColumns.addAll(includedColumns.keySet());
        for (int i = 0; i < fieldCount; ++i) {
            if (!includedColumns.containsKey(i)) continue;
            int columnIndex = i;
            OrcColumn column = fileColumns.get(columnIndex);
            boolean outputRequired = outputColumns.contains(i);
            SelectiveColumnReader columnReader = null;
            if (useDataCache && orcCacheProperties.isRowDataCacheEnabled()) {
                ColumnReader cr = ColumnReaders.createColumnReader(includedColumns.get(i), column, systemMemoryContext, blockFactory.createNestedBlockFactory(block -> this.blockLoaded(columnIndex, (Block)block)));
                columnReader = SelectiveColumnReaders.wrapWithDataCachingStreamReader(cr, column, orcCacheStore.getRowDataCache());
            } else {
                columnReader = SelectiveColumnReaders.createColumnReader(orcTypes.get(column.getColumnId()), column, Optional.ofNullable(filters.get(i)), outputRequired ? Optional.of(includedColumns.get(i)) : Optional.empty(), hiveStorageTimeZone, systemMemoryContext);
                if (orcCacheProperties.isRowDataCacheEnabled()) {
                    columnReader = SelectiveColumnReaders.wrapWithResultCachingStreamReader(columnReader, column, predicate, orcCacheStore.getRowDataCache());
                }
            }
            columnReaders[columnIndex] = columnReader;
            if (filters.get(i) != null) {
                this.colReaderWithFilter.add(columnIndex);
            } else if (this.disjuctFilters.get(i) != null && this.disjuctFilters.get(i).size() > 0) {
                this.colReaderWithORFilter.add(columnIndex);
            } else {
                this.colReaderWithoutFilter.add(columnIndex);
            }
            remainingColumns.remove(columnIndex);
        }
        remainingColumns.removeAll(this.missingColumns);
        for (Integer col : remainingColumns) {
            if (col >= 0) continue;
            if (filters.get(col) != null) {
                this.colReaderWithFilter.add(col);
                continue;
            }
            if (this.disjuctFilters.get(col) == null || this.disjuctFilters.get(col).size() <= 0) continue;
            this.colReaderWithORFilter.add(col);
        }
        Iterator<Integer> iterator = this.missingColumns.iterator();
        while (iterator.hasNext()) {
            int missingColumn = (Integer)iterator.next();
            if (filters.get(missingColumn) != null) {
                this.colReaderWithFilter.add(missingColumn);
                continue;
            }
            if (this.disjuctFilters.get(missingColumn) == null || this.disjuctFilters.get(missingColumn).size() <= 0) continue;
            this.colReaderWithORFilter.add(missingColumn);
        }
        return columnReaders;
    }

    private boolean matchConstantWithPredicate(Type type, Object value, TupleDomainFilter filter) {
        if (value == null) {
            return filter.testNull();
        }
        if (type.getJavaType() == Boolean.TYPE) {
            return filter.testBoolean((Boolean)value);
        }
        if (type.getJavaType() == Double.TYPE) {
            return filter.testDouble(((Number)value).doubleValue());
        }
        if (type.getJavaType() == Float.TYPE) {
            return filter.testFloat(((Number)value).floatValue());
        }
        if (type.getJavaType() == Long.TYPE) {
            return filter.testLong(((Number)value).longValue());
        }
        if (type.getJavaType() == Integer.TYPE) {
            return filter.testLong(((Number)value).intValue());
        }
        if (type.getJavaType() == Slice.class) {
            byte[] strVal = value instanceof byte[] ? (byte[])value : (value instanceof String ? ((String)value).getBytes() : ((Slice)value).getBytes());
            return filter.testBytes(strVal, 0, strVal.length);
        }
        if (type.getJavaType() == long[].class) {
            long[] data = (long[])value;
            return filter.testDecimal(data[0], data[1]);
        }
        throw new TypeNotFoundException(type.getTypeSignature());
    }
}

