/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.orc.ByteArrayUtils;
import io.prestosql.spi.type.UnscaledDecimal128Arithmetic;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public interface TupleDomainFilter {
    public boolean testNull();

    public boolean testLong(long var1);

    public boolean testBoolean(boolean var1);

    public boolean testBytes(byte[] var1, int var2, int var3);

    public boolean testDouble(double var1);

    public boolean testLength(int var1);

    public boolean testDecimal(long var1, long var3);

    public boolean testFloat(float var1);

    default public boolean isSingleValue() {
        return false;
    }

    public static class MultiValues
    extends AbstractTupleDomainFilter {
        Set values;

        private MultiValues(Set values, boolean nullAllowed) {
            super(nullAllowed);
            this.values = values;
        }

        public static MultiValues of(Set byteValues, boolean nullAllowed) {
            return new MultiValues(byteValues, nullAllowed);
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            return this.values.contains(new ExtendedByte(Arrays.copyOfRange(buffer, offset, offset + length)));
        }

        @Override
        public boolean testLength(int length) {
            return true;
        }

        @Override
        public boolean testFloat(float value) {
            if (Float.isNaN(value)) {
                return false;
            }
            return this.values.contains(Float.valueOf(value));
        }

        @Override
        public boolean testDouble(double value) {
            if (Double.isNaN(value)) {
                return false;
            }
            return this.values.contains(value);
        }

        @Override
        public boolean testDecimal(long low, long high) {
            return this.values.contains(new LongDecimalValue(low, high));
        }

        public int hashCode() {
            return Objects.hash(this.values, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MultiValues other = (MultiValues)obj;
            return this.values.equals(other.values) && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("values", (Object)this.values).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class LongDecimalValue {
        long lowerLow;
        long lowerHigh;

        LongDecimalValue(long lowerLow, long lowerHigh) {
            this.lowerLow = lowerLow;
            this.lowerHigh = lowerHigh;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongDecimalValue that = (LongDecimalValue)o;
            return this.lowerLow == that.lowerLow && this.lowerHigh == that.lowerHigh;
        }

        public int hashCode() {
            return Arrays.hashCode(new long[]{this.lowerLow, this.lowerHigh});
        }
    }

    public static class ExtendedByte {
        byte[] value;

        ExtendedByte(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtendedByte that = (ExtendedByte)o;
            return Arrays.equals(this.value, that.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }

    public static class FloatRange
    extends AbstractRange {
        private final float lower;
        private final float upper;

        private FloatRange(float lower, boolean lowerUnbounded, boolean lowerExclusive, float upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(lowerUnbounded, lowerExclusive, upperUnbounded, upperExclusive, nullAllowed);
            Preconditions.checkArgument((lowerUnbounded || !Float.isNaN(lower) ? 1 : 0) != 0);
            Preconditions.checkArgument((upperUnbounded || !Float.isNaN(upper) ? 1 : 0) != 0);
            this.lower = lower;
            this.upper = upper;
        }

        public static FloatRange of(float lower, boolean lowerUnbounded, boolean lowerExclusive, float upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            return new FloatRange(lower, lowerUnbounded, lowerExclusive, upper, upperUnbounded, upperExclusive, nullAllowed);
        }

        @Override
        public boolean isSingleValue() {
            return this.lower == this.upper && !this.lowerExclusive && !this.upperExclusive;
        }

        public float getLower() {
            return this.lower;
        }

        @Override
        public boolean testFloat(float value) {
            if (Float.isNaN(value)) {
                return false;
            }
            if (!this.lowerUnbounded) {
                if (value < this.lower) {
                    return false;
                }
                if (this.lowerExclusive && this.lower == value) {
                    return false;
                }
            }
            if (!this.upperUnbounded) {
                if (value > this.upper) {
                    return false;
                }
                if (this.upperExclusive && value == this.upper) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.lower), this.lowerUnbounded, this.lowerExclusive, Float.valueOf(this.upper), this.upperUnbounded, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FloatRange other = (FloatRange)obj;
            return this.lower == other.lower && this.lowerUnbounded == other.lowerUnbounded && this.lowerExclusive == other.lowerExclusive && this.upper == other.upper && this.upperUnbounded == other.upperUnbounded && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lower", this.lower).add("lowerUnbounded", this.lowerUnbounded).add("lowerExclusive", this.lowerExclusive).add("upper", this.upper).add("upperUnbounded", this.upperUnbounded).add("upperExclusive", this.upperExclusive).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class LongDecimalRange
    extends AbstractRange {
        private final long lowerLow;
        private final long lowerHigh;
        private final long upperLow;
        private final long upperHigh;

        private LongDecimalRange(long lowerLow, long lowerHigh, boolean lowerUnbounded, boolean lowerExclusive, long upperLow, long upperHigh, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(lowerUnbounded, lowerExclusive, upperUnbounded, upperExclusive, nullAllowed);
            this.lowerLow = lowerLow;
            this.lowerHigh = lowerHigh;
            this.upperLow = upperLow;
            this.upperHigh = upperHigh;
        }

        public static LongDecimalRange of(long lowerLow, long lowerHigh, boolean lowerUnbounded, boolean lowerExclusive, long upperLow, long upperHigh, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            return new LongDecimalRange(lowerLow, lowerHigh, lowerUnbounded, lowerExclusive, upperLow, upperHigh, upperUnbounded, upperExclusive, nullAllowed);
        }

        @Override
        public boolean isSingleValue() {
            return this.lowerLow == this.upperLow && this.lowerHigh == this.upperHigh && !this.lowerExclusive && !this.upperExclusive;
        }

        public long getLowerLow() {
            return this.lowerLow;
        }

        public long getLowerHigh() {
            return this.lowerHigh;
        }

        @Override
        public boolean testDecimal(long valueLow, long valueHigh) {
            int result;
            if (!this.lowerUnbounded) {
                result = UnscaledDecimal128Arithmetic.compare((long)valueLow, (long)valueHigh, (long)this.lowerLow, (long)this.lowerHigh);
                if (result < 0) {
                    return false;
                }
                if (this.lowerExclusive && result == 0) {
                    return false;
                }
            }
            if (!this.upperUnbounded) {
                result = UnscaledDecimal128Arithmetic.compare((long)valueLow, (long)valueHigh, (long)this.upperLow, (long)this.upperHigh);
                if (result > 0) {
                    return false;
                }
                if (this.upperExclusive && result == 0) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.lowerLow, this.lowerHigh, this.lowerUnbounded, this.lowerExclusive, this.upperLow, this.upperHigh, this.upperUnbounded, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LongDecimalRange other = (LongDecimalRange)obj;
            return this.lowerLow == other.lowerLow && this.lowerHigh == other.lowerHigh && this.lowerUnbounded == other.lowerUnbounded && this.lowerExclusive == other.lowerExclusive && this.upperLow == other.upperLow && this.upperHigh == other.upperHigh && this.upperUnbounded == other.upperUnbounded && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lowerLow", this.lowerLow).add("lowerHigh", this.lowerHigh).add("lowerUnbounded", this.lowerUnbounded).add("lowerExclusive", this.lowerExclusive).add("upperLow", this.upperLow).add("upperHigh", this.upperHigh).add("upperUnbounded", this.upperUnbounded).add("upperExclusive", this.upperExclusive).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class MultiRange
    extends AbstractTupleDomainFilter {
        private final TupleDomainFilter[] filters;

        private MultiRange(List<TupleDomainFilter> filters, boolean nullAllowed) {
            super(nullAllowed);
            Objects.requireNonNull(filters, "filters is null");
            Preconditions.checkArgument((filters.size() > 1 ? 1 : 0) != 0, (Object)"filters must contain at least 2 entries");
            this.filters = filters.toArray(new TupleDomainFilter[0]);
        }

        public static MultiRange of(List<TupleDomainFilter> filters, boolean nullAllowed) {
            return new MultiRange(filters, nullAllowed);
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testBytes(buffer, offset, length)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testLength(int length) {
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testLength(length)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testDouble(double value) {
            if (Double.isNaN(value)) {
                return false;
            }
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testDouble(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testDecimal(long low, long high) {
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testDecimal(low, high)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testFloat(float value) {
            for (TupleDomainFilter filter : this.filters) {
                if (!filter.testFloat(value)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiRange that = (MultiRange)o;
            return Arrays.equals(this.filters, that.filters) && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.filters, this.nullAllowed);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("filters", (Object)this.filters).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class BigintMultiRange
    extends AbstractTupleDomainFilter {
        private final BigintRange[] ranges;
        private final long[] longLowerBounds;

        private BigintMultiRange(List<BigintRange> ranges, boolean nullAllowed) {
            super(nullAllowed);
            Objects.requireNonNull(ranges, "ranges is null");
            Preconditions.checkArgument((!ranges.isEmpty() ? 1 : 0) != 0, (Object)"ranges is empty");
            this.ranges = ranges.toArray(new BigintRange[0]);
            this.longLowerBounds = ranges.stream().mapToLong(BigintRange::getLower).toArray();
            for (int i = 1; i < this.longLowerBounds.length; ++i) {
                Preconditions.checkArgument((this.longLowerBounds[i] >= ranges.get(i - 1).getUpper() ? 1 : 0) != 0, (Object)"bigint ranges must not overlap");
            }
        }

        public static BigintMultiRange of(List<BigintRange> ranges, boolean nullAllowed) {
            return new BigintMultiRange(ranges, nullAllowed);
        }

        @Override
        public boolean testLong(long value) {
            int i = Arrays.binarySearch(this.longLowerBounds, value);
            if (i >= 0) {
                return true;
            }
            int place = -i - 1;
            if (place == 0) {
                return false;
            }
            return this.ranges[place - 1].testLong(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigintMultiRange that = (BigintMultiRange)o;
            return Arrays.equals(this.ranges, that.ranges) && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.ranges, this.nullAllowed);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("ranges", (Object)this.ranges).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class BytesRange
    extends AbstractTupleDomainFilter {
        private final byte[] lower;
        private final byte[] upper;
        private final boolean lowerExclusive;
        private final boolean upperExclusive;
        private final boolean singleValue;

        private BytesRange(byte[] lower, boolean lowerExclusive, byte[] upper, boolean upperExclusive, boolean nullAllowed) {
            super(nullAllowed);
            this.lower = lower;
            this.upper = upper;
            this.lowerExclusive = lowerExclusive;
            this.upperExclusive = upperExclusive;
            this.singleValue = !lowerExclusive && !upperExclusive && Arrays.equals(upper, lower);
        }

        @Override
        public boolean isSingleValue() {
            return this.singleValue;
        }

        public byte[] getLower() {
            return this.lower;
        }

        public static BytesRange of(byte[] lower, boolean lowerExclusive, byte[] upper, boolean upperExclusive, boolean nullAllowed) {
            return new BytesRange(lower, lowerExclusive, upper, upperExclusive, nullAllowed);
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            int compare;
            if (this.singleValue) {
                if (length != this.lower.length) {
                    return false;
                }
                for (int i = 0; i < length; ++i) {
                    if (buffer[i + offset] == this.lower[i]) continue;
                    return false;
                }
                return true;
            }
            if (this.lower != null && ((compare = ByteArrayUtils.compareRanges(buffer, offset, length, this.lower, 0, this.lower.length)) < 0 || this.lowerExclusive && compare == 0)) {
                return false;
            }
            if (this.upper != null) {
                compare = ByteArrayUtils.compareRanges(buffer, offset, length, this.upper, 0, this.upper.length);
                return compare < 0 || !this.upperExclusive && compare == 0;
            }
            return true;
        }

        @Override
        public boolean testLength(int length) {
            return !this.singleValue || this.lower.length == length;
        }

        public int hashCode() {
            return Objects.hash(this.lower, this.lowerExclusive, this.upper, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BytesRange other = (BytesRange)obj;
            return Arrays.equals(this.lower, other.lower) && this.lowerExclusive == other.lowerExclusive && Arrays.equals(this.upper, other.upper) && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lower", (Object)this.lower).add("lowerExclusive", this.lowerExclusive).add("upper", (Object)this.upper).add("upperExclusive", this.upperExclusive).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class BigintValues
    extends AbstractTupleDomainFilter {
        private static final long EMPTY_MARKER = -2401053089476968723L;
        private static final long M = -4132994306676758123L;
        private final long[] values;
        private final long[] hashTable;
        private final int size;
        private boolean containsEmptyMarker;

        private BigintValues(long[] values, boolean nullAllowed) {
            super(nullAllowed);
            Objects.requireNonNull(values, "values is null");
            Preconditions.checkArgument((values.length > 1 ? 1 : 0) != 0, (Object)"values must contain at least 2 entries");
            this.values = values;
            this.size = Integer.highestOneBit(values.length * 3);
            this.hashTable = new long[this.size];
            Arrays.fill(this.hashTable, -2401053089476968723L);
            block0: for (long value : values) {
                int position;
                if (value == -2401053089476968723L) {
                    this.containsEmptyMarker = true;
                    continue;
                }
                for (int i = position = (int)(value * -4132994306676758123L & (long)(this.size - 1)); i < position + this.size; ++i) {
                    int index = i & this.size - 1;
                    if (this.hashTable[index] != -2401053089476968723L) continue;
                    this.hashTable[index] = value;
                    continue block0;
                }
            }
        }

        public static BigintValues of(long[] values, boolean nullAllowed) {
            return new BigintValues(values, nullAllowed);
        }

        @Override
        public boolean testLong(long value) {
            int pos;
            if (this.containsEmptyMarker && value == -2401053089476968723L) {
                return true;
            }
            for (int i = pos = (int)(value * -4132994306676758123L & (long)(this.size - 1)); i < pos + this.size; ++i) {
                int idx = i & this.size - 1;
                long l = this.hashTable[idx];
                if (l == -2401053089476968723L) {
                    return false;
                }
                if (l != value) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigintValues that = (BigintValues)o;
            return this.size == that.size && this.containsEmptyMarker == that.containsEmptyMarker && Arrays.equals(this.hashTable, that.hashTable) && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.size, this.containsEmptyMarker, this.hashTable, this.nullAllowed);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("values", (Object)this.values).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class DoubleRange
    extends AbstractRange {
        private final double lower;
        private final double upper;

        private DoubleRange(double lower, boolean lowerUnbounded, boolean lowerExclusive, double upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(lowerUnbounded, lowerExclusive, upperUnbounded, upperExclusive, nullAllowed);
            Preconditions.checkArgument((lowerUnbounded || !Double.isNaN(lower) ? 1 : 0) != 0);
            Preconditions.checkArgument((upperUnbounded || !Double.isNaN(upper) ? 1 : 0) != 0);
            this.lower = lower;
            this.upper = upper;
        }

        public static DoubleRange of(double lower, boolean lowerUnbounded, boolean lowerExclusive, double upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            return new DoubleRange(lower, lowerUnbounded, lowerExclusive, upper, upperUnbounded, upperExclusive, nullAllowed);
        }

        @Override
        public boolean isSingleValue() {
            return this.lower == this.upper && !this.lowerExclusive && !this.upperExclusive;
        }

        public double getLower() {
            return this.lower;
        }

        public double getUpper() {
            return this.upper;
        }

        @Override
        public boolean testDouble(double value) {
            if (Double.isNaN(value)) {
                return false;
            }
            if (!this.lowerUnbounded) {
                if (value < this.lower) {
                    return false;
                }
                if (this.lowerExclusive && this.lower == value) {
                    return false;
                }
            }
            if (!this.upperUnbounded) {
                if (value > this.upper) {
                    return false;
                }
                if (this.upperExclusive && value == this.upper) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.lower, this.lowerUnbounded, this.lowerExclusive, this.upper, this.upperUnbounded, this.upperExclusive, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DoubleRange other = (DoubleRange)obj;
            return this.lower == other.lower && this.lowerUnbounded == other.lowerUnbounded && this.lowerExclusive == other.lowerExclusive && this.upper == other.upper && this.upperUnbounded == other.upperUnbounded && this.upperExclusive == other.upperExclusive && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lower", this.lower).add("lowerUnbounded", this.lowerUnbounded).add("lowerExclusive", this.lowerExclusive).add("upper", this.upper).add("upperUnbounded", this.upperUnbounded).add("upperExclusive", this.upperExclusive).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class AbstractRange
    extends AbstractTupleDomainFilter {
        protected final boolean lowerUnbounded;
        protected final boolean lowerExclusive;
        protected final boolean upperUnbounded;
        protected final boolean upperExclusive;

        private AbstractRange(boolean lowerUnbounded, boolean lowerExclusive, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed) {
            super(nullAllowed);
            this.lowerUnbounded = lowerUnbounded;
            this.lowerExclusive = lowerExclusive;
            this.upperUnbounded = upperUnbounded;
            this.upperExclusive = upperExclusive;
        }
    }

    public static class BigintRange
    extends AbstractTupleDomainFilter {
        private final long lower;
        private final long upper;

        private BigintRange(long lower, long upper, boolean nullAllowed) {
            super(nullAllowed);
            Preconditions.checkArgument((lower <= upper ? 1 : 0) != 0, (Object)"lower must be less than or equal to upper");
            this.lower = lower;
            this.upper = upper;
        }

        public static BigintRange of(long lower, long upper, boolean nullAllowed) {
            return new BigintRange(lower, upper, nullAllowed);
        }

        @Override
        public boolean testLong(long value) {
            return value >= this.lower && value <= this.upper;
        }

        public long getLower() {
            return this.lower;
        }

        public long getUpper() {
            return this.upper;
        }

        @Override
        public boolean isSingleValue() {
            return this.upper == this.lower;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigintRange that = (BigintRange)o;
            return this.lower == that.lower && this.upper == that.upper && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.lower, this.upper, this.nullAllowed);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lower", this.lower).add("upper", this.upper).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class BooleanValue
    extends AbstractTupleDomainFilter {
        private final boolean value;

        private BooleanValue(boolean value, boolean nullAllowed) {
            super(nullAllowed);
            this.value = value;
        }

        public static BooleanValue of(boolean value, boolean nullAllowed) {
            return new BooleanValue(value, nullAllowed);
        }

        @Override
        public boolean testBoolean(boolean value) {
            return this.value == value;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.nullAllowed);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BooleanValue other = (BooleanValue)obj;
            return this.value == other.value && this.nullAllowed == other.nullAllowed;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("nullAllowed", this.nullAllowed).toString();
        }
    }

    public static class IsNotNull
    extends AbstractTupleDomainFilter {
        public IsNotNull() {
            super(false);
        }

        @Override
        public boolean testLong(long value) {
            return true;
        }

        @Override
        public boolean testBoolean(boolean value) {
            return true;
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }

        @Override
        public boolean testDouble(double value) {
            return true;
        }

        @Override
        public boolean testLength(int length) {
            return true;
        }

        @Override
        public boolean testDecimal(long low, long high) {
            return true;
        }

        @Override
        public boolean testFloat(float value) {
            return true;
        }
    }

    public static class IsNull
    extends AbstractTupleDomainFilter {
        public IsNull() {
            super(true);
        }

        @Override
        public boolean testLong(long value) {
            return false;
        }

        @Override
        public boolean testBoolean(boolean value) {
            return false;
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }

        @Override
        public boolean testDouble(double value) {
            return false;
        }

        @Override
        public boolean testLength(int length) {
            return false;
        }

        @Override
        public boolean testDecimal(long low, long high) {
            return false;
        }

        @Override
        public boolean testFloat(float value) {
            return false;
        }
    }

    public static class AlwaysFalse
    extends AbstractTupleDomainFilter {
        public AlwaysFalse() {
            super(false);
        }

        @Override
        public boolean testLong(long value) {
            return false;
        }

        @Override
        public boolean testBoolean(boolean value) {
            return false;
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }

        @Override
        public boolean testDouble(double value) {
            return false;
        }

        @Override
        public boolean testLength(int length) {
            return false;
        }

        @Override
        public boolean testDecimal(long low, long high) {
            return false;
        }

        @Override
        public boolean testFloat(float value) {
            return false;
        }
    }

    public static abstract class AbstractTupleDomainFilter
    implements TupleDomainFilter {
        protected final boolean nullAllowed;

        private AbstractTupleDomainFilter(boolean nullAllowed) {
            this.nullAllowed = nullAllowed;
        }

        @Override
        public boolean testNull() {
            return this.nullAllowed;
        }

        @Override
        public boolean testLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testBoolean(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testBytes(byte[] buffer, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testLength(int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testDecimal(long low, long high) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean testFloat(float value) {
            throw new UnsupportedOperationException();
        }
    }
}

