/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.Varchars;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TupleDomainFilterUtils {
    static final TupleDomainFilter ALWAYS_FALSE = new TupleDomainFilter.AlwaysFalse();
    static final TupleDomainFilter IS_NULL = new TupleDomainFilter.IsNull();
    static final TupleDomainFilter IS_NOT_NULL = new TupleDomainFilter.IsNotNull();

    private TupleDomainFilterUtils() {
    }

    public static TupleDomainFilter toFilter(Domain domain) {
        ValueSet values = domain.getValues();
        Preconditions.checkArgument((boolean)(values instanceof SortedRangeSet), (Object)("Unexpected domain type: " + values.getClass().getSimpleName()));
        List ranges = ((SortedRangeSet)values).getOrderedRanges();
        boolean nullAllowed = domain.isNullAllowed();
        if (ranges.isEmpty() && nullAllowed) {
            return IS_NULL;
        }
        Type type = domain.getType();
        if (ranges.size() == 1 && type != BooleanType.BOOLEAN) {
            return TupleDomainFilterUtils.createRangeFilter(type, (Range)ranges.get(0), nullAllowed);
        }
        if (type == BooleanType.BOOLEAN) {
            return TupleDomainFilterUtils.createBooleanFilter(ranges, nullAllowed);
        }
        List rangeFilters = (List)ranges.stream().map(range -> TupleDomainFilterUtils.createRangeFilter(type, range, false)).filter((Predicate<TupleDomainFilter>)Predicates.not(ALWAYS_FALSE::equals)).collect(ImmutableList.toImmutableList());
        if (rangeFilters.isEmpty()) {
            return nullAllowed ? IS_NULL : ALWAYS_FALSE;
        }
        if (rangeFilters.get(0) instanceof TupleDomainFilter.BigintRange) {
            List bigintRanges = (List)rangeFilters.stream().map(TupleDomainFilter.BigintRange.class::cast).collect(ImmutableList.toImmutableList());
            if (bigintRanges.stream().allMatch(TupleDomainFilter.BigintRange::isSingleValue)) {
                return TupleDomainFilter.BigintValues.of(bigintRanges.stream().mapToLong(TupleDomainFilter.BigintRange::getLower).toArray(), nullAllowed);
            }
            return TupleDomainFilter.BigintMultiRange.of(bigintRanges, nullAllowed);
        }
        return TupleDomainFilterUtils.getMultiValuesTDF(rangeFilters, nullAllowed);
    }

    private static TupleDomainFilter getMultiValuesTDF(List<TupleDomainFilter> rangeFilters, boolean nullAllowed) {
        Set<Object> values = new HashSet();
        if (rangeFilters.stream().allMatch(TupleDomainFilter::isSingleValue)) {
            if (rangeFilters.get(0) instanceof TupleDomainFilter.BytesRange) {
                values = rangeFilters.stream().map(x -> new TupleDomainFilter.ExtendedByte(((TupleDomainFilter.BytesRange)x).getLower())).collect(Collectors.toSet());
            } else if (rangeFilters.get(0) instanceof TupleDomainFilter.FloatRange) {
                values = rangeFilters.stream().map(x -> Float.valueOf(((TupleDomainFilter.FloatRange)x).getLower())).collect(Collectors.toSet());
            } else if (rangeFilters.get(0) instanceof TupleDomainFilter.DoubleRange) {
                values = rangeFilters.stream().map(x -> ((TupleDomainFilter.DoubleRange)x).getLower()).collect(Collectors.toSet());
            } else if (rangeFilters.get(0) instanceof TupleDomainFilter.LongDecimalRange) {
                values = rangeFilters.stream().map(x -> new TupleDomainFilter.LongDecimalValue(((TupleDomainFilter.LongDecimalRange)x).getLowerLow(), ((TupleDomainFilter.LongDecimalRange)x).getLowerHigh())).collect(Collectors.toSet());
            }
            return TupleDomainFilter.MultiValues.of(values, nullAllowed);
        }
        return TupleDomainFilter.MultiRange.of(rangeFilters, nullAllowed);
    }

    private static TupleDomainFilter createBooleanFilter(List<Range> ranges, boolean nullAllowed) {
        boolean includesTrue = false;
        boolean includesFalse = false;
        for (Range range : ranges) {
            if (range.includes(Marker.exactly((Type)BooleanType.BOOLEAN, (Object)true))) {
                includesTrue = true;
            }
            if (!range.includes(Marker.exactly((Type)BooleanType.BOOLEAN, (Object)false))) continue;
            includesFalse = true;
        }
        if (includesTrue && includesFalse) {
            Preconditions.checkArgument((!nullAllowed ? 1 : 0) != 0, (Object)"Unexpected range of ALL values");
            return IS_NOT_NULL;
        }
        return TupleDomainFilter.BooleanValue.of(includesTrue, nullAllowed);
    }

    private static TupleDomainFilter createRangeFilter(Type type, Range range, boolean nullAllowed) {
        if (range.isAll()) {
            Preconditions.checkArgument((!nullAllowed ? 1 : 0) != 0, (Object)"Unexpected range of ALL values");
            return IS_NOT_NULL;
        }
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT || type == TimestampType.TIMESTAMP || type == DateType.DATE) {
            return TupleDomainFilterUtils.bigintRangeToFilter(range, nullAllowed);
        }
        if (type == BooleanType.BOOLEAN) {
            Preconditions.checkArgument((boolean)range.isSingleValue(), (Object)"Unexpected range of boolean values");
            return TupleDomainFilter.BooleanValue.of((Boolean)range.getSingleValue(), nullAllowed);
        }
        if (type instanceof DecimalType) {
            if (((DecimalType)type).isShort()) {
                return TupleDomainFilterUtils.bigintRangeToFilter(range, nullAllowed);
            }
            return TupleDomainFilterUtils.longDecimalRangeToFilter(range, nullAllowed);
        }
        if (Varchars.isVarcharType((Type)type) || type instanceof CharType || VarbinaryType.isVarbinaryType((Type)type)) {
            return TupleDomainFilterUtils.varcharRangeToFilter(range, nullAllowed);
        }
        if (type == DoubleType.DOUBLE) {
            return TupleDomainFilterUtils.doubleRangeToFilter(range, nullAllowed);
        }
        if (type == RealType.REAL) {
            return TupleDomainFilterUtils.floatRangeToFilter(range, nullAllowed);
        }
        throw new UnsupportedOperationException("Unsupported type: " + type.getDisplayName());
    }

    private static TupleDomainFilter doubleRangeToFilter(Range range, boolean nullAllowed) {
        double upperDouble;
        Marker low = range.getLow();
        Marker high = range.getHigh();
        double lowerDouble = low.isLowerUnbounded() ? Double.MIN_VALUE : (Double)low.getValue();
        double d = upperDouble = high.isUpperUnbounded() ? Double.MAX_VALUE : (Double)high.getValue();
        if (!low.isLowerUnbounded() && Double.isNaN(lowerDouble)) {
            return ALWAYS_FALSE;
        }
        if (!high.isUpperUnbounded() && Double.isNaN(upperDouble)) {
            return ALWAYS_FALSE;
        }
        return TupleDomainFilter.DoubleRange.of(lowerDouble, low.isLowerUnbounded(), low.getBound() == Marker.Bound.ABOVE, upperDouble, high.isUpperUnbounded(), high.getBound() == Marker.Bound.BELOW, nullAllowed);
    }

    private static TupleDomainFilter bigintRangeToFilter(Range range, boolean nullAllowed) {
        long upperLong;
        Marker low = range.getLow();
        Marker high = range.getHigh();
        long lowerLong = low.isLowerUnbounded() ? Long.MIN_VALUE : (Long)low.getValue();
        long l = upperLong = high.isUpperUnbounded() ? Long.MAX_VALUE : (Long)high.getValue();
        if (!high.isUpperUnbounded() && high.getBound() == Marker.Bound.BELOW) {
            --upperLong;
        }
        if (!low.isLowerUnbounded() && low.getBound() == Marker.Bound.ABOVE) {
            ++lowerLong;
        }
        if (upperLong < lowerLong) {
            return ALWAYS_FALSE;
        }
        return TupleDomainFilter.BigintRange.of(lowerLong, upperLong, nullAllowed);
    }

    private static TupleDomainFilter varcharRangeToFilter(Range range, boolean nullAllowed) {
        Marker low = range.getLow();
        Marker high = range.getHigh();
        Slice lowerValue = low.isLowerUnbounded() ? null : (Slice)low.getValue();
        Slice upperValue = high.isUpperUnbounded() ? null : (Slice)high.getValue();
        return TupleDomainFilter.BytesRange.of(lowerValue == null ? null : lowerValue.getBytes(), low.getBound() == Marker.Bound.ABOVE, upperValue == null ? null : upperValue.getBytes(), high.getBound() == Marker.Bound.BELOW, nullAllowed);
    }

    private static TupleDomainFilter longDecimalRangeToFilter(Range range, boolean nullAllowed) {
        Marker low = range.getLow();
        Marker high = range.getHigh();
        return TupleDomainFilter.LongDecimalRange.of(low.isLowerUnbounded() ? Long.MIN_VALUE : ((Slice)low.getValue()).getLong(0), low.isLowerUnbounded() ? Long.MIN_VALUE : ((Slice)low.getValue()).getLong(8), low.isLowerUnbounded(), low.getBound() == Marker.Bound.ABOVE, high.isUpperUnbounded() ? Long.MAX_VALUE : ((Slice)high.getValue()).getLong(0), high.isUpperUnbounded() ? Long.MAX_VALUE : ((Slice)high.getValue()).getLong(8), high.isUpperUnbounded(), high.getBound() == Marker.Bound.BELOW, nullAllowed);
    }

    private static TupleDomainFilter floatRangeToFilter(Range range, boolean nullAllowed) {
        float upperFloat;
        Marker low = range.getLow();
        Marker high = range.getHigh();
        float lowerFloat = low.isLowerUnbounded() ? Float.MIN_VALUE : Float.intBitsToFloat(Math.toIntExact((Long)low.getValue()));
        float f = upperFloat = high.isUpperUnbounded() ? Float.MAX_VALUE : Float.intBitsToFloat(Math.toIntExact((Long)high.getValue()));
        if (!low.isLowerUnbounded() && Float.isNaN(lowerFloat)) {
            return ALWAYS_FALSE;
        }
        if (!high.isUpperUnbounded() && Float.isNaN(upperFloat)) {
            return ALWAYS_FALSE;
        }
        return TupleDomainFilter.FloatRange.of(lowerFloat, low.isLowerUnbounded(), low.getBound() == Marker.Bound.ABOVE, upperFloat, high.isUpperUnbounded(), high.getBound() == Marker.Bound.BELOW, nullAllowed);
    }
}

