/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.statistics.BooleanStatistics;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.HashableBloomFilter;
import io.prestosql.orc.metadata.statistics.RangeStatistics;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class TupleDomainOrcPredicate
implements OrcPredicate {
    private final List<ColumnDomain> columnDomains;
    private final List<ColumnDomain> orColumnDomains;
    private final boolean orcBloomFiltersEnabled;
    private final Set<Integer> missingColumns;
    private final int domainCompactionThreshold;

    public static TupleDomainOrcPredicateBuilder builder() {
        return new TupleDomainOrcPredicateBuilder();
    }

    private TupleDomainOrcPredicate(List<ColumnDomain> columnDomains, List<ColumnDomain> orColumns, boolean orcBloomFiltersEnabled, Set<Integer> missingColumns, int domainCompactionThreshold) {
        this.columnDomains = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnDomains, "columnDomains is null"));
        this.orColumnDomains = ImmutableList.copyOf(orColumns);
        this.orcBloomFiltersEnabled = orcBloomFiltersEnabled;
        this.missingColumns = missingColumns;
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    @Override
    public boolean matches(long numberOfRows, ColumnMetadata<ColumnStatistics> allColumnStatistics) {
        ColumnStatistics columnStatistics;
        boolean found = this.orColumnDomains.size() == 0;
        for (ColumnDomain column : this.columnDomains) {
            columnStatistics = allColumnStatistics.get(column.getColumnId());
            if (columnStatistics == null || this.columnOverlaps(column.getDomain(), numberOfRows, columnStatistics)) continue;
            return false;
        }
        for (ColumnDomain column : this.orColumnDomains) {
            columnStatistics = allColumnStatistics.get(column.getColumnId());
            if (columnStatistics == null) {
                return true;
            }
            if (!this.columnOverlaps(column.getDomain(), numberOfRows, columnStatistics)) continue;
            return true;
        }
        return found || this.missingColumns.size() > 0;
    }

    private boolean columnOverlaps(Domain predicateDomain, long numberOfRows, ColumnStatistics columnStatistics) {
        Domain stripeDomain = TupleDomainOrcPredicate.getDomain(predicateDomain.getType(), numberOfRows, columnStatistics);
        if (!stripeDomain.overlaps(predicateDomain)) {
            return false;
        }
        if (!this.orcBloomFiltersEnabled) {
            return true;
        }
        if (predicateDomain.isNullAllowed() && stripeDomain.isNullAllowed()) {
            return true;
        }
        Optional<Collection<Object>> discreteValues = this.extractDiscreteValues(predicateDomain.getValues());
        if (!discreteValues.isPresent()) {
            return true;
        }
        HashableBloomFilter bloomFilter = columnStatistics.getBloomFilter();
        if (bloomFilter == null) {
            return true;
        }
        return !discreteValues.get().stream().noneMatch(value -> TupleDomainOrcPredicate.checkInBloomFilter(bloomFilter, value, stripeDomain.getType()));
    }

    private Optional<Collection<Object>> extractDiscreteValues(ValueSet valueSet) {
        if (!valueSet.isDiscreteSet()) {
            return valueSet.tryExpandRanges(this.domainCompactionThreshold);
        }
        return Optional.of(valueSet.getDiscreteSet());
    }

    @VisibleForTesting
    public static boolean checkInBloomFilter(HashableBloomFilter bloomFilter, Object predicateValue, Type sqlType) {
        if (sqlType == TinyintType.TINYINT || sqlType == SmallintType.SMALLINT || sqlType == IntegerType.INTEGER || sqlType == BigintType.BIGINT || sqlType == DateType.DATE || sqlType == TimestampType.TIMESTAMP) {
            return bloomFilter.test(((Number)predicateValue).longValue());
        }
        if (sqlType == DoubleType.DOUBLE) {
            return bloomFilter.test((Double)predicateValue);
        }
        if (sqlType == RealType.REAL) {
            return bloomFilter.test(Float.intBitsToFloat(((Number)predicateValue).intValue()));
        }
        if (sqlType instanceof VarcharType || sqlType instanceof VarbinaryType) {
            return bloomFilter.test((Slice)predicateValue);
        }
        return true;
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, ColumnStatistics columnStatistics) {
        boolean hasNullValue;
        if (rowCount == 0L) {
            return Domain.none((Type)type);
        }
        if (columnStatistics == null) {
            return Domain.all((Type)type);
        }
        if (columnStatistics.hasNumberOfValues() && columnStatistics.getNumberOfValues() == 0L) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = columnStatistics.getNumberOfValues() != rowCount;
        if (type.getJavaType() == Boolean.TYPE && columnStatistics.getBooleanStatistics() != null) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = columnStatistics.getBooleanStatistics();
            boolean hasTrueValues = booleanStatistics.getTrueValueCount() != 0L;
            boolean bl2 = hasFalseValues = columnStatistics.getNumberOfValues() != booleanStatistics.getTrueValueCount();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)BooleanType.BOOLEAN);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)BooleanType.BOOLEAN, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)BooleanType.BOOLEAN, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
        } else {
            if (Decimals.isShortDecimal((Type)type) && columnStatistics.getDecimalStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDecimalStatistics(), value -> Decimals.rescale((BigDecimal)value, (DecimalType)((DecimalType)type)).unscaledValue().longValue());
            }
            if (Decimals.isLongDecimal((Type)type) && columnStatistics.getDecimalStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDecimalStatistics(), value -> Decimals.encodeUnscaledValue((BigInteger)Decimals.rescale((BigDecimal)value, (DecimalType)((DecimalType)type)).unscaledValue()));
            }
            if (Chars.isCharType((Type)type) && columnStatistics.getStringStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getStringStatistics(), value -> Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type));
            }
            if (Varchars.isVarcharType((Type)type) && columnStatistics.getStringStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getStringStatistics());
            }
            if (type.getTypeSignature().getBase().equals("date") && columnStatistics.getDateStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDateStatistics(), value -> (long)value);
            }
            if (type.getJavaType() == Long.TYPE && columnStatistics.getIntegerStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getIntegerStatistics());
            }
            if (type.getJavaType() == Double.TYPE && columnStatistics.getDoubleStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDoubleStatistics());
            }
            if (RealType.REAL.equals((Object)type) && columnStatistics.getDoubleStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDoubleStatistics(), value -> Float.floatToRawIntBits(value.floatValue()));
            }
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    private static <T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<T> rangeStatistics) {
        return TupleDomainOrcPredicate.createDomain(type, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<F> rangeStatistics, Function<F, T> function) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, function.apply(min), (boolean)true, function.apply(max), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, function.apply(max)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, function.apply(min)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleDomainOrcPredicate that = (TupleDomainOrcPredicate)o;
        return Objects.equals(this.columnDomains, that.columnDomains) && Objects.equals(this.orColumnDomains, that.orColumnDomains) && this.orcBloomFiltersEnabled == that.orcBloomFiltersEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.columnDomains, this.orColumnDomains, this.orcBloomFiltersEnabled);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnDomains", this.columnDomains).add("orColumnDomains", this.orColumnDomains).add("orcBloomFilterEnabled", this.orcBloomFiltersEnabled).toString();
    }

    private static class ColumnDomain {
        private final OrcColumnId columnId;
        private final Domain domain;

        public ColumnDomain(OrcColumnId columnId, Domain domain) {
            this.columnId = Objects.requireNonNull(columnId, "columnId is null");
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        public OrcColumnId getColumnId() {
            return this.columnId;
        }

        public Domain getDomain() {
            return this.domain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnDomain that = (ColumnDomain)o;
            return this.columnId.equals(that.columnId) && this.domain.equals((Object)that.domain);
        }

        public int hashCode() {
            return Objects.hash(this.columnId, this.domain);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("columnId", (Object)this.columnId).add("domain", (Object)this.domain).toString();
        }
    }

    public static class TupleDomainOrcPredicateBuilder {
        private final List<ColumnDomain> columns = new ArrayList<ColumnDomain>();
        private final List<ColumnDomain> orColumns = new ArrayList<ColumnDomain>();
        private Set<Integer> missingColumns = new HashSet<Integer>();
        private boolean bloomFiltersEnabled;
        private int domainCompactionThreshold;

        public TupleDomainOrcPredicateBuilder addColumn(OrcColumnId columnId, Domain domain) {
            Objects.requireNonNull(domain, "domain is null");
            this.columns.add(new ColumnDomain(columnId, domain));
            return this;
        }

        public TupleDomainOrcPredicateBuilder setDomainCompactionThreshold(int domainCompactionThreshold) {
            this.domainCompactionThreshold = domainCompactionThreshold;
            return this;
        }

        public TupleDomainOrcPredicateBuilder addOrColumn(OrcColumnId columnId, Domain domain) {
            Objects.requireNonNull(domain, "domain is null");
            this.orColumns.add(new ColumnDomain(columnId, domain));
            return this;
        }

        public TupleDomainOrcPredicateBuilder setMissingColumns(Set<Integer> missingColumns) {
            this.missingColumns = missingColumns;
            return this;
        }

        public TupleDomainOrcPredicateBuilder setBloomFiltersEnabled(boolean bloomFiltersEnabled) {
            this.bloomFiltersEnabled = bloomFiltersEnabled;
            return this;
        }

        public TupleDomainOrcPredicate build() {
            return new TupleDomainOrcPredicate(this.columns, this.orColumns, this.bloomFiltersEnabled, this.missingColumns, this.domainCompactionThreshold);
        }
    }
}

