/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Footer;
import io.prestosql.orc.metadata.Metadata;
import io.prestosql.orc.metadata.MetadataReader;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.PostScript;
import io.prestosql.orc.metadata.RowGroupIndex;
import io.prestosql.orc.metadata.StripeFooter;
import io.prestosql.orc.metadata.statistics.HashableBloomFilter;
import io.prestosql.spi.PrestoException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;

public class ExceptionWrappingMetadataReader
implements MetadataReader {
    private final OrcDataSourceId orcDataSourceId;
    private final MetadataReader delegate;

    public ExceptionWrappingMetadataReader(OrcDataSourceId orcDataSourceId, MetadataReader delegate) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Preconditions.checkArgument((!(delegate instanceof ExceptionWrappingMetadataReader) ? 1 : 0) != 0, (Object)"ExceptionWrappingMetadataReader can not wrap a ExceptionWrappingMetadataReader");
    }

    @Override
    public PostScript readPostScript(InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readPostScript(inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid postscript");
        }
    }

    @Override
    public Metadata readMetadata(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readMetadata(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid file metadata");
        }
    }

    @Override
    public Footer readFooter(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readFooter(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid file footer");
        }
    }

    @Override
    public StripeFooter readStripeFooter(ColumnMetadata<OrcType> types, InputStream inputStream, ZoneId legacyFileTimeZone) throws IOException {
        try {
            return this.delegate.readStripeFooter(types, inputStream, legacyFileTimeZone);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid stripe footer");
        }
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readRowIndexes(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid stripe row index");
        }
    }

    @Override
    public List<HashableBloomFilter> readBloomFilterIndexes(InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readBloomFilterIndexes(inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid bloom filter");
        }
    }

    private OrcCorruptionException propagate(Throwable throwable, String message) {
        Throwables.propagateIfPossible((Throwable)throwable, PrestoException.class);
        return new OrcCorruptionException(throwable, this.orcDataSourceId, message, new Object[0]);
    }
}

