/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata.statistics;

import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.DateStatistics;
import io.prestosql.orc.metadata.statistics.LongValueStatisticsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DateStatisticsBuilder
implements LongValueStatisticsBuilder {
    private long nonNullValueCount;
    private int minimum = Integer.MAX_VALUE;
    private int maximum = Integer.MIN_VALUE;

    @Override
    public void addValue(long value) {
        ++this.nonNullValueCount;
        int intValue = Math.toIntExact(value);
        this.minimum = Math.min(intValue, this.minimum);
        this.maximum = Math.max(intValue, this.maximum);
    }

    private void addDateStatistics(long valueCount, DateStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        this.minimum = Math.min(value.getMin(), this.minimum);
        this.maximum = Math.max(value.getMax(), this.maximum);
    }

    private Optional<DateStatistics> buildDateStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new DateStatistics(this.minimum, this.maximum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<DateStatistics> dateStatistics = this.buildDateStatistics();
        return new ColumnStatistics(this.nonNullValueCount, dateStatistics.map(s -> 5L).orElse(0L), null, null, null, null, dateStatistics.orElse(null), null, null, null);
    }

    public static Optional<DateStatistics> mergeDateStatistics(List<ColumnStatistics> stats) {
        DateStatisticsBuilder dateStatisticsBuilder = new DateStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            DateStatistics partialStatistics = columnStatistics.getDateStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            dateStatisticsBuilder.addDateStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return dateStatisticsBuilder.buildDateStatistics();
    }
}

