/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.DecimalInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public abstract class AbstractDecimalSelectiveColumnReader<T>
implements SelectiveColumnReader<T> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(AbstractDecimalSelectiveColumnReader.class).instanceSize();
    protected final TupleDomainFilter filter;
    protected final boolean nullsAllowed;
    protected final boolean outputRequired;
    protected final int scale;
    protected long[] values;
    protected boolean[] nulls;
    protected int[] outputPositions;
    protected int outputPositionCount;
    protected BooleanInputStream presentStream;
    protected DecimalInputStream dataStream;
    protected LongInputStream scaleStream;
    private final int valuesPerPosition;
    private final Block nullBlock;
    private final OrcColumn streamDescriptor;
    private final LocalMemoryContext systemMemoryContext;
    private int readOffset;
    private boolean rowGroupOpen;
    private boolean allNulls;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private InputStreamSource<DecimalInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
    private InputStreamSource<LongInputStream> scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);

    public AbstractDecimalSelectiveColumnReader(OrcType orcType, OrcColumn streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext systemMemoryContext, int valuesPerPosition) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = filter.orElse(null);
        this.outputRequired = outputType.isPresent();
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.nullsAllowed = this.filter == null || this.filter.testNull();
        this.scale = orcType.getScale().get();
        this.nullBlock = outputType.map(type -> type.createBlockBuilder(null, 1).appendNull().build()).orElse(null);
        this.valuesPerPosition = valuesPerPosition;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
        this.scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, DecimalInputStream.class);
        this.scaleStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.values) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.scaleStream = this.scaleStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        return this.readOr(offset, positions, positionCount, (List<TupleDomainFilter>)(this.filter == null ? null : ImmutableList.of((Object)this.filter)), null);
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, this.nullsAllowed && this.presentStream != null);
        }
        if (filters != null) {
            if (this.outputPositions == null || this.outputPositions.length < positionCount) {
                this.outputPositions = new int[positionCount];
            }
        } else {
            this.outputPositions = positions;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        int streamPosition = 0;
        this.outputPositionCount = 0;
        if (this.dataStream == null && this.scaleStream == null && this.presentStream != null) {
            streamPosition = this.readAllNulls(positions, positionCount);
            if (filters != null && filters.get(0).testNull() && accumulator != null) {
                accumulator.set(positions[0], streamPosition);
            }
        } else {
            streamPosition = filters == null ? this.readNoFilter(positions, positionCount) : (accumulator == null ? this.readWithFilter(positions, positionCount, filters) : this.readWithOrFilter(positions, positionCount, filters, accumulator));
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nullsAllowed) {
            this.outputPositionCount = positionCount;
            if (this.outputPositions != positions) {
                System.arraycopy(positions, 0, this.outputPositions, 0, this.outputPositionCount);
            }
        } else {
            this.outputPositionCount = 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    protected void skip(int items) throws IOException {
        if (this.dataStream == null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            this.dataStream.skip(dataToSkip);
            this.scaleStream.skip(dataToSkip);
        } else {
            this.dataStream.skip(items);
            this.scaleStream.skip(items);
        }
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block<T> getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.nullBlock, this.outputPositionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount == this.outputPositionCount) {
            Block<T> block = this.makeBlock(positionCount, this.nullsAllowed, this.nulls, this.values);
            this.nulls = null;
            this.values = null;
            return block;
        }
        long[] valuesCopy = new long[this.valuesPerPosition * positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        this.copyValues(positions, positionCount, valuesCopy, nullsCopy);
        return this.makeBlock(positionCount, includeNulls, nullsCopy, valuesCopy);
    }

    private void ensureValuesCapacity(int capacity, boolean nullAllowed) {
        if (this.values == null || this.values.length < capacity) {
            this.values = new long[this.valuesPerPosition * capacity];
        }
        if (nullAllowed && (this.nulls == null || this.nulls.length < capacity)) {
            this.nulls = new boolean[capacity];
        }
    }

    abstract void copyValues(int[] var1, int var2, long[] var3, boolean[] var4);

    abstract Block<T> makeBlock(int var1, boolean var2, boolean[] var3, long[] var4);

    abstract void compactValues(int[] var1, int var2, boolean var3);

    abstract int readNoFilter(int[] var1, int var2) throws IOException;

    abstract int readWithFilter(int[] var1, int var2, List<TupleDomainFilter> var3) throws IOException;

    abstract int readWithOrFilter(int[] var1, int var2, List<TupleDomainFilter> var3, BitSet var4) throws IOException;

    @Override
    public void close() {
        this.values = null;
        this.nulls = null;
        this.outputPositions = null;
        this.presentStream = null;
        this.presentStreamSource = null;
        this.dataStream = null;
        this.dataStreamSource = null;
        this.scaleStream = null;
        this.scaleStreamSource = null;
        this.systemMemoryContext.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

