/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.IntArrayBlock;
import io.prestosql.spi.block.IntArrayBlockBuilder;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.block.ShortArrayBlock;
import io.prestosql.spi.block.ShortArrayBlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class AbstractLongSelectiveColumnReader<T>
implements SelectiveColumnReader<T> {
    protected final boolean outputRequired;
    @Nullable
    protected final Type outputType;
    @Nullable
    protected long[] values;
    @Nullable
    protected boolean[] nulls;
    @Nullable
    protected int[] outputPositions;
    protected int outputPositionCount;

    protected AbstractLongSelectiveColumnReader(Optional<Type> outputType) {
        this.outputRequired = outputType.isPresent();
        this.outputType = Objects.requireNonNull(outputType, "outputType is null").orElse(null);
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block<T> mergeBlocks(List<Block<T>> blocks, int positionCount) {
        if (this.outputType == BigintType.BIGINT) {
            LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, positionCount);
            blocks.stream().forEach(block -> {
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    if (block.isNull(i)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeLong(block.getLong(i, 0));
                }
            });
            return blockBuilder.build();
        }
        if (this.outputType == IntegerType.INTEGER) {
            IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, positionCount);
            blocks.stream().forEach(block -> {
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    if (block.isNull(i)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeInt(block.getInt(i, 0));
                }
            });
            return blockBuilder.build();
        }
        if (this.outputType == SmallintType.SMALLINT) {
            ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, positionCount);
            blocks.stream().forEach(block -> {
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    if (block.isNull(i)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeShort((int)block.getShort(i, 0));
                }
            });
            return blockBuilder.build();
        }
        throw new UnsupportedOperationException("Unsupported type: " + this.outputType);
    }

    protected Block buildOutputBlock(int[] positions, int positionCount, boolean includeNulls) {
        if (this.outputType == BigintType.BIGINT) {
            return this.getLongArrayBlock(positions, positionCount, includeNulls);
        }
        if (this.outputType == IntegerType.INTEGER || this.outputType == DateType.DATE) {
            return this.getIntArrayBlock(positions, positionCount, includeNulls);
        }
        if (this.outputType == SmallintType.SMALLINT) {
            return this.getShortArrayBlock(positions, positionCount, includeNulls);
        }
        throw new UnsupportedOperationException("Unsupported type: " + this.outputType);
    }

    private Block getLongArrayBlock(int[] positions, int positionCount, boolean includeNulls) {
        if (positionCount == this.outputPositionCount) {
            LongArrayBlock block;
            if (includeNulls) {
                block = new LongArrayBlock(positionCount, Optional.ofNullable(this.nulls), this.values);
                this.nulls = null;
            } else {
                block = new LongArrayBlock(positionCount, Optional.empty(), this.values);
            }
            this.values = null;
            return block;
        }
        long[] valuesCopy = new long[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            valuesCopy[positionIndex] = this.values[i];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new LongArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    private Block getIntArrayBlock(int[] positions, int positionCount, boolean includeNulls) {
        int[] valuesCopy = new int[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            valuesCopy[positionIndex] = Math.toIntExact(this.values[i]);
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new IntArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    private Block getShortArrayBlock(int[] positions, int positionCount, boolean includeNulls) {
        short[] valuesCopy = new short[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            valuesCopy[positionIndex] = (short)this.values[i];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new ShortArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    protected void ensureValuesCapacity(int capacity, boolean recordNulls) {
        if (this.values == null || this.values.length < capacity) {
            this.values = new long[capacity];
        }
        if (recordNulls && (this.nulls == null || this.nulls.length < capacity)) {
            this.nulls = new boolean[capacity];
        }
    }

    protected void ensureOutputPositionsCapacity(int capacity) {
        if (this.outputPositions == null || this.outputPositions.length < capacity) {
            this.outputPositions = new int[capacity];
        }
    }
}

