/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public abstract class AbstractNumericColumnReader<T>
implements ColumnReader<T> {
    protected static final int INSTANCE_SIZE = ClassLayout.parseClass(AbstractNumericColumnReader.class).instanceSize();
    protected final OrcColumn column;
    protected int readOffset;
    protected int nextBatchSize;
    protected InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    protected BooleanInputStream presentStream;
    protected boolean[] nullVector = new boolean[0];
    protected InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    protected LongInputStream dataStream;
    protected boolean rowGroupOpen;
    protected final LocalMemoryContext systemMemoryContext;

    public AbstractNumericColumnReader(Type type, OrcColumn column, LocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, t -> t instanceof BigintType || t instanceof IntegerType || t instanceof SmallintType || t instanceof DateType || t instanceof VarcharType);
        this.column = Objects.requireNonNull(column, "column is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    protected void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.nullVector = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.nullVector);
    }
}

