/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.ByteArrayBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.BooleanType;
import java.io.IOException;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class BooleanSelectiveColumnReader
implements SelectiveColumnReader<Byte> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanSelectiveColumnReader.class).instanceSize();
    private final OrcColumn columnDesc;
    @Nullable
    private final TupleDomainFilter filter;
    private final boolean nullsAllowed;
    private final boolean outputRequired;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<BooleanInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream dataStream;
    private boolean rowGroupOpen;
    private int readOffset;
    @Nullable
    private byte[] values;
    @Nullable
    private boolean[] nulls;
    @Nullable
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean allNulls;
    private LocalMemoryContext systemMemoryContext;

    public BooleanSelectiveColumnReader(OrcColumn columnDesc, Optional<TupleDomainFilter> filter, boolean outputRequired, LocalMemoryContext systemMemoryContext) {
        Objects.requireNonNull(filter, "filter is null");
        this.columnDesc = Objects.requireNonNull(columnDesc, "stream is null");
        this.filter = filter.orElse(null);
        this.outputRequired = outputRequired;
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.nullsAllowed = this.filter == null || this.filter.testNull();
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.columnDesc, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.columnDesc, Stream.StreamKind.DATA, BooleanInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.columnDesc).toString();
    }

    @Override
    public void close() {
        this.values = null;
        this.outputPositions = null;
        this.nulls = null;
        this.presentStream = null;
        this.presentStreamSource = null;
        this.dataStream = null;
        this.dataStreamSource = null;
        this.systemMemoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.values) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, this.nullsAllowed && this.presentStream != null);
        }
        if (this.filter != null) {
            this.ensureOutputPositionsCapacity(positionCount);
        } else {
            this.outputPositions = positions;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        int streamPosition = 0;
        if (this.dataStream == null && this.presentStream != null) {
            streamPosition = this.readAllNulls(positions, positionCount);
        } else if (this.filter == null) {
            streamPosition = this.readNoFilter(positions, positionCount);
        } else {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                int position = positions[i];
                if (position > streamPosition) {
                    this.skip(position - streamPosition);
                    streamPosition = position;
                }
                if (this.presentStream != null && !this.presentStream.nextBit()) {
                    if (this.nullsAllowed) {
                        if (this.outputRequired) {
                            this.nulls[this.outputPositionCount] = true;
                        }
                        this.outputPositions[this.outputPositionCount] = position;
                        ++this.outputPositionCount;
                    }
                } else {
                    boolean value = this.dataStream.nextBit();
                    if (this.filter == null || this.filter.testBoolean(value)) {
                        if (this.outputRequired) {
                            this.values[this.outputPositionCount] = (byte)(value ? 1 : 0);
                            if (this.nullsAllowed && this.presentStream != null) {
                                this.nulls[this.outputPositionCount] = false;
                            }
                        }
                        this.outputPositions[this.outputPositionCount] = position;
                        ++this.outputPositionCount;
                    }
                }
                ++streamPosition;
            }
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        boolean checkNulls;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, this.nullsAllowed && this.presentStream != null);
        }
        if (filters != null) {
            this.ensureOutputPositionsCapacity(positionCount);
        } else {
            this.outputPositions = positions;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        int streamPosition = 0;
        boolean bl = checkNulls = filters != null && filters.stream().anyMatch(f -> f.testNull());
        if (this.dataStream == null && this.presentStream != null) {
            streamPosition = this.readAllNulls(positions, positionCount);
            if (checkNulls && accumulator != null) {
                accumulator.set(positions[0], streamPosition);
            }
        } else if (filters == null) {
            streamPosition = this.readNoFilter(positions, positionCount);
        } else {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                int position = positions[i];
                if (position > streamPosition) {
                    this.skip(position - streamPosition);
                    streamPosition = position;
                }
                if (this.presentStream != null && !this.presentStream.nextBit()) {
                    if (this.nullsAllowed) {
                        if (this.outputRequired) {
                            this.nulls[this.outputPositionCount] = true;
                        }
                        if (accumulator != null && checkNulls) {
                            accumulator.set(position);
                        }
                        this.outputPositions[this.outputPositionCount] = position;
                        ++this.outputPositionCount;
                    }
                } else {
                    boolean value = this.dataStream.nextBit();
                    if ((accumulator != null && accumulator.get(position) || filters == null || filters.stream().anyMatch(f -> f.testBoolean(value))) && accumulator != null) {
                        accumulator.set(position);
                    }
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = (byte)(value ? 1 : 0);
                        if (this.nullsAllowed && this.presentStream != null) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
                ++streamPosition;
            }
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nullsAllowed) {
            this.outputPositionCount = positionCount;
            if (this.outputPositions != positions) {
                System.arraycopy(positions, 0, this.outputPositions, 0, this.outputPositionCount);
            }
            this.allNulls = true;
        } else {
            this.outputPositionCount = 0;
        }
        return positions[positionCount - 1] + 1;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
            } else {
                this.values[i] = (byte)(this.dataStream.nextBit() ? 1 : 0);
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private void skip(int items) throws IOException {
        if (this.dataStream == null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            this.dataStream.skip(dataToSkip);
        } else {
            this.dataStream.skip(items);
        }
    }

    private void ensureValuesCapacity(int capacity, boolean recordNulls) {
        if (this.values == null || this.values.length < capacity) {
            this.values = new byte[capacity];
        }
        if (recordNulls && (this.nulls == null || this.nulls.length < capacity)) {
            this.nulls = new boolean[capacity];
        }
    }

    private void ensureOutputPositionsCapacity(int capacity) {
        if (this.outputPositions == null || this.outputPositions.length < capacity) {
            this.outputPositions = new int[capacity];
        }
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(BooleanType.BOOLEAN.createBlockBuilder(null, 1).appendNull().build(), this.outputPositionCount);
        }
        if (positionCount == this.outputPositionCount) {
            ByteArrayBlock block = new ByteArrayBlock(positionCount, Optional.ofNullable(this.nulls), this.values);
            this.nulls = null;
            this.values = null;
            return block;
        }
        byte[] valuesCopy = new byte[positionCount];
        boolean[] nullsCopy = null;
        if (this.nullsAllowed && this.presentStream != null) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            valuesCopy[positionIndex] = this.values[i];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new ByteArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    @Override
    public Block<Byte> mergeBlocks(List<Block<Byte>> blocks, int positionCount) {
        byte[] valuesCopy = new byte[positionCount];
        boolean[] nullsCopy = new boolean[positionCount];
        AtomicInteger index = new AtomicInteger(0);
        blocks.stream().forEach(block -> {
            for (int i = 0; i < block.getPositionCount(); ++i) {
                nullsCopy[index.get()] = block.isNull(i);
                valuesCopy[index.getAndIncrement()] = block.getByte(i, 0);
            }
        });
        return new ByteArrayBlock(positionCount, Optional.empty(), valuesCopy);
    }
}

