/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDataSourceIdWithTimeStamp;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcRowDataCacheKey;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.StreamSourceMeta;
import io.prestosql.spi.block.Block;
import java.io.IOException;
import java.time.ZoneId;
import java.util.concurrent.ExecutionException;

public class CachingColumnReader<T>
implements ColumnReader<T> {
    private static final Logger log = Logger.get(CachingColumnReader.class);
    private final Cache<OrcRowDataCacheKey, Block> cache;
    private final ColumnReader delegate;
    private final OrcColumn column;
    private final OrcColumnId columnId;
    private OrcDataSourceId orcDataSourceId;
    private long lastModifiedTime;
    private long stripeOffset;
    private long rowGroupOffset;
    private int offset;
    private int nextBatchSize;
    private Block cachedBlock;

    public CachingColumnReader(ColumnReader delegate, OrcColumn column, Cache<OrcRowDataCacheKey, Block> cache) {
        this.delegate = delegate;
        this.column = column;
        this.columnId = column.getColumnId();
        this.cache = cache;
    }

    @Override
    public Block readBlock() throws IOException {
        log.debug("Reading from cached block. DatasourceId = %s, columnId = %s, stripeOffset = %d, rowGroupOffset = %d, Block offset = %d, Block size = %d, Column = %s", new Object[]{this.orcDataSourceId, this.columnId, this.stripeOffset, this.rowGroupOffset, this.offset, this.nextBatchSize, this.column});
        return this.cachedBlock.getRegion(this.offset, this.nextBatchSize);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.offset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
        this.delegate.prepareNextRead(batchSize);
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        this.offset = 0;
        this.nextBatchSize = 0;
        this.delegate.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.offset = 0;
        this.nextBatchSize = 0;
        StreamSourceMeta streamSourceMeta = dataStreamSources.getStreamSourceMeta();
        this.orcDataSourceId = streamSourceMeta.getDataSourceId();
        this.lastModifiedTime = streamSourceMeta.getLastModifiedTime();
        this.stripeOffset = streamSourceMeta.getStripeOffset();
        this.rowGroupOffset = streamSourceMeta.getRowGroupOffset();
        this.cachedBlock = this.getCachedBlock(streamSourceMeta.getRowCount(), dataStreamSources);
        this.delegate.startRowGroup(dataStreamSources);
    }

    private Block getCachedBlock(long rowCount, InputStreamSources dataStreamSources) throws IOException {
        OrcRowDataCacheKey cacheKey = new OrcRowDataCacheKey();
        cacheKey.setOrcDataSourceId(new OrcDataSourceIdWithTimeStamp(this.orcDataSourceId, this.lastModifiedTime));
        cacheKey.setStripeOffset(this.stripeOffset);
        cacheKey.setRowGroupOffset(this.rowGroupOffset);
        cacheKey.setColumnId(this.columnId);
        try {
            return (Block)this.cache.get((Object)cacheKey, () -> {
                this.delegate.startRowGroup(dataStreamSources);
                this.delegate.prepareNextRead((int)rowCount);
                log.debug("Caching row group data. DatasourceId = %s, columnId = %s, stripeOffset = %d, rowGroupOffset = %d, Column = %s", new Object[]{this.orcDataSourceId, this.columnId, this.stripeOffset, this.rowGroupOffset, this.column});
                return this.delegate.readBlock();
            });
        }
        catch (UncheckedExecutionException | ExecutionException executionException) {
            OrcReader.handleCacheLoadException((Exception)executionException);
            log.debug(executionException.getCause(), "Error while caching row group data. Falling back to default flow...");
            this.delegate.startRowGroup(dataStreamSources);
            this.delegate.prepareNextRead((int)rowCount);
            this.cachedBlock = this.delegate.readBlock();
            return this.cachedBlock;
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.delegate.getRetainedSizeInBytes();
    }
}

