/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.cache.Cache;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcBlockFactory;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcRowDataCacheKey;
import io.prestosql.orc.reader.BooleanColumnReader;
import io.prestosql.orc.reader.ByteColumnReader;
import io.prestosql.orc.reader.CachingColumnReader;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.DateColumnReader;
import io.prestosql.orc.reader.DecimalColumnReader;
import io.prestosql.orc.reader.DoubleColumnReader;
import io.prestosql.orc.reader.FloatColumnReader;
import io.prestosql.orc.reader.IntegerColumnReader;
import io.prestosql.orc.reader.ListColumnReader;
import io.prestosql.orc.reader.LongColumnReader;
import io.prestosql.orc.reader.MapColumnReader;
import io.prestosql.orc.reader.ShortColumnReader;
import io.prestosql.orc.reader.SliceColumnReader;
import io.prestosql.orc.reader.StructColumnReader;
import io.prestosql.orc.reader.TimestampColumnReader;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;

public final class ColumnReaders {
    private ColumnReaders() {
    }

    public static ColumnReader createColumnReader(Type type, OrcColumn column, AggregatedMemoryContext systemMemoryContext, OrcBlockFactory.NestedBlockFactory blockFactory) throws OrcCorruptionException, PrestoException {
        switch (column.getColumnType()) {
            case BOOLEAN: {
                return new BooleanColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case BYTE: {
                return new ByteColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case SHORT: {
                return new ShortColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case INT: {
                return new IntegerColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case LONG: {
                return new LongColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case DATE: {
                return new DateColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case FLOAT: {
                return new FloatColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                return new DoubleColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceColumnReader(type, column, systemMemoryContext);
            }
            case TIMESTAMP: {
                return new TimestampColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case LIST: {
                return new ListColumnReader(type, column, systemMemoryContext, blockFactory);
            }
            case STRUCT: {
                return new StructColumnReader(type, column, systemMemoryContext, blockFactory);
            }
            case MAP: {
                return new MapColumnReader(type, column, systemMemoryContext, blockFactory);
            }
            case DECIMAL: {
                return new DecimalColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)column.getColumnType()));
    }

    public static ColumnReader wrapWithCachingStreamReader(ColumnReader original, OrcColumn column, Cache<OrcRowDataCacheKey, Block> cache) {
        return new CachingColumnReader(original, column, cache);
    }
}

