/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDataSourceIdWithTimeStamp;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcRowDataCacheKey;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.StreamSourceMeta;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class DataCachingSelectiveColumnReader<T>
implements SelectiveColumnReader<T> {
    private static final Logger log = Logger.get(DataCachingSelectiveColumnReader.class);
    private final Cache<OrcRowDataCacheKey, Block> cache;
    private final ColumnReader delegate;
    private final OrcColumn column;
    private final OrcColumnId columnId;
    private OrcDataSourceId orcDataSourceId;
    private long lastModifiedTime;
    private long stripeOffset;
    private long rowGroupOffset;
    private int[] positions;
    private int positionCount;
    private Block cachedBlock;
    private Block resultBlock;
    private boolean isDictionary;

    public DataCachingSelectiveColumnReader(ColumnReader delegate, OrcColumn column, Cache<OrcRowDataCacheKey, Block> cache) {
        this.delegate = delegate;
        this.column = column;
        this.columnId = column.getColumnId();
        this.cache = cache;
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        int maxPosition = Integer.min(this.cachedBlock.getPositionCount(), positions[positionCount - 1]) + 1;
        Block block = this.cachedBlock.getRegion(offset, maxPosition);
        this.isDictionary = false;
        this.resultBlock = block;
        if (filter != null) {
            this.positions = new int[positionCount];
            this.positionCount = block.filter(positions, positionCount, this.positions, value -> this.delegate.filterTest(filter, value));
            if (this.positionCount != positionCount) {
                this.positions = Arrays.copyOf(this.positions, this.positionCount);
                this.isDictionary = true;
            }
        } else {
            this.positions = (int[])positions.clone();
            this.positionCount = positionCount;
        }
        return this.positionCount;
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filter, BitSet accumulator) {
        int maxPosition = Integer.min(this.cachedBlock.getPositionCount(), positions[positionCount - 1]) + 1;
        Block block = this.cachedBlock.getRegion(offset, maxPosition);
        this.positionCount = positionCount;
        this.positions = (int[])positions.clone();
        this.isDictionary = false;
        for (int i = 0; i < positionCount; ++i) {
            if (!accumulator.get(positions[i]) && !this.delegate.filterTest(filter.get(0), block.get(positions[i]))) continue;
            accumulator.set(positions[i]);
        }
        this.resultBlock = block;
        return this.positionCount;
    }

    @Override
    public int[] getReadPositions() {
        return this.positions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        if (this.resultBlock.getPositionCount() != positionCount || this.isDictionary) {
            return new DictionaryBlock(this.resultBlock, positions);
        }
        return this.resultBlock;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        this.delegate.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        StreamSourceMeta streamSourceMeta = dataStreamSources.getStreamSourceMeta();
        this.orcDataSourceId = streamSourceMeta.getDataSourceId();
        this.lastModifiedTime = streamSourceMeta.getLastModifiedTime();
        this.stripeOffset = streamSourceMeta.getStripeOffset();
        this.rowGroupOffset = streamSourceMeta.getRowGroupOffset();
        this.cachedBlock = this.getCachedBlock(streamSourceMeta.getRowCount(), dataStreamSources);
        this.delegate.startRowGroup(dataStreamSources);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.delegate.getRetainedSizeInBytes();
    }

    private Block getCachedBlock(long rowCount, InputStreamSources dataStreamSources) throws IOException {
        OrcRowDataCacheKey cacheKey = new OrcRowDataCacheKey();
        cacheKey.setOrcDataSourceId(new OrcDataSourceIdWithTimeStamp(this.orcDataSourceId, this.lastModifiedTime));
        cacheKey.setStripeOffset(this.stripeOffset);
        cacheKey.setRowGroupOffset(this.rowGroupOffset);
        cacheKey.setColumnId(this.columnId);
        try {
            return (Block)this.cache.get((Object)cacheKey, () -> {
                this.delegate.startRowGroup(dataStreamSources);
                this.delegate.prepareNextRead((int)rowCount);
                log.debug("Caching row group data. DatasourceId = %s, columnId = %s, stripeOffset = %d, rowGroupOffset = %d, Column = %s", new Object[]{this.orcDataSourceId, this.columnId, this.stripeOffset, this.rowGroupOffset, this.column});
                return this.delegate.readBlock();
            });
        }
        catch (UncheckedExecutionException | ExecutionException executionException) {
            OrcReader.handleCacheLoadException((Exception)executionException);
            log.debug(executionException.getCause(), "Error while caching row group data. Falling back to default flow...");
            this.delegate.startRowGroup(dataStreamSources);
            this.delegate.prepareNextRead((int)rowCount);
            this.cachedBlock = this.delegate.readBlock();
            return this.cachedBlock;
        }
    }
}

