/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.reader.IntegerColumnReader;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import org.openjdk.jol.info.ClassLayout;

public class DateColumnReader
extends IntegerColumnReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DateColumnReader.class).instanceSize();

    public DateColumnReader(Type type, OrcColumn column, LocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        super(type, column, systemMemoryContext);
    }

    @Override
    public Block<Integer> readBlock() throws IOException {
        Object block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)DateType.DATE, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)DateType.DATE, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    @Override
    public boolean filterTest(TupleDomainFilter filter, Integer value) {
        if (value == null) {
            return filter.testNull();
        }
        return filter.testLong(value.intValue());
    }
}

