/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.reader.AbstractNumericColumnReader;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.IntArrayBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class IntegerColumnReader
extends AbstractNumericColumnReader<Integer> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntegerColumnReader.class).instanceSize();
    private int[] intNonNullValueTemp = new int[0];

    public IntegerColumnReader(Type type, OrcColumn column, LocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        super(type, column, systemMemoryContext);
    }

    @Override
    public Block readBlock() throws IOException {
        Object block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)IntegerType.INTEGER, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)IntegerType.INTEGER, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    protected Block readNonNullBlock() throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        int[] values = new int[this.nextBatchSize];
        this.dataStream.next(values, this.nextBatchSize);
        return new IntArrayBlock(this.nextBatchSize, Optional.empty(), values);
    }

    protected Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        return this.intReadNullBlock(isNull, nonNullCount);
    }

    private Block intReadNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.intNonNullValueTemp.length < minNonNullValueSize) {
            this.intNonNullValueTemp = new int[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((int[])this.intNonNullValueTemp));
        }
        this.dataStream.next(this.intNonNullValueTemp, nonNullCount);
        int[] result = ReaderUtils.unpackIntNulls(this.intNonNullValueTemp, isNull);
        return new IntArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    @Override
    public boolean filterTest(TupleDomainFilter filter, Integer value) {
        if (value == null) {
            return filter.testNull();
        }
        return filter.testLong(value.intValue());
    }
}

