/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.UnsafeSlice;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.reader.AbstractDecimalSelectiveColumnReader;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.Int128ArrayBlock;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.UnscaledDecimal128Arithmetic;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;

public class LongDecimalSelectiveColumnReader
extends AbstractDecimalSelectiveColumnReader<long[]> {
    public LongDecimalSelectiveColumnReader(OrcType orcType, OrcColumn streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext systemMemoryContext) {
        super(orcType, streamDescriptor, filter, outputType, systemMemoryContext, 2);
    }

    @Override
    protected int readNoFilter(int[] positions, int positionCount) throws IOException {
        long[] data = new long[2];
        Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
            } else {
                this.dataStream.nextLongDecimal(data, 1);
                Slice decimal = Slices.wrappedLongArray((long[])new long[]{data[0], data[1]});
                UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)(this.scale - (int)this.scaleStream.next()), (Slice)rescaledDecimal);
                this.values[2 * i] = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)0);
                this.values[2 * i + 1] = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)8);
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    @Override
    protected int readWithFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters) throws IOException {
        int streamPosition = 0;
        this.outputPositionCount = 0;
        long[] data = new long[2];
        Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int scale = (int)this.scaleStream.next();
                this.dataStream.nextLongDecimal(data, 1);
                Slice decimal = Slices.wrappedLongArray((long[])new long[]{data[0], data[1]});
                UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)(this.scale - scale), (Slice)rescaledDecimal);
                long low = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)0);
                long high = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)8);
                if (filters.get(0).testDecimal(low, high)) {
                    if (this.outputRequired) {
                        this.values[2 * this.outputPositionCount] = low;
                        this.values[2 * this.outputPositionCount + 1] = high;
                        if (this.nullsAllowed && this.presentStream != null) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            }
            ++streamPosition;
        }
        return streamPosition;
    }

    @Override
    protected int readWithOrFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        int streamPosition = 0;
        this.outputPositionCount = 0;
        long[] data = new long[2];
        Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        boolean checkNulls = filters != null && filters.stream().anyMatch(f -> f.testNull());
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    if (accumulator != null && checkNulls) {
                        accumulator.set(position);
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int scale = (int)this.scaleStream.next();
                this.dataStream.nextLongDecimal(data, 1);
                Slice decimal = Slices.wrappedLongArray((long[])new long[]{data[0], data[1]});
                UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)(this.scale - scale), (Slice)rescaledDecimal);
                long low = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)0);
                long high = UnsafeSlice.getLongUnchecked((Slice)rescaledDecimal, (int)8);
                if ((accumulator != null && accumulator.get(position) || filters == null || filters.stream().anyMatch(f -> f.testDecimal(low, high))) && accumulator != null) {
                    accumulator.set(position);
                }
                if (this.outputRequired) {
                    this.values[2 * this.outputPositionCount] = low;
                    this.values[2 * this.outputPositionCount + 1] = high;
                    if (this.nullsAllowed && this.presentStream != null) {
                        this.nulls[this.outputPositionCount] = false;
                    }
                }
                this.outputPositions[this.outputPositionCount] = position;
                ++this.outputPositionCount;
            }
            ++streamPosition;
        }
        return streamPosition;
    }

    @Override
    protected void copyValues(int[] positions, int positionsCount, long[] valuesCopy, boolean[] nullsCopy) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            valuesCopy[2 * positionIndex] = this.values[2 * i];
            valuesCopy[2 * positionIndex + 1] = this.values[2 * i + 1];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionsCount) break;
            nextPosition = positions[positionIndex];
        }
    }

    @Override
    protected void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            this.values[2 * positionIndex] = this.values[2 * i];
            this.values[2 * positionIndex + 1] = this.values[2 * i + 1];
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    protected Block<long[]> makeBlock(int positionCount, boolean includeNulls, boolean[] nulls, long[] values) {
        return new Int128ArrayBlock(positionCount, Optional.ofNullable((boolean[])(includeNulls ? nulls : null)), values);
    }
}

