/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.AbstractLongSelectiveColumnReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class LongSelectiveColumnReader
extends AbstractLongSelectiveColumnReader<Long> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongSelectiveColumnReader.class).instanceSize();
    private final OrcColumn streamDescriptor;
    @Nullable
    private final TupleDomainFilter filter;
    private final boolean nullsAllowed;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private int readOffset;
    private boolean allNulls;
    private LocalMemoryContext systemMemoryContext;

    public LongSelectiveColumnReader(OrcColumn streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext systemMemoryContext) {
        super(outputType);
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = Objects.requireNonNull(filter, "filter is null").orElse(null);
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.nullsAllowed = this.filter == null || this.filter.testNull();
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, this.nullsAllowed && this.presentStream != null);
        }
        if (this.filter != null) {
            this.ensureOutputPositionsCapacity(positionCount);
        } else {
            this.outputPositions = positions;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        this.outputPositionCount = 0;
        int streamPosition = 0;
        if (this.dataStream == null && this.presentStream != null) {
            streamPosition = this.readAllNulls(positions, positionCount);
        } else {
            for (int i = 0; i < positionCount; ++i) {
                int position = positions[i];
                if (position > streamPosition) {
                    this.skip(position - streamPosition);
                    streamPosition = position;
                }
                if (this.presentStream != null && !this.presentStream.nextBit()) {
                    if (this.nullsAllowed) {
                        if (this.outputRequired) {
                            this.nulls[this.outputPositionCount] = true;
                        }
                        if (this.filter != null) {
                            this.outputPositions[this.outputPositionCount] = position;
                        }
                        ++this.outputPositionCount;
                    }
                } else {
                    long value = this.dataStream.next();
                    if (this.filter == null || this.filter.testLong(value)) {
                        if (this.outputRequired) {
                            this.values[this.outputPositionCount] = value;
                            if (this.nullsAllowed && this.presentStream != null) {
                                this.nulls[this.outputPositionCount] = false;
                            }
                        }
                        this.outputPositions[this.outputPositionCount] = position;
                        ++this.outputPositionCount;
                    }
                }
                ++streamPosition;
            }
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        boolean checkNulls;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, this.nullsAllowed && this.presentStream != null);
        }
        if (filters != null) {
            this.ensureOutputPositionsCapacity(positionCount);
        } else {
            this.outputPositions = positions;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        this.outputPositionCount = 0;
        int streamPosition = 0;
        boolean bl = checkNulls = filters != null && filters.stream().anyMatch(f -> f.testNull());
        if (this.dataStream == null && this.presentStream != null) {
            streamPosition = this.readAllNulls(positions, positionCount);
            if (checkNulls && accumulator != null) {
                accumulator.set(positions[0], streamPosition);
            }
        } else {
            for (int i = 0; i < positionCount; ++i) {
                int position = positions[i];
                if (position > streamPosition) {
                    this.skip(position - streamPosition);
                    streamPosition = position;
                }
                if (this.presentStream != null && !this.presentStream.nextBit()) {
                    if (this.nullsAllowed) {
                        if (this.outputRequired) {
                            this.nulls[this.outputPositionCount] = true;
                        }
                        if (filters != null) {
                            this.outputPositions[this.outputPositionCount] = position;
                        }
                        if (accumulator != null && checkNulls) {
                            accumulator.set(position);
                        }
                        ++this.outputPositionCount;
                    }
                } else {
                    long value = this.dataStream.next();
                    if ((accumulator != null && accumulator.get(position) || filters == null || filters.size() <= 0 || filters.stream().anyMatch(f -> f.testLong(value))) && accumulator != null) {
                        accumulator.set(position);
                    }
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = value;
                        if (this.nullsAllowed && this.presentStream != null) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
                ++streamPosition;
            }
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nullsAllowed) {
            this.outputPositionCount = positionCount;
            if (this.outputPositions != positions) {
                System.arraycopy(positions, 0, this.outputPositions, 0, this.outputPositionCount);
            }
            this.allNulls = true;
        } else {
            this.outputPositionCount = 0;
        }
        return positions[positionCount - 1] + 1;
    }

    private void skip(int items) throws IOException {
        if (this.dataStream == null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            this.dataStream.skip(dataToSkip);
        } else {
            this.dataStream.skip(items);
        }
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), this.outputPositionCount);
        }
        return this.buildOutputBlock(positions, positionCount, this.nullsAllowed && this.presentStream != null);
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dataStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void close() {
        this.values = null;
        this.nulls = null;
        this.outputPositions = null;
        this.dataStreamSource = null;
        this.dataStream = null;
        this.systemMemoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.values) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions);
    }
}

