/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.cache.Cache;
import io.airlift.log.Logger;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDataSourceIdWithTimeStamp;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcRowDataCacheKey;
import io.prestosql.orc.OrcSelectiveRowDataCacheKey;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.StreamSourceMeta;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockListBlock;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiConsumer;

public class ResultCachingSelectiveColumnReader<T>
implements SelectiveColumnReader<T> {
    private static final Logger log = Logger.get(SelectiveColumnReader.class);
    private final Cache<OrcRowDataCacheKey, Block> cache;
    private final SelectiveColumnReader delegate;
    private final OrcColumn column;
    private final OrcPredicate predicate;
    private OrcDataSourceId orcDataSourceId;
    private long lastModifiedTime;
    private long stripeOffset;
    private long rowGroupOffset;
    private int offset;
    private int readSize;
    private int totalPositionCount;
    private Block cachedBlock;
    private int[] positions;
    private List<Block<T>> accumulatorBlocks;
    private OrcSelectiveRowDataCacheKey cacheKey;

    public ResultCachingSelectiveColumnReader(Cache<OrcRowDataCacheKey, Block> cache, SelectiveColumnReader delegate, OrcColumn column, OrcPredicate predicate) {
        this.cache = cache;
        this.delegate = delegate;
        this.column = column;
        this.predicate = predicate;
        this.accumulatorBlocks = new ArrayList<Block<T>>(5);
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        if (this.cachedBlock != null) {
            this.readSize = Integer.min(positionCount, this.cachedBlock.getPositionCount() - this.offset);
            this.offset += this.readSize;
            this.positions = positions;
            return this.readSize;
        }
        return this.delegate.read(offset, positions, positionCount, null);
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filter, BitSet accumulator) throws IOException {
        if (this.cachedBlock != null) {
            this.readSize = Integer.min(positionCount, this.cachedBlock.getPositionCount() - this.offset);
            this.offset += this.readSize;
            this.positions = positions;
            if (this.readSize > 0) {
                accumulator.set(offset, offset + this.readSize);
            }
            return this.readSize;
        }
        return this.delegate.readOr(offset, positions, positionCount, filter, accumulator);
    }

    @Override
    public int[] getReadPositions() {
        if (this.cachedBlock != null) {
            return this.positions;
        }
        return this.delegate.getReadPositions();
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        if (this.cachedBlock != null) {
            return this.cachedBlock.getRegion(this.offset - this.readSize, this.readSize);
        }
        Block result = this.delegate.getBlock(positions, positionCount);
        this.accumulatorBlocks.add(result);
        this.totalPositionCount += result.getPositionCount();
        return result;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        this.offset = 0;
        this.readSize = 0;
        this.cachedBlock = null;
        this.delegate.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.offset = 0;
        this.readSize = 0;
        StreamSourceMeta streamSourceMeta = dataStreamSources.getStreamSourceMeta();
        this.orcDataSourceId = streamSourceMeta.getDataSourceId();
        this.lastModifiedTime = streamSourceMeta.getLastModifiedTime();
        this.stripeOffset = streamSourceMeta.getStripeOffset();
        this.rowGroupOffset = streamSourceMeta.getRowGroupOffset();
        OrcSelectiveRowDataCacheKey newCachKey = new OrcSelectiveRowDataCacheKey();
        newCachKey.setOrcDataSourceId(new OrcDataSourceIdWithTimeStamp(this.orcDataSourceId, this.lastModifiedTime));
        newCachKey.setStripeOffset(streamSourceMeta.getStripeOffset());
        newCachKey.setRowGroupOffset(streamSourceMeta.getRowGroupOffset());
        newCachKey.setColumnId(this.column.getColumnId());
        newCachKey.setPredicate(this.predicate);
        this.cachedBlock = this.cacheAccumulated(newCachKey);
        this.delegate.startRowGroup(dataStreamSources);
    }

    private Block cacheAccumulated(OrcSelectiveRowDataCacheKey newCachKey) throws IOException {
        if (this.cacheKey != null && this.cachedBlock == null) {
            this.cache.put((Object)this.cacheKey, (Object)this.mergeAccumulatedBlocks(this.accumulatorBlocks));
            this.accumulatorBlocks.clear();
            this.totalPositionCount = 0;
        }
        this.cacheKey = newCachKey;
        return (Block)this.cache.getIfPresent((Object)newCachKey);
    }

    @Override
    public void close() {
        if (this.cacheKey != null && this.cachedBlock == null) {
            this.cache.put((Object)this.cacheKey, (Object)this.mergeAccumulatedBlocks(this.accumulatorBlocks));
            this.accumulatorBlocks.clear();
            this.totalPositionCount = 0;
        }
        this.delegate.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.delegate.getRetainedSizeInBytes();
    }

    private Block mergeAccumulatedBlocks(List<Block<T>> accumulatedBlocks) {
        if (accumulatedBlocks.size() > 0) {
            return new BlockListBlock(accumulatedBlocks.toArray(new Block[accumulatedBlocks.size()]), accumulatedBlocks.size(), this.totalPositionCount);
        }
        return new Block<T>(){

            public void writePositionTo(int position, BlockBuilder blockBuilder) {
            }

            public Block getSingleValueBlock(int position) {
                return null;
            }

            public int getPositionCount() {
                return 0;
            }

            public long getSizeInBytes() {
                return 0L;
            }

            public long getRegionSizeInBytes(int position, int length) {
                return 0L;
            }

            public long getPositionsSizeInBytes(boolean[] positions) {
                return 0L;
            }

            public long getRetainedSizeInBytes() {
                return 0L;
            }

            public long getEstimatedDataSizeForStats(int position) {
                return 0L;
            }

            public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
            }

            public String getEncodingName() {
                return null;
            }

            public Block copyPositions(int[] positions, int offset, int length) {
                return null;
            }

            public Block getRegion(int positionOffset, int length) {
                return null;
            }

            public Block copyRegion(int position, int length) {
                return null;
            }

            public boolean isNull(int position) {
                return false;
            }
        };
    }
}

