/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.cache.Cache;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcRowDataCacheKey;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.reader.BooleanSelectiveColumnReader;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.DataCachingSelectiveColumnReader;
import io.prestosql.orc.reader.DoubleSelectiveColumnReader;
import io.prestosql.orc.reader.FloatSelectiveColumnReader;
import io.prestosql.orc.reader.LongDecimalSelectiveColumnReader;
import io.prestosql.orc.reader.LongSelectiveColumnReader;
import io.prestosql.orc.reader.ResultCachingSelectiveColumnReader;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.reader.ShortDecimalSelectiveColumnReader;
import io.prestosql.orc.reader.SliceSelectiveColumnReader;
import io.prestosql.orc.reader.TimestampSelectiveColumnReader;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import java.util.Optional;
import org.joda.time.DateTimeZone;

public final class SelectiveColumnReaders {
    private SelectiveColumnReaders() {
    }

    public static SelectiveColumnReader createColumnReader(OrcType orcType, OrcColumn column, Optional<TupleDomainFilter> filter, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryContext) {
        switch (column.getColumnType()) {
            case BOOLEAN: {
                return new BooleanSelectiveColumnReader(column, filter, outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveColumnReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongSelectiveColumnReader(column, filter, outputType, systemMemoryContext.newLocalMemoryContext(SelectiveColumnReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceSelectiveColumnReader(orcType, column, filter, outputType, systemMemoryContext.newLocalMemoryContext(SelectiveColumnReaders.class.getSimpleName()));
            }
            case TIMESTAMP: {
                return new TimestampSelectiveColumnReader(column, filter, outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveColumnReaders.class.getSimpleName()));
            }
            case DECIMAL: {
                if (orcType.getPrecision().get() > 18) {
                    return new LongDecimalSelectiveColumnReader(orcType, column, filter, outputType, systemMemoryContext.newLocalMemoryContext(SelectiveColumnReaders.class.getSimpleName()));
                }
                return new ShortDecimalSelectiveColumnReader(orcType, column, filter, outputType, systemMemoryContext.newLocalMemoryContext(SelectiveColumnReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                return new DoubleSelectiveColumnReader(column, filter, outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveColumnReaders.class.getSimpleName()));
            }
            case FLOAT: {
                return new FloatSelectiveColumnReader(column, filter, outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveColumnReader.class.getSimpleName()));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)column.getColumnType()));
    }

    public static SelectiveColumnReader wrapWithResultCachingStreamReader(SelectiveColumnReader original, OrcColumn column, OrcPredicate predicate, Cache<OrcRowDataCacheKey, Block> cache) {
        return new ResultCachingSelectiveColumnReader(cache, original, column, predicate);
    }

    public static SelectiveColumnReader wrapWithDataCachingStreamReader(ColumnReader original, OrcColumn column, Cache<OrcRowDataCacheKey, Block> cache) {
        return new DataCachingSelectiveColumnReader(original, column, cache);
    }
}

