/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.reader.AbstractNumericColumnReader;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.block.ShortArrayBlock;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class ShortColumnReader
extends AbstractNumericColumnReader<Short> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ShortColumnReader.class).instanceSize();
    private short[] shortNonNullValueTemp = new short[0];

    public ShortColumnReader(Type type, OrcColumn column, LocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        super(type, column, systemMemoryContext);
    }

    @Override
    public Block<Short> readBlock() throws IOException {
        Object block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)SmallintType.SMALLINT, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)SmallintType.SMALLINT, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block readNonNullBlock() throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        short[] values = new short[this.nextBatchSize];
        this.dataStream.next(values, this.nextBatchSize);
        return new ShortArrayBlock(this.nextBatchSize, Optional.empty(), values);
    }

    private Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        return this.shortReadNullBlock(isNull, nonNullCount);
    }

    private Block shortReadNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.shortNonNullValueTemp.length < minNonNullValueSize) {
            this.shortNonNullValueTemp = new short[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((short[])this.shortNonNullValueTemp));
        }
        this.dataStream.next(this.shortNonNullValueTemp, nonNullCount);
        short[] result = ReaderUtils.unpackShortNulls(this.shortNonNullValueTemp, isNull);
        return new ShortArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    @Override
    public boolean filterTest(TupleDomainFilter filter, Short value) {
        if (value == null) {
            return filter.testNull();
        }
        return filter.testLong(value.shortValue());
    }
}

