/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.reader.AbstractDecimalSelectiveColumnReader;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;

public class ShortDecimalSelectiveColumnReader
extends AbstractDecimalSelectiveColumnReader<Short> {
    public ShortDecimalSelectiveColumnReader(OrcType orcType, OrcColumn streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext systemMemoryContext) {
        super(orcType, streamDescriptor, filter, outputType, systemMemoryContext, 1);
    }

    @Override
    protected int readNoFilter(int[] positions, int positionCount) throws IOException {
        long[] data = new long[1];
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
            } else {
                this.dataStream.nextShortDecimal(data, 1);
                this.values[i] = Decimals.rescale((long)data[0], (int)((int)this.scaleStream.next()), (int)this.scale);
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    @Override
    protected int readWithFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters) throws IOException {
        int streamPosition = 0;
        this.outputPositionCount = 0;
        long[] data = new long[1];
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                this.dataStream.nextShortDecimal(data, 1);
                long rescale = Decimals.rescale((long)data[0], (int)((int)this.scaleStream.next()), (int)this.scale);
                if (filters == null || filters.get(0).testLong(rescale)) {
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = rescale;
                        if (this.nullsAllowed && this.presentStream != null) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            }
            ++streamPosition;
        }
        return streamPosition;
    }

    @Override
    protected int readWithOrFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        int streamPosition = 0;
        this.outputPositionCount = 0;
        long[] data = new long[1];
        boolean checkNulls = filters != null && filters.stream().anyMatch(f -> f.testNull());
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    if (accumulator != null && checkNulls) {
                        accumulator.set(position);
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                this.dataStream.nextShortDecimal(data, 1);
                long rescale = Decimals.rescale((long)data[0], (int)((int)this.scaleStream.next()), (int)this.scale);
                if ((accumulator != null && accumulator.get(position) || filters == null || filters.stream().anyMatch(f -> f.testLong(rescale))) && accumulator != null) {
                    accumulator.set(position);
                }
                if (this.outputRequired) {
                    this.values[this.outputPositionCount] = rescale;
                    if (this.nullsAllowed && this.presentStream != null) {
                        this.nulls[this.outputPositionCount] = false;
                    }
                }
                this.outputPositions[this.outputPositionCount] = position;
                ++this.outputPositionCount;
            }
            ++streamPosition;
        }
        return streamPosition;
    }

    @Override
    protected void copyValues(int[] positions, int positionCount, long[] valuesCopy, boolean[] nullsCopy) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            valuesCopy[positionIndex] = this.values[i];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
    }

    @Override
    protected void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            this.values[positionIndex] = this.values[i];
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    protected Block makeBlock(int positionCount, boolean includeNulls, boolean[] nulls, long[] values) {
        return new LongArrayBlock(positionCount, Optional.ofNullable((boolean[])(includeNulls ? nulls : null)), values);
    }

    @Override
    public Block<Short> mergeBlocks(List<Block<Short>> blocks, int positionCount) {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, positionCount);
        blocks.stream().forEach(block -> {
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                blockBuilder.writeLong(block.getLong(i, 0));
            }
        });
        return blockBuilder.build();
    }
}

