/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import io.airlift.slice.Slice;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.orc.reader.SliceDictionaryColumnReader;
import io.prestosql.orc.reader.SliceDirectColumnReader;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SliceColumnReader
implements ColumnReader<byte[]> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceColumnReader.class).instanceSize();
    private final OrcColumn column;
    private final SliceDirectColumnReader directReader;
    private final SliceDictionaryColumnReader dictionaryReader;
    private ColumnReader currentReader;

    public SliceColumnReader(Type type, OrcColumn column, AggregatedMemoryContext systemMemoryContext) throws OrcCorruptionException, PrestoException {
        Objects.requireNonNull(type, "type is null");
        if (!(type instanceof VarcharType || type instanceof CharType || type instanceof VarbinaryType)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Type %s can't be converted into type %s", new Object[]{type, column.getColumnType()}));
        }
        ReaderUtils.verifyStreamType(column, type, t -> t instanceof VarcharType || t instanceof CharType || t instanceof VarbinaryType);
        this.column = Objects.requireNonNull(column, "column is null");
        int maxCodePointCount = SliceColumnReader.getMaxCodePointCount(type);
        boolean charType = Chars.isCharType((Type)type);
        this.directReader = new SliceDirectColumnReader(column, maxCodePointCount, charType);
        this.dictionaryReader = new SliceDictionaryColumnReader(column, systemMemoryContext.newLocalMemoryContext(SliceColumnReader.class.getSimpleName()), maxCodePointCount, charType);
    }

    @Override
    public Block readBlock() throws IOException {
        return this.currentReader.readBlock();
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.currentReader.prepareNextRead(batchSize);
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind columnEncodingKind = encoding.get(this.column.getColumnId()).getColumnEncodingKind();
        if (columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DIRECT || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2) {
            this.currentReader = this.directReader;
        } else if (columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DICTIONARY || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            this.currentReader = this.dictionaryReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)columnEncodingKind));
        }
        this.currentReader.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    private static int getMaxCodePointCount(Type type) {
        if (Varchars.isVarcharType((Type)type)) {
            VarcharType varcharType = (VarcharType)type;
            return varcharType.isUnbounded() ? -1 : varcharType.getBoundedLength();
        }
        if (Chars.isCharType((Type)type)) {
            return ((CharType)type).getLength();
        }
        if (VarbinaryType.isVarbinaryType((Type)type)) {
            return -1;
        }
        throw new IllegalArgumentException("Unsupported encoding " + type.getDisplayName());
    }

    public static int computeTruncatedLength(Slice slice, int offset, int length, int maxCodePointCount, boolean isCharType) {
        if (isCharType) {
            return Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)maxCodePointCount);
        }
        if (maxCodePointCount >= 0 && length > maxCodePointCount) {
            return Varchars.byteCount((Slice)slice, (int)offset, (int)length, (int)maxCodePointCount);
        }
        return length;
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.directReader::close);
            closer.register(this.dictionaryReader::close);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.directReader.getRetainedSizeInBytes() + this.dictionaryReader.getRetainedSizeInBytes();
    }

    @Override
    public boolean filterTest(TupleDomainFilter filter, byte[] value) {
        if (value == null) {
            return filter.testNull();
        }
        return filter.testBytes(value, 0, value.length);
    }
}

