/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.reader.SliceSelectiveColumnReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.ByteArrayInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.block.VariableWidthBlock;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionarySelectiveColumnReader
implements SelectiveColumnReader<byte[]> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionarySelectiveColumnReader.class).instanceSize();
    private static final byte[] EMPTY_DICTIONARY_DATA = new byte[0];
    private static final int[] EMPTY_DICTIONARY_OFFSETS = new int[2];
    private final TupleDomainFilter filter;
    private final boolean nullsAllowed;
    private final Type outputType;
    private final boolean outputRequired;
    private final OrcColumn streamDescriptor;
    private final int maxCodePointCount;
    private final boolean isCharType;
    private byte[] stripeDictionaryData = EMPTY_DICTIONARY_DATA;
    private int[] stripeDictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
    private byte[] currentDictionaryData = EMPTY_DICTIONARY_DATA;
    private int[] stripeDictionaryLength = new int[0];
    private int[] rowGroupDictionaryLength = new int[0];
    private int readOffset;
    private VariableWidthBlock dictionaryBlock = new VariableWidthBlock(1, Slices.wrappedBuffer((byte[])EMPTY_DICTIONARY_DATA), EMPTY_DICTIONARY_OFFSETS, Optional.of(new boolean[]{true}));
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private BooleanInputStream presentStream;
    private BooleanInputStream inDictionaryStream;
    private InputStreamSource<ByteArrayInputStream> stripeDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private InputStreamSource<LongInputStream> stripeDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private boolean stripeDictionaryOpen;
    private int stripeDictionarySize;
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private LocalMemoryContext systemMemoryContext;
    private int[] values;
    private boolean allNulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean outputPositionsReadOnly;
    private boolean valuesInUse;
    private final OrcType orcType;

    public SliceDictionarySelectiveColumnReader(OrcType orcType, OrcColumn streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = Objects.requireNonNull(filter, "filter is null").orElse(null);
        this.systemMemoryContext = systemMemoryContext;
        this.nullsAllowed = this.filter == null || this.filter.testNull();
        this.outputType = Objects.requireNonNull(outputType, "outputType is null").orElse(null);
        this.maxCodePointCount = orcType == null ? 0 : orcType.getLength().orElse(-1);
        this.isCharType = orcType.getOrcTypeKind() == OrcType.OrcTypeKind.CHAR;
        this.outputRequired = outputType.isPresent();
        this.orcType = orcType;
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        return this.readOr(offset, positions, positionCount, (List<TupleDomainFilter>)(this.filter == null ? null : ImmutableList.of((Object)this.filter)), null);
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        int streamPosition;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.outputRequired && (this.values == null || this.values.length < positionCount)) {
            this.values = new int[positionCount];
        }
        if (filters != null) {
            if (this.outputPositions == null || this.outputPositions.length < positionCount) {
                this.outputPositions = new int[positionCount];
            }
        } else {
            this.outputPositions = positions;
            this.outputPositionsReadOnly = true;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        this.outputPositionCount = 0;
        if (this.dataStream == null && this.presentStream != null) {
            streamPosition = this.readAllNulls(positions, positionCount);
            if (filters != null && filters.get(0).testNull() && accumulator != null) {
                accumulator.set(positions[0], streamPosition);
            }
        } else {
            streamPosition = filters == null ? this.readNoFilter(positions, positionCount) : (accumulator == null ? this.readWithFilter(positions, positionCount, filters) : this.readWithOrFilter(positions, positionCount, filters, accumulator));
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            this.values[i] = this.presentStream != null && !this.presentStream.nextBit() ? this.dictionaryBlock.getPositionCount() - 1 : Math.toIntExact(this.dataStream.next());
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private int readWithFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters) throws IOException {
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = this.dictionaryBlock.getPositionCount() - 1;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int index = Math.toIntExact(this.dataStream.next());
                int currentPosLength = this.dictionaryBlock.getSliceLength(index);
                if (filters.get(0).testLength(currentPosLength)) {
                    Slice data = this.dictionaryBlock.getSlice(index, 0, currentPosLength);
                    if (filters == null || filters.get(0).testBytes(data.getBytes(), 0, currentPosLength)) {
                        if (this.outputRequired) {
                            this.values[this.outputPositionCount] = index;
                        }
                        this.outputPositions[this.outputPositionCount] = position;
                        ++this.outputPositionCount;
                    }
                }
            }
            ++streamPosition;
        }
        return streamPosition;
    }

    private int readWithOrFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        int streamPosition = 0;
        boolean checkNulls = filters != null && filters.stream().anyMatch(f -> f.testNull());
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = this.dictionaryBlock.getPositionCount() - 1;
                    }
                    if (accumulator != null && checkNulls) {
                        accumulator.set(position);
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int index = Math.toIntExact(this.dataStream.next());
                int currentPosLength = this.dictionaryBlock.getSliceLength(index);
                if (filters.get(0).testLength(currentPosLength)) {
                    Slice data = this.dictionaryBlock.getSlice(index, 0, currentPosLength);
                    if ((accumulator != null && accumulator.get(position) || filters == null || filters.stream().anyMatch(f -> f.testBytes(data.getBytes(), 0, currentPosLength))) && accumulator != null) {
                        accumulator.set(position);
                    }
                }
                if (this.outputRequired) {
                    this.values[this.outputPositionCount] = index;
                }
                this.outputPositions[this.outputPositionCount] = position;
                ++this.outputPositionCount;
            }
            ++streamPosition;
        }
        return streamPosition;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nullsAllowed) {
            this.outputPositionCount = positionCount;
            if (this.outputPositions != positions) {
                System.arraycopy(positions, 0, this.outputPositions, 0, this.outputPositionCount);
            }
        } else {
            this.outputPositionCount = 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private void skip(int items) throws IOException {
        if (this.dataStream == null) {
            if (this.presentStream != null) {
                this.presentStream.skip(items);
            }
        } else if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(dataToSkip);
            }
            this.dataStream.skip(dataToSkip);
        } else {
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(items);
            }
            this.dataStream.skip(items);
        }
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), this.outputPositionCount);
        }
        if (positionCount == this.outputPositionCount) {
            return new DictionaryBlock(positionCount, (Block)this.dictionaryBlock, this.values);
        }
        int[] valuesCopy = new int[positionCount];
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            valuesCopy[positionIndex] = this.values[i];
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new DictionaryBlock(positionCount, (Block)this.dictionaryBlock, valuesCopy);
    }

    private void openRowGroup() throws IOException {
        if (!this.stripeDictionaryOpen) {
            if (this.stripeDictionarySize > 0) {
                LongInputStream lengthStream;
                if (this.stripeDictionaryLength.length < this.stripeDictionarySize) {
                    this.stripeDictionaryLength = new int[this.stripeDictionarySize];
                }
                if ((lengthStream = this.stripeDictionaryLengthStreamSource.openStream()) == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but dictionary length stream is not present");
                }
                lengthStream.nextIntVector(this.stripeDictionarySize, this.stripeDictionaryLength, 0);
                long dataLength = 0L;
                for (int i = 0; i < this.stripeDictionarySize; ++i) {
                    dataLength += (long)this.stripeDictionaryLength[i];
                }
                this.stripeDictionaryData = new byte[Math.toIntExact(dataLength)];
                this.stripeDictionaryOffsetVector = new int[this.stripeDictionarySize + 2];
                ByteArrayInputStream dictionaryDataStream = this.stripeDictionaryDataStreamSource.openStream();
                SliceDictionarySelectiveColumnReader.readDictionary(dictionaryDataStream, this.stripeDictionarySize, this.stripeDictionaryLength, 0, this.stripeDictionaryData, this.stripeDictionaryOffsetVector, this.maxCodePointCount, this.isCharType);
            } else {
                this.stripeDictionaryData = EMPTY_DICTIONARY_DATA;
                this.stripeDictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
            }
        }
        this.stripeDictionaryOpen = true;
        this.setDictionaryBlockData(this.stripeDictionaryData, this.stripeDictionaryOffsetVector, this.stripeDictionarySize + 1);
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(@Nullable ByteArrayInputStream dictionaryDataStream, int dictionarySize, int[] dictionaryLengthVector, int offsetVectorOffset, byte[] data, int[] offsetVector, int maxCodePointCount, boolean isCharType) throws IOException {
        Slice slice = Slices.wrappedBuffer((byte[])data);
        if (offsetVectorOffset == 0) {
            offsetVector[0] = 0;
        }
        for (int i = 0; i < dictionarySize; ++i) {
            int truncatedLength;
            int offsetIndex = offsetVectorOffset + i;
            int offset = offsetVector[offsetIndex];
            int length = dictionaryLengthVector[i];
            if (length > 0) {
                dictionaryDataStream.next(data, offset, offset + length);
                truncatedLength = SliceSelectiveColumnReader.computeTruncatedLength(slice, offset, length, maxCodePointCount, isCharType);
                Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
            } else {
                truncatedLength = 0;
            }
            offsetVector[offsetIndex + 1] = offsetVector[offsetIndex] + truncatedLength;
        }
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.stripeDictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayInputStream.class);
        this.stripeDictionaryLengthStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.stripeDictionarySize = encoding.get(this.streamDescriptor.getColumnId()).getDictionarySize();
        this.stripeDictionaryOpen = false;
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void close() {
        this.values = null;
        this.outputPositions = null;
        this.currentDictionaryData = null;
        this.rowGroupDictionaryLength = null;
        this.stripeDictionaryData = null;
        this.stripeDictionaryLength = null;
        this.systemMemoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.currentDictionaryData) + SizeOf.sizeOf((int[])this.values) + SizeOf.sizeOf((int[])this.outputPositions);
    }

    private void setDictionaryBlockData(byte[] dictionaryData, int[] dictionaryOffsets, int positionCount) {
        Verify.verify((positionCount > 0 ? 1 : 0) != 0);
        if (this.currentDictionaryData != dictionaryData) {
            boolean[] isNullVector = new boolean[positionCount];
            isNullVector[positionCount - 1] = true;
            dictionaryOffsets[positionCount] = dictionaryOffsets[positionCount - 1];
            this.dictionaryBlock = new VariableWidthBlock(positionCount, Slices.wrappedBuffer((byte[])dictionaryData), dictionaryOffsets, Optional.of(isNullVector));
            this.currentDictionaryData = dictionaryData;
        }
    }
}

