/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.reader.SliceSelectiveColumnReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.ByteArrayInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.block.VariableWidthBlock;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class SliceDirectSelectiveColumnReader
implements SelectiveColumnReader<byte[]> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDirectSelectiveColumnReader.class).instanceSize();
    private static final int ONE_GIGABYTE = Math.toIntExact(new DataSize(1.0, DataSize.Unit.GIGABYTE).toBytes());
    private final TupleDomainFilter filter;
    private final boolean nullsAllowed;
    private final OrcColumn streamDescriptor;
    private final boolean outputRequired;
    private final Type outputType;
    private final boolean isCharType;
    private final int maxCodePointCount;
    private int readOffset;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private BooleanInputStream presentStream;
    private InputStreamSource<ByteArrayInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private ByteArrayInputStream dataStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;
    private LocalMemoryContext systemMemoryContext;
    private boolean[] nulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean outputPositionsReadOnly;
    private boolean allNulls;
    private boolean[] isNullVector;
    private int[] lengthVector;
    private int lengthIndex;
    private int[] offsets;
    private byte[] data;
    private Slice dataAsSlice;
    private boolean valuesInUse;
    private final OrcType orcType;

    public SliceDirectSelectiveColumnReader(OrcType orcType, OrcColumn streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext newLocalMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = Objects.requireNonNull(filter, "filter is null").orElse(null);
        this.systemMemoryContext = newLocalMemoryContext;
        this.nullsAllowed = this.filter == null || this.filter.testNull();
        this.outputType = Objects.requireNonNull(outputType, "outputType is null").orElse(null);
        this.outputRequired = outputType.isPresent();
        this.orcType = orcType;
        this.isCharType = orcType.getOrcTypeKind() == OrcType.OrcTypeKind.CHAR;
        this.maxCodePointCount = orcType.getLength().orElse(-1);
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        return this.readOr(offset, positions, positionCount, (List<TupleDomainFilter>)(this.filter == null ? null : ImmutableList.of((Object)this.filter)), null);
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        int streamPosition;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (filters != null) {
            if (this.outputPositions == null || this.outputPositions.length < positionCount) {
                this.outputPositions = new int[positionCount];
            }
        } else {
            this.outputPositions = positions;
            this.outputPositionsReadOnly = true;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        this.prepareForNextRead(positionCount, positions);
        if (this.lengthStream == null) {
            streamPosition = this.readAllNulls(positions, positionCount);
            if (filters != null && filters.get(0).testNull() && accumulator != null) {
                accumulator.set(positions[0], streamPosition);
            }
        } else {
            streamPosition = filters == null ? this.readNoFilter(positions, positionCount) : (accumulator == null ? this.readWithFilter(positions, positionCount, filters) : this.readWithOrFilter(positions, positionCount, filters, accumulator));
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        this.allNulls = false;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skipData(streamPosition, position - streamPosition);
                streamPosition = position;
            }
            int offset = this.offsets[i];
            if (this.presentStream != null && this.isNullVector[position]) {
                if (this.offsets != null) {
                    this.offsets[i + 1] = offset;
                }
                this.nulls[i] = true;
            } else {
                int length = this.lengthVector[this.lengthIndex];
                int truncatedLength = 0;
                if (length > 0) {
                    this.dataStream.next(this.data, offset, offset + length);
                    truncatedLength = SliceSelectiveColumnReader.computeTruncatedLength(this.dataAsSlice, offset, length, this.maxCodePointCount, this.isCharType);
                }
                this.offsets[i + 1] = offset + truncatedLength;
                ++this.lengthIndex;
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private int readWithOrFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        this.allNulls = false;
        int streamPosition = 0;
        int dataToSkip = 0;
        boolean checkNulls = filters != null && filters.stream().anyMatch(f -> f.testNull());
        for (int i = 0; i < positionCount; ++i) {
            int offset;
            int position = positions[i];
            if (position > streamPosition) {
                this.skipData(streamPosition, position - streamPosition);
                streamPosition = position;
            }
            int n = offset = this.outputRequired ? this.offsets[this.outputPositionCount] : 0;
            if (this.isNullVector != null && this.isNullVector[position]) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.offsets[this.outputPositionCount + 1] = offset;
                        this.nulls[this.outputPositionCount] = true;
                    }
                    if (accumulator != null && checkNulls) {
                        accumulator.set(position);
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int dataOffset;
                int length = this.lengthVector[this.lengthIndex];
                int n2 = dataOffset = this.outputRequired ? offset : 0;
                if (this.dataStream != null) {
                    this.dataStream.skip(dataToSkip);
                    dataToSkip = 0;
                    this.dataStream.next(this.data, dataOffset, dataOffset + length);
                    if ((accumulator != null && accumulator.get(position) || filters == null || filters.stream().anyMatch(f -> f.testBytes(this.data, dataOffset, length))) && accumulator != null) {
                        accumulator.set(position);
                    }
                } else if ((accumulator != null && accumulator.get(position) || filters == null || filters.stream().anyMatch(f -> f.testBytes("".getBytes(StandardCharsets.UTF_8), 0, 0))) && accumulator != null) {
                    accumulator.set(position);
                }
                if (this.outputRequired) {
                    int truncatedLength = 0;
                    if (this.dataStream != null) {
                        truncatedLength = SliceSelectiveColumnReader.computeTruncatedLength(this.dataAsSlice, dataOffset, length, this.maxCodePointCount, this.isCharType);
                    }
                    this.offsets[this.outputPositionCount + 1] = offset + truncatedLength;
                    if (this.nullsAllowed && this.isNullVector != null) {
                        this.nulls[this.outputPositionCount] = false;
                    }
                }
                this.outputPositions[this.outputPositionCount] = position;
                ++this.outputPositionCount;
                ++this.lengthIndex;
            }
            ++streamPosition;
        }
        if (dataToSkip > 0) {
            this.dataStream.skip(dataToSkip);
        }
        return streamPosition;
    }

    private int readWithFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters) throws IOException {
        this.allNulls = false;
        int streamPosition = 0;
        int dataToSkip = 0;
        for (int i = 0; i < positionCount; ++i) {
            int offset;
            int position = positions[i];
            if (position > streamPosition) {
                this.skipData(streamPosition, position - streamPosition);
                streamPosition = position;
            }
            int n = offset = this.outputRequired ? this.offsets[this.outputPositionCount] : 0;
            if (this.isNullVector != null && this.isNullVector[position]) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.offsets[this.outputPositionCount + 1] = offset;
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int dataOffset;
                int length = this.lengthVector[this.lengthIndex];
                int n2 = dataOffset = this.outputRequired ? offset : 0;
                if (this.isCharType || filters.get(0).testLength(length)) {
                    if (this.dataStream != null) {
                        this.dataStream.skip(dataToSkip);
                        dataToSkip = 0;
                        this.dataStream.next(this.data, dataOffset, dataOffset + length);
                        int truncatedLength = SliceSelectiveColumnReader.computeTruncatedLength(this.dataAsSlice, dataOffset, length, this.maxCodePointCount, this.isCharType);
                        if (filters == null || filters.get(0).testBytes(this.data, dataOffset, truncatedLength)) {
                            if (this.outputRequired) {
                                this.offsets[this.outputPositionCount + 1] = offset + truncatedLength;
                                if (this.nullsAllowed && this.isNullVector != null) {
                                    this.nulls[this.outputPositionCount] = false;
                                }
                            }
                            this.outputPositions[this.outputPositionCount] = position;
                            ++this.outputPositionCount;
                        }
                    } else if (filters == null || filters.get(0).testBytes("".getBytes(StandardCharsets.UTF_8), 0, 0)) {
                        if (this.outputRequired) {
                            this.offsets[this.outputPositionCount + 1] = offset;
                            if (this.nullsAllowed && this.isNullVector != null) {
                                this.nulls[this.outputPositionCount] = false;
                            }
                        }
                        this.outputPositions[this.outputPositionCount] = position;
                        ++this.outputPositionCount;
                    }
                } else {
                    dataToSkip += length;
                }
                ++this.lengthIndex;
            }
            ++streamPosition;
        }
        if (dataToSkip > 0) {
            this.dataStream.skip(dataToSkip);
        }
        return streamPosition;
    }

    private int readAllNulls(int[] positions, int positionCount) {
        if (this.nullsAllowed) {
            this.outputPositionCount = positionCount;
            if (this.outputPositions != positions) {
                System.arraycopy(positions, 0, this.outputPositions, 0, this.outputPositionCount);
            }
        } else {
            this.outputPositionCount = 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private void skip(int items) throws IOException {
        if (this.dataStream == null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int lengthToSkip = this.presentStream.countBitsSet(items);
            this.dataStream.skip(this.lengthStream.sum(lengthToSkip));
        } else {
            this.dataStream.skip(this.lengthStream.sum(items));
        }
    }

    private void skipData(int start, int items) throws IOException {
        int dataToSkip = 0;
        for (int i = 0; i < items; ++i) {
            if (this.isNullVector != null && this.isNullVector[start + i]) continue;
            dataToSkip += this.lengthVector[this.lengthIndex];
            ++this.lengthIndex;
        }
        this.dataStream.skip(dataToSkip);
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), this.outputPositionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        VariableWidthBlock block = new VariableWidthBlock(positionCount, this.dataAsSlice, this.offsets, Optional.ofNullable(includeNulls ? this.nulls : null));
        this.dataAsSlice = null;
        this.data = null;
        this.offsets = null;
        this.nulls = null;
        return block;
    }

    private void compactValues(int[] positions, int positionCount, boolean includeNulls) {
        if (this.outputPositionsReadOnly) {
            this.outputPositions = Arrays.copyOf(this.outputPositions, this.outputPositionCount);
            this.outputPositionsReadOnly = false;
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            int length = this.offsets[i + 1] - this.offsets[i];
            if (length > 0) {
                System.arraycopy(this.data, this.offsets[i], this.data, this.offsets[positionIndex], length);
            }
            this.offsets[positionIndex + 1] = this.offsets[positionIndex] + length;
            this.outputPositions[positionIndex] = nextPosition;
            if (includeNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    public void close() {
        this.dataAsSlice = null;
        this.data = null;
        this.lengthVector = null;
        this.isNullVector = null;
        this.offsets = null;
        this.outputPositions = null;
        this.systemMemoryContext.close();
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((byte[])this.data) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.lengthVector) + SizeOf.sizeOf((boolean[])this.isNullVector);
    }

    private void prepareForNextRead(int positionCount, int[] positions) throws IOException {
        this.lengthIndex = 0;
        this.outputPositionCount = 0;
        int totalLength = 0;
        int maxLength = 0;
        int totalPositions = positions[positionCount - 1] + 1;
        int nullCount = 0;
        if (this.presentStream != null) {
            if (this.isNullVector == null || this.isNullVector.length < totalPositions) {
                this.isNullVector = new boolean[totalPositions];
            }
            nullCount = this.presentStream.getUnsetBits(totalPositions, this.isNullVector);
        }
        if (this.lengthStream != null) {
            int nonNullCount = totalPositions - nullCount;
            if (this.lengthVector == null || this.lengthVector.length < nonNullCount) {
                this.lengthVector = new int[nonNullCount];
            }
            this.lengthStream.nextIntVector(nonNullCount, this.lengthVector, 0);
            for (int i = 0; i < nonNullCount; ++i) {
                totalLength += this.lengthVector[i];
                maxLength = Math.max(maxLength, this.lengthVector[i]);
            }
            if (totalLength > ONE_GIGABYTE) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Values in column \"%s\" are too large to process for Presto. %s column values are larger than 1GB [%s]", this.orcType.getFieldName(0), positionCount, this.streamDescriptor.getOrcDataSourceId()));
            }
        }
        if (this.outputRequired) {
            if (this.presentStream != null && this.nullsAllowed) {
                this.nulls = new boolean[positionCount];
            }
            if (this.data == null || this.data.length < totalLength) {
                this.data = new byte[totalLength];
            }
            if (this.offsets == null || this.offsets.length < totalLength + 1) {
                this.offsets = new int[totalPositions + 1];
            }
        } else if (this.data == null || this.data.length < maxLength) {
            this.data = new byte[maxLength];
        }
        this.dataAsSlice = Slices.wrappedBuffer((byte[])this.data);
    }
}

