/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import io.airlift.slice.Slice;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.reader.SliceDictionarySelectiveColumnReader;
import io.prestosql.orc.reader.SliceDirectSelectiveColumnReader;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.Varchars;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class SliceSelectiveColumnReader
implements SelectiveColumnReader<byte[]> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceSelectiveColumnReader.class).instanceSize();
    private final OrcColumn streamDescriptor;
    private final SliceDirectSelectiveColumnReader directReader;
    private final SliceDictionarySelectiveColumnReader dictionaryReader;
    private SelectiveColumnReader currentReader;

    public SliceSelectiveColumnReader(OrcType orcType, OrcColumn streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.directReader = new SliceDirectSelectiveColumnReader(orcType, streamDescriptor, filter, outputType, systemMemoryContext);
        this.dictionaryReader = new SliceDictionarySelectiveColumnReader(orcType, streamDescriptor, filter, outputType, systemMemoryContext);
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind columnEncodingKind = encoding.get(this.streamDescriptor.getColumnId()).getColumnEncodingKind();
        if (columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DIRECT || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2) {
            this.currentReader = this.directReader;
        } else if (columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DICTIONARY || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            this.currentReader = this.dictionaryReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)columnEncodingKind));
        }
        this.currentReader.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.directReader::close);
            closer.register(this.dictionaryReader::close);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.directReader.getRetainedSizeInBytes() + this.dictionaryReader.getRetainedSizeInBytes();
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        return this.currentReader.read(offset, positions, positionCount, null);
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        return this.currentReader.readOr(offset, positions, positionCount, filters, accumulator);
    }

    @Override
    public int[] getReadPositions() {
        return this.currentReader.getReadPositions();
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        return this.currentReader.getBlock(positions, positionCount);
    }

    public static int computeTruncatedLength(Slice slice, int offset, int length, int maxCodePointCount, boolean isCharType) {
        if (isCharType) {
            return Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)maxCodePointCount);
        }
        if (maxCodePointCount >= 0 && length > maxCodePointCount) {
            return Varchars.byteCount((Slice)slice, (int)offset, (int)length, (int)maxCodePointCount);
        }
        return length;
    }
}

