/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.ApacheHiveTimestampDecoder;
import io.prestosql.orc.reader.SelectiveColumnReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.TimestampType;
import java.io.IOException;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class TimestampSelectiveColumnReader
implements SelectiveColumnReader<Long> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TimestampSelectiveColumnReader.class).instanceSize();
    private static final Block NULL_BLOCK = TimestampType.TIMESTAMP.createBlockBuilder(null, 1).appendNull().build();
    private final OrcColumn streamDescriptor;
    private final TupleDomainFilter filter;
    private final boolean nullsAllowed;
    private final boolean outputRequired;
    private final LocalMemoryContext systemMemoryContext;
    private final long baseTimestampInSeconds;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private InputStreamSource<LongInputStream> secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private InputStreamSource<LongInputStream> nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private LongInputStream secondsStream;
    private LongInputStream nanosStream;
    private boolean rowGroupOpen;
    private int readOffset;
    @Nullable
    private long[] values;
    @Nullable
    private boolean[] nulls;
    @Nullable
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean allNulls;
    private boolean valuesInUse;

    public TimestampSelectiveColumnReader(OrcColumn streamDescriptor, Optional<TupleDomainFilter> filter, boolean outputRequired, LocalMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = filter.orElse(null);
        this.outputRequired = outputRequired;
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.nullsAllowed = this.filter == null || this.filter.testNull();
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, Objects.requireNonNull(DateTimeZone.UTC, "hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.secondsStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.nanosStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.values) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.secondsStream = this.secondsStreamSource.openStream();
        this.nanosStream = this.nanosStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int read(int offset, int[] positions, int positionCount, TupleDomainFilter filter) throws IOException {
        return this.readOr(offset, positions, positionCount, (List<TupleDomainFilter>)(this.filter == null ? null : ImmutableList.of((Object)this.filter)), null);
    }

    @Override
    public int readOr(int offset, int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, this.nullsAllowed && this.presentStream != null);
        }
        if (filters != null) {
            if (this.outputPositions == null || this.outputPositions.length < positionCount) {
                this.outputPositions = new int[positionCount];
            }
        } else {
            this.outputPositions = positions;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        int streamPosition = 0;
        if (this.secondsStream == null && this.nanosStream == null && this.presentStream != null) {
            streamPosition = this.readAllNulls(positions, positionCount);
            if (filters != null && filters.get(0).testNull() && accumulator != null) {
                accumulator.set(positions[0], streamPosition);
            }
        } else {
            streamPosition = filters == null ? this.readNoFilter(positions, positionCount) : (accumulator == null ? this.readWithFilter(positions, positionCount, filters) : this.readWithOrFilter(positions, positionCount, filters, accumulator));
        }
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readWithOrFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters, BitSet accumulator) throws IOException {
        int streamPosition = 0;
        this.outputPositionCount = 0;
        boolean checkNulls = filters != null && filters.stream().anyMatch(f -> f.testNull());
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    if (accumulator != null && checkNulls) {
                        accumulator.set(position);
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                long value = ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
                if ((accumulator != null && accumulator.get(position) || filters == null || filters.stream().anyMatch(f -> f.testLong(value))) && accumulator != null) {
                    accumulator.set(position);
                }
                if (this.outputRequired) {
                    this.values[this.outputPositionCount] = value;
                    if (this.nullsAllowed && this.presentStream != null) {
                        this.nulls[this.outputPositionCount] = false;
                    }
                }
                this.outputPositions[this.outputPositionCount] = position;
                ++this.outputPositionCount;
            }
            ++streamPosition;
        }
        return streamPosition;
    }

    private int readWithFilter(int[] positions, int positionCount, List<TupleDomainFilter> filters) throws IOException {
        int streamPosition = 0;
        this.outputPositionCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                long value = ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
                if (filters == null || filters.get(0).testLong(value)) {
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = value;
                        if (this.nullsAllowed && this.presentStream != null) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            }
            ++streamPosition;
        }
        return streamPosition;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nullsAllowed) {
            this.outputPositionCount = positionCount;
            if (this.outputPositions != positions) {
                System.arraycopy(positions, 0, this.outputPositions, 0, this.outputPositionCount);
            }
            this.allNulls = true;
        } else {
            this.outputPositionCount = 0;
        }
        return positions[positionCount - 1] + 1;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
            } else {
                this.values[i] = ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private void skip(int items) throws IOException {
        if (this.secondsStream == null && this.nanosStream == null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            this.secondsStream.skip(dataToSkip);
            this.nanosStream.skip(dataToSkip);
        } else {
            this.secondsStream.skip(items);
            this.nanosStream.skip(items);
        }
    }

    private void ensureValuesCapacity(int capacity, boolean recordNulls) {
        if (this.values == null || this.values.length < capacity) {
            this.values = new long[capacity];
        }
        if (recordNulls && (this.nulls == null || this.nulls.length < capacity)) {
            this.nulls = new boolean[capacity];
        }
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(NULL_BLOCK, this.outputPositionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount == this.outputPositionCount) {
            LongArrayBlock block = new LongArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.values);
            this.nulls = null;
            this.values = null;
            return block;
        }
        long[] valuesCopy = new long[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            valuesCopy[positionIndex] = this.values[i];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new LongArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    @Override
    public void close() {
        this.values = null;
        this.outputPositions = null;
        this.nulls = null;
        this.presentStream = null;
        this.presentStreamSource = null;
        this.secondsStream = null;
        this.secondsStreamSource = null;
        this.nanosStream = null;
        this.nanosStreamSource = null;
        this.systemMemoryContext.close();
    }

    @Override
    public Block mergeBlocks(List<Block<Long>> blocks, int positionCount) {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, positionCount);
        blocks.stream().forEach(block -> {
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                blockBuilder.writeLong(block.getLong(i, 0));
            }
        });
        return blockBuilder.build();
    }
}

