/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.orc.checkpoint.DoubleStreamCheckpoint;
import io.prestosql.orc.stream.OrcInputStream;
import io.prestosql.orc.stream.ValueInputStream;
import java.io.IOException;

public class DoubleInputStream
implements ValueInputStream<DoubleStreamCheckpoint> {
    private static final int BUFFER_SIZE = 128;
    private final OrcInputStream input;
    private final byte[] buffer = new byte[1024];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.buffer);

    public DoubleInputStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<DoubleStreamCheckpoint> getCheckpointType() {
        return DoubleStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(DoubleStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        long length = items * 8L;
        this.input.skipFully(length);
    }

    public double next() throws IOException {
        this.input.readFully(this.buffer, 0, 8);
        return this.slice.getDouble(0);
    }

    public void next(long[] values, int items) throws IOException {
        this.input.readFully(Slices.wrappedLongArray((long[])values), 0, items * 8);
    }
}

