/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.UnsafeSlice;
import java.io.IOException;
import java.io.InputStream;

public final class LongBitPacker {
    private static final int MAX_BUFFERED_POSITIONS = 512;
    private final byte[] tmp = new byte[4096];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.tmp);

    public void unpack(long[] buffer, int offset, int len, int bitSize, InputStream input) throws IOException {
        Preconditions.checkArgument((len <= 512 ? 1 : 0) != 0, (Object)"Expected ORC files to have runs of at most 512 bit packed longs");
        switch (bitSize) {
            case 1: {
                this.unpack1(buffer, offset, len, input);
                break;
            }
            case 2: {
                this.unpack2(buffer, offset, len, input);
                break;
            }
            case 4: {
                this.unpack4(buffer, offset, len, input);
                break;
            }
            case 8: {
                this.unpack8(buffer, offset, len, input);
                break;
            }
            case 16: {
                this.unpack16(buffer, offset, len, input);
                break;
            }
            case 24: {
                this.unpack24(buffer, offset, len, input);
                break;
            }
            case 32: {
                this.unpack32(buffer, offset, len, input);
                break;
            }
            case 40: {
                this.unpack40(buffer, offset, len, input);
                break;
            }
            case 48: {
                this.unpack48(buffer, offset, len, input);
                break;
            }
            case 56: {
                this.unpack56(buffer, offset, len, input);
                break;
            }
            case 64: {
                this.unpack64(buffer, offset, len, input);
                break;
            }
            default: {
                LongBitPacker.unpackGeneric(buffer, offset, len, bitSize, input);
            }
        }
    }

    private static void unpackGeneric(long[] buffer, int offset, int len, int bitSize, InputStream input) throws IOException {
        int bitsLeft = 0;
        int current = 0;
        for (int i = offset; i < offset + len; ++i) {
            int bitsLeftToRead;
            long result = 0L;
            for (bitsLeftToRead = bitSize; bitsLeftToRead > bitsLeft; bitsLeftToRead -= bitsLeft) {
                result <<= bitsLeft;
                result |= (long)(current & (1 << bitsLeft) - 1);
                current = input.read();
                bitsLeft = 8;
            }
            if (bitsLeftToRead > 0) {
                result <<= bitsLeftToRead;
                result |= (long)(current >> (bitsLeft -= bitsLeftToRead) & (1 << bitsLeftToRead) - 1);
            }
            buffer[i] = result;
        }
    }

    private void unpack1(long[] buffer, int offset, int len, InputStream input) throws IOException {
        if (len != 0 && len < 8) {
            LongBitPacker.unpack1Unaligned(buffer, offset, len, input.read());
            return;
        }
        int blockReadableBytes = (len + 7) / 8;
        for (int i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        int outputIndex = offset;
        int end = offset + len;
        int tmpIndex = 0;
        while (outputIndex + 7 < end) {
            long value = this.tmp[tmpIndex];
            ++tmpIndex;
            buffer[outputIndex] = (0x80L & value) >>> 7;
            buffer[outputIndex + 1] = (0x40L & value) >>> 6;
            buffer[outputIndex + 2] = (0x20L & value) >>> 5;
            buffer[outputIndex + 3] = (0x10L & value) >>> 4;
            buffer[outputIndex + 4] = (8L & value) >>> 3;
            buffer[outputIndex + 5] = (4L & value) >>> 2;
            buffer[outputIndex + 6] = (2L & value) >>> 1;
            buffer[outputIndex + 7] = 1L & value;
            outputIndex += 8;
        }
        if (outputIndex < end) {
            LongBitPacker.unpack1Unaligned(buffer, outputIndex, end - outputIndex, this.tmp[blockReadableBytes - 1]);
        }
    }

    private static void unpack1Unaligned(long[] buffer, int outputIndex, int length, int value) {
        switch (length) {
            case 7: {
                buffer[outputIndex + 6] = (2 & value) >>> 1;
            }
            case 6: {
                buffer[outputIndex + 5] = (4 & value) >>> 2;
            }
            case 5: {
                buffer[outputIndex + 4] = (8 & value) >>> 3;
            }
            case 4: {
                buffer[outputIndex + 3] = (0x10 & value) >>> 4;
            }
            case 3: {
                buffer[outputIndex + 2] = (0x20 & value) >>> 5;
            }
            case 2: {
                buffer[outputIndex + 1] = (0x40 & value) >>> 6;
            }
            case 1: {
                buffer[outputIndex] = (0x80 & value) >>> 7;
                break;
            }
        }
    }

    private void unpack2(long[] buffer, int offset, int len, InputStream input) throws IOException {
        if (len != 0 && len < 4) {
            LongBitPacker.unpack2Unaligned(buffer, offset, len, input.read());
            return;
        }
        int blockReadableBytes = (2 * len + 7) / 8;
        for (int i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        int outputIndex = offset;
        int end = offset + len;
        int tmpIndex = 0;
        while (outputIndex + 3 < end) {
            long value = this.tmp[tmpIndex];
            ++tmpIndex;
            buffer[outputIndex] = (0xC0L & value) >>> 6;
            buffer[outputIndex + 1] = (0x30L & value) >>> 4;
            buffer[outputIndex + 2] = (0xCL & value) >>> 2;
            buffer[outputIndex + 3] = 3L & value;
            outputIndex += 4;
        }
        if (outputIndex < end) {
            LongBitPacker.unpack2Unaligned(buffer, outputIndex, end - outputIndex, this.tmp[blockReadableBytes - 1]);
        }
    }

    private static void unpack2Unaligned(long[] buffer, int outputIndex, int length, int value) {
        switch (length) {
            case 3: {
                buffer[outputIndex + 2] = (0xC & value) >>> 2;
            }
            case 2: {
                buffer[outputIndex + 1] = (0x30 & value) >>> 4;
            }
            case 1: {
                buffer[outputIndex] = (0xC0 & value) >>> 6;
                break;
            }
        }
    }

    private void unpack4(long[] buffer, int offset, int len, InputStream input) throws IOException {
        if (len != 0 && len < 3) {
            int value = input.read();
            buffer[offset] = (0xF0 & value) >>> 4;
            if (len == 2) {
                buffer[offset + 1] = 0xF & value;
            }
            return;
        }
        int blockReadableBytes = (4 * len + 7) / 8;
        for (int i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        int outputIndex = offset;
        int end = offset + len;
        int tmpIndex = 0;
        while (outputIndex + 1 < end) {
            long value = this.tmp[tmpIndex];
            ++tmpIndex;
            buffer[outputIndex] = (0xF0L & value) >>> 4;
            buffer[outputIndex + 1] = 0xFL & value;
            outputIndex += 2;
        }
        if (outputIndex != end) {
            buffer[outputIndex] = (0xF0 & this.tmp[blockReadableBytes - 1]) >>> 4;
        }
    }

    private void unpack8(long[] buffer, int offset, int len, InputStream input) throws IOException {
        int i;
        for (i = 0; i < len; i += input.read(this.tmp, i, len - i)) {
        }
        for (i = 0; i < len; ++i) {
            buffer[offset + i] = 0xFFL & (long)this.tmp[i];
        }
    }

    private void unpack16(long[] buffer, int offset, int len, InputStream input) throws IOException {
        int i;
        int blockReadableBytes = len * 16 / 8;
        for (i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        for (i = 0; i < len; ++i) {
            buffer[offset + i] = 0xFFFFL & (long)Short.reverseBytes(UnsafeSlice.getShortUnchecked((Slice)this.slice, (int)(2 * i)));
        }
    }

    private void unpack24(long[] buffer, int offset, int len, InputStream input) throws IOException {
        int i;
        int blockReadableBytes = len * 24 / 8;
        for (i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        for (i = 0; i < len; ++i) {
            buffer[offset + i] = 0xFFFFFFL & (long)(Integer.reverseBytes(UnsafeSlice.getIntUnchecked((Slice)this.slice, (int)(3 * i))) >>> 8);
        }
    }

    private void unpack32(long[] buffer, int offset, int len, InputStream input) throws IOException {
        int i;
        int blockReadableBytes = len * 32 / 8;
        for (i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        for (i = 0; i < len; ++i) {
            buffer[offset + i] = 0xFFFFFFFFL & (long)Integer.reverseBytes(UnsafeSlice.getIntUnchecked((Slice)this.slice, (int)(4 * i)));
        }
    }

    private void unpack40(long[] buffer, int offset, int len, InputStream input) throws IOException {
        int i;
        int blockReadableBytes = len * 40 / 8;
        for (i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        for (i = 0; i < len; ++i) {
            buffer[offset + i] = Long.reverseBytes(UnsafeSlice.getLongUnchecked((Slice)this.slice, (int)(5 * i))) >>> 24;
        }
    }

    private void unpack48(long[] buffer, int offset, int len, InputStream input) throws IOException {
        int i;
        int blockReadableBytes = len * 48 / 8;
        for (i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        for (i = 0; i < len; ++i) {
            buffer[offset + i] = Long.reverseBytes(UnsafeSlice.getLongUnchecked((Slice)this.slice, (int)(6 * i))) >>> 16;
        }
    }

    private void unpack56(long[] buffer, int offset, int len, InputStream input) throws IOException {
        int i;
        int blockReadableBytes = len * 56 / 8;
        for (i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        for (i = 0; i < len; ++i) {
            buffer[offset + i] = Long.reverseBytes(UnsafeSlice.getLongUnchecked((Slice)this.slice, (int)(7 * i))) >>> 8;
        }
    }

    private void unpack64(long[] buffer, int offset, int len, InputStream input) throws IOException {
        int i;
        int blockReadableBytes = len * 64 / 8;
        for (i = 0; i < blockReadableBytes; i += input.read(this.tmp, i, blockReadableBytes - i)) {
        }
        for (i = 0; i < len; ++i) {
            buffer[offset + i] = Long.reverseBytes(UnsafeSlice.getLongUnchecked((Slice)this.slice, (int)(8 * i)));
        }
    }
}

