/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.Preconditions;
import io.prestosql.orc.checkpoint.LongStreamCheckpoint;
import io.prestosql.orc.stream.ValueInputStream;
import java.io.IOException;

public interface LongInputStream
extends ValueInputStream<LongStreamCheckpoint> {
    public long next() throws IOException;

    public void next(long[] var1, int var2) throws IOException;

    public void next(int[] var1, int var2) throws IOException;

    public void next(short[] var1, int var2) throws IOException;

    default public long sum(int items) throws IOException {
        long sum = 0L;
        for (int i = 0; i < items; ++i) {
            sum += this.next();
        }
        return sum;
    }

    default public void nextIntVector(int items, int[] vector, int offset) throws IOException {
        Preconditions.checkPositionIndex((int)(items + offset), (int)vector.length);
        for (int i = offset; i < items + offset; ++i) {
            vector[i] = Math.toIntExact(this.next());
        }
    }

    public int getUsedCount();
}

