/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.transport.execution.buffer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import io.hetu.core.transport.execution.buffer.PagesSerde;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class KryoPageSerializer
extends PagesSerde {
    BlockEncodingSerde serde;
    Serializer<Page> serializer = new Serializer<Page>(){

        public void write(Kryo kryo, Output output, Page page) {
            output.writeInt(page.getPositionCount());
            output.writeInt(page.getChannelCount());
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                KryoPageSerializer.this.serde.writeBlock((OutputStream)output, page.getBlock(channel));
            }
            if (page.getPageMetadata().size() > 0) {
                String pageProperties = page.getPageMetadata().toString();
                byte[] propertiesByte = pageProperties.replaceAll(",", System.lineSeparator()).substring(1, pageProperties.length() - 1).getBytes(StandardCharsets.UTF_8);
                output.writeInt(propertiesByte.length);
                output.writeBytes(propertiesByte);
            } else {
                output.writeInt(0);
            }
        }

        public Page read(Kryo kryo, Input input, Class<? extends Page> aClass) {
            int positionCount = input.readInt();
            int numberOfBlocks = input.readInt();
            Block[] blocks = new Block[numberOfBlocks];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = KryoPageSerializer.this.serde.readBlock((InputStream)input);
            }
            int propSize = input.readInt();
            if (propSize > 0) {
                byte[] pageMetadataBytes = input.readBytes(propSize);
                Properties pros = new Properties();
                try {
                    pros.load(new ByteArrayInputStream(pageMetadataBytes));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return new Page(positionCount, pros, blocks);
            }
            return new Page(positionCount, blocks);
        }
    };

    KryoPageSerializer(BlockEncodingSerde serde) {
        super(serde, Optional.empty(), Optional.empty(), Optional.empty());
        this.serde = Objects.requireNonNull(serde, "Serde Cannot be null");
    }

    @Override
    public void serialize(OutputStream output, Page page) {
        Preconditions.checkArgument((boolean)(output instanceof Output), (Object)("Page serializer does not support (" + output.getClass().getSimpleName() + ") for writing"));
        this.serializer.write(null, (Output)output, (Object)page);
    }

    @Override
    public Page deserialize(InputStream input) {
        Preconditions.checkArgument((boolean)(input instanceof Input), (Object)("Page serializer does not support (" + input.getClass().getSimpleName() + ") for reading"));
        return (Page)this.serializer.read(null, (Input)input, Page.class);
    }
}

